/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.cauldrons.compat.emi;

import cc.cassian.cauldrons.CauldronMod;
import cc.cassian.cauldrons.compat.emi.BrewingEmiRecipe;
import cc.cassian.cauldrons.compat.emi.DippingEmiRecipe;
import cc.cassian.cauldrons.core.CauldronContents;
import cc.cassian.cauldrons.core.CauldronModRecipes;
import cc.cassian.cauldrons.recipe.BrewingRecipe;
import cc.cassian.cauldrons.recipe.DippingRecipe;
import cc.cassian.cauldrons.registry.CauldronModItems;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import oshi.util.tuples.Pair;

@EmiEntrypoint
public class CauldronModEmiPlugin
implements EmiPlugin {
    public static final EmiStack CAULDRON_WORKSTATION = EmiStack.of((ItemLike)Items.CAULDRON);
    public static final EmiRecipeCategory BREWING_CATEGORY = new EmiRecipeCategory(CauldronMod.of("brewing"), (EmiRenderable)CAULDRON_WORKSTATION);
    public static final EmiRecipeCategory DIPPING_CATEGORY = new EmiRecipeCategory(CauldronMod.of("dipping"), (EmiRenderable)CAULDRON_WORKSTATION);
    public static final Map<ResourceLocation, EmiStack> OVERRIDES = Map.of(ResourceLocation.withDefaultNamespace((String)"lava_cauldron"), EmiStack.of((Fluid)Fluids.LAVA), ResourceLocation.withDefaultNamespace((String)"water_cauldron"), EmiStack.of((Fluid)Fluids.WATER), ResourceLocation.withDefaultNamespace((String)"powder_snow_cauldron"), EmiStack.of((ItemLike)Blocks.POWDER_SNOW), CauldronMod.of("lava"), EmiStack.of((Fluid)Fluids.LAVA), CauldronMod.of("empty"), EmiStack.of((ItemLike)Items.AIR), CauldronMod.of("honey"), EmiStack.of((ItemLike)((ItemLike)CauldronModItems.HONEY_CONTENTS.get())));

    static Pair<EmiStack, EmiStack> getResultForDisplay(CauldronContents resultPotion) {
        if (resultPotion.potion().isPresent()) {
            Holder<Potion> potion = resultPotion.potion().get();
            return new Pair((Object)EmiStack.of((ItemStack)PotionContents.createItemStack((Item)Items.POTION, potion)), (Object)EmiStack.of((ItemStack)PotionContents.createItemStack((Item)CauldronModItems.CAULDRON_CONTENTS.get(), potion)));
        }
        if (OVERRIDES.containsKey(resultPotion.id())) {
            EmiStack stack = OVERRIDES.get(resultPotion.id());
            return new Pair((Object)stack, (Object)stack);
        }
        EmiStack stack = EmiStack.of((ItemLike)((ItemLike)BuiltInRegistries.BLOCK.get(resultPotion.id())));
        return new Pair((Object)stack, (Object)stack);
    }

    public void register(EmiRegistry registry) {
        RecipeManager manager = registry.getRecipeManager();
        RegistryAccess access = Minecraft.getInstance().level.registryAccess();
        registry.addCategory(BREWING_CATEGORY);
        registry.addWorkstation(BREWING_CATEGORY, (EmiIngredient)CAULDRON_WORKSTATION);
        for (RecipeHolder recipe : manager.getAllRecipesFor(CauldronModRecipes.BREWING.get())) {
            registry.addRecipe((EmiRecipe)new BrewingEmiRecipe((RecipeHolder<BrewingRecipe>)recipe, access));
        }
        registry.addCategory(DIPPING_CATEGORY);
        registry.addWorkstation(DIPPING_CATEGORY, (EmiIngredient)CAULDRON_WORKSTATION);
        for (RecipeHolder recipe : manager.getAllRecipesFor(CauldronModRecipes.DIPPING.get())) {
            registry.addRecipe((EmiRecipe)new DippingEmiRecipe((RecipeHolder<DippingRecipe>)recipe, access));
        }
    }
}

