/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.cauldrons.compat.emi;

import cc.cassian.cauldrons.compat.emi.CauldronModEmiPlugin;
import cc.cassian.cauldrons.recipe.DippingRecipe;
import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import oshi.util.tuples.Pair;

public class DippingEmiRecipe
extends BasicEmiRecipe {
    private final EmiStack potionForDisplay;
    private final boolean requiresHeat;

    public DippingEmiRecipe(RecipeHolder<DippingRecipe> recipe, RegistryAccess registryAccess) {
        super(CauldronModEmiPlugin.DIPPING_CATEGORY, recipe.id(), 100, 18);
        this.inputs.add(EmiIngredient.of((Ingredient)((DippingRecipe)recipe.value()).getReagent()));
        Pair<EmiStack, EmiStack> input = CauldronModEmiPlugin.getResultForDisplay(((DippingRecipe)recipe.value()).getPotion());
        this.inputs.add(EmiIngredient.of((List)((EmiStack)input.getA()).getEmiStacks()));
        this.potionForDisplay = (EmiStack)input.getB();
        ItemStack result = ((DippingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)registryAccess);
        this.outputs.add(EmiStack.of((ItemStack)result));
        this.requiresHeat = ((DippingRecipe)recipe.value()).requiresHeat();
    }

    public void addWidgets(WidgetHolder widgetHolder) {
        ArrayList<MutableComponent> heatedText = new ArrayList<MutableComponent>();
        if (this.requiresHeat) {
            heatedText.add(Component.translatable((String)"tooltip.toil_and_trouble.heated"));
        }
        widgetHolder.addSlot((EmiIngredient)this.inputs.getFirst(), 0, 0);
        widgetHolder.addTexture(EmiTexture.PLUS, 20, 2);
        widgetHolder.addSlot((EmiIngredient)this.potionForDisplay, 36, 0);
        widgetHolder.addTexture(EmiTexture.FULL_ARROW, 56, 1).tooltipText(heatedText);
        widgetHolder.addSlot((EmiIngredient)this.getOutputs().getFirst(), 81, 0).recipeContext((EmiRecipe)this);
    }
}

