/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.cauldrons.core;

import cc.cassian.cauldrons.CauldronMod;
import com.google.common.collect.Iterables;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;

public record CauldronContents(ResourceLocation id, Optional<Holder<Potion>> potion, Optional<Integer> customColor, List<MobEffectInstance> customEffects, Integer amount, Optional<String> customName) {
    public static final CauldronContents EMPTY = new CauldronContents(ResourceLocation.withDefaultNamespace((String)"air"), Optional.empty(), Optional.empty(), List.of(), 0, Optional.empty());
    private static final Codec<CauldronContents> FULL_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.optionalFieldOf("id", (Object)ResourceLocation.withDefaultNamespace((String)"potion")).forGetter(CauldronContents::id), (App)Potion.CODEC.optionalFieldOf("potion").forGetter(CauldronContents::potion), (App)Codec.INT.optionalFieldOf("custom_color").forGetter(CauldronContents::customColor), (App)MobEffectInstance.CODEC.listOf().optionalFieldOf("custom_effects", List.of()).forGetter(CauldronContents::customEffects), (App)Codec.INT.optionalFieldOf("amount", (Object)3).forGetter(CauldronContents::amount), (App)Codec.STRING.optionalFieldOf("custom_name").forGetter(CauldronContents::customName)).apply((Applicative)instance, CauldronContents::new));
    public static final Codec<CauldronContents> CODEC = Codec.withAlternative(FULL_CODEC, (Codec)Potion.CODEC, CauldronContents::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, CauldronContents> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, CauldronContents::id, (StreamCodec)Potion.STREAM_CODEC.apply(ByteBufCodecs::optional), CauldronContents::potion, (StreamCodec)ByteBufCodecs.INT.apply(ByteBufCodecs::optional), CauldronContents::customColor, (StreamCodec)MobEffectInstance.STREAM_CODEC.apply(ByteBufCodecs.list()), CauldronContents::customEffects, (StreamCodec)ByteBufCodecs.INT, CauldronContents::amount, (StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs::optional), CauldronContents::customName, CauldronContents::new);

    public CauldronContents(Holder<Potion> potion) {
        this(ResourceLocation.withDefaultNamespace((String)"potion"), Optional.of(potion), Optional.empty(), List.of(), 3, Optional.empty());
    }

    public CauldronContents(PotionContents potion) {
        this(ResourceLocation.withDefaultNamespace((String)"potion"), potion.potion(), potion.customColor(), potion.customEffects(), 3, Optional.empty());
    }

    public CauldronContents(ResourceLocation potion) {
        this(potion, Optional.empty(), Optional.empty(), List.of(), 3, Optional.empty());
    }

    public CauldronContents(String potion) {
        this(CauldronMod.of(potion));
    }

    public static ItemStack createItemStack(Item item, CauldronContents potion) {
        ItemStack stack = item.getDefaultInstance();
        stack.set(DataComponents.POTION_CONTENTS, (Object)potion.toPotionContents());
        potion.customName.ifPresent(s -> stack.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)(item.getDescriptionId() + ".effect." + s))));
        return stack;
    }

    public boolean is(Holder<Potion> potion) {
        return this.potion.isPresent() && this.potion.get().is(potion) && this.customEffects.isEmpty();
    }

    public boolean is(ResourceLocation potion) {
        return potion.equals((Object)this.id());
    }

    public PotionContents toPotionContents() {
        return new PotionContents(this.potion, this.customColor, this.customEffects);
    }

    public int getColor() {
        return this.customColor.orElseGet(() -> {
            if (this.isPotion()) {
                return PotionContents.getColor(this.getAllEffects());
            }
            return -1;
        });
    }

    public Iterable<MobEffectInstance> getAllEffects() {
        return this.potion.map(potionHolder -> this.customEffects.isEmpty() ? ((Potion)potionHolder.value()).getEffects() : Iterables.concat((Iterable)((Potion)potionHolder.value()).getEffects(), this.customEffects)).orElse(this.customEffects);
    }

    public boolean test(CauldronContents testedContents) {
        if (this.potion.isPresent() && testedContents.potion.isPresent()) {
            return this.is(testedContents.potion.get());
        }
        return this.is(testedContents.id);
    }

    public boolean isPotion() {
        return this.is(ResourceLocation.withDefaultNamespace((String)"potion"));
    }

    public boolean is(String name) {
        return this.is(CauldronMod.of(name));
    }
}

