/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.cauldrons.core;

import cc.cassian.cauldrons.blocks.BrewingCauldronBlock;
import cc.cassian.cauldrons.blocks.entity.CauldronBlockEntity;
import cc.cassian.cauldrons.core.CauldronContents;
import cc.cassian.cauldrons.core.CauldronModRecipes;
import cc.cassian.cauldrons.recipe.BrewingRecipeInput;
import cc.cassian.cauldrons.recipe.InsertingRecipe;
import cc.cassian.cauldrons.registry.CauldronModBlocks;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;

public class CauldronModEvents {
    public static ItemInteractionResult useBlock(Player player, Level level, InteractionHand interactionHand, BlockPos pos, Direction direction) {
        BlockState blockState = level.getBlockState(pos);
        ItemStack stack = player.getItemInHand(interactionHand);
        if (blockState.is(Blocks.CAULDRON) && !stack.is(Items.WATER_BUCKET)) {
            BlockState state = CauldronModBlocks.BREWING_CAULDRON.get().defaultBlockState();
            level.setBlockAndUpdate(pos, state);
            return CauldronModEvents.insert(player.getItemInHand(interactionHand), state, level, pos, player, interactionHand, direction);
        }
        if (blockState.is(Blocks.WATER_CAULDRON) && !stack.is(Items.BUCKET)) {
            BlockState state = (BlockState)((BlockState)CauldronModBlocks.BREWING_CAULDRON.get().defaultBlockState().setValue(BrewingCauldronBlock.CONTENTS, (Comparable)((Object)BrewingCauldronBlock.Contents.WATER))).setValue((Property)BrewingCauldronBlock.POTION_QUANTITY, (Comparable)((Integer)blockState.getValue((Property)LayeredCauldronBlock.LEVEL)));
            level.setBlockAndUpdate(pos, state);
            level.setBlockEntity((BlockEntity)new CauldronBlockEntity(pos, state, new CauldronContents((Holder<Potion>)Potions.WATER)));
            return CauldronModEvents.insert(player.getItemInHand(interactionHand), state, level, pos, player, interactionHand, direction);
        }
        if (blockState.is(Blocks.LAVA_CAULDRON) && !stack.is(Items.BUCKET)) {
            BlockState state = (BlockState)((BlockState)CauldronModBlocks.BREWING_CAULDRON.get().defaultBlockState().setValue(BrewingCauldronBlock.CONTENTS, (Comparable)((Object)BrewingCauldronBlock.Contents.LAVA))).setValue((Property)BrewingCauldronBlock.POTION_QUANTITY, (Comparable)Integer.valueOf(3));
            level.setBlockAndUpdate(pos, state);
            level.setBlockEntity((BlockEntity)new CauldronBlockEntity(pos, state, new CauldronContents("lava")));
            return CauldronModEvents.insert(player.getItemInHand(interactionHand), state, level, pos, player, interactionHand, direction);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public static ItemInteractionResult insert(ItemStack itemStack, BlockState blockState, Level level, BlockPos pos, @Nullable Player player, @Nullable InteractionHand interactionHand, @Nullable Direction direction) {
        BlockEntity blockEntity;
        if (direction == null) {
            direction = Direction.UP;
        }
        if ((blockEntity = level.getBlockEntity(pos)) instanceof CauldronBlockEntity) {
            CauldronBlockEntity cauldronBlockEntity = (CauldronBlockEntity)blockEntity;
            if (!itemStack.isEmpty()) {
                if (level instanceof ServerLevel) {
                    Optional insertingRecipeRecipeHolder = level.getRecipeManager().getRecipeFor(CauldronModRecipes.INSERTING.get(), (RecipeInput)new BrewingRecipeInput(itemStack, cauldronBlockEntity.getContents(), false), level);
                    if (insertingRecipeRecipeHolder.isPresent()) {
                        InsertingRecipe recipe = (InsertingRecipe)((RecipeHolder)insertingRecipeRecipeHolder.get()).value();
                        int newFillLevel = (Integer)blockState.getValue((Property)BrewingCauldronBlock.POTION_QUANTITY) + recipe.getAmount();
                        if (newFillLevel > -1 && newFillLevel < 4) {
                            cauldronBlockEntity.setContents(recipe.getResultPotion());
                            if (player == null || !player.isCreative()) {
                                itemStack.setCount(itemStack.getCount() - 1);
                            }
                            CauldronModEvents.addItem(player, interactionHand, level, pos, direction, recipe.getResultItem((HolderLookup.Provider)level.registryAccess()));
                            BrewingCauldronBlock.setFillLevel(blockState, level, pos, newFillLevel);
                            return ItemInteractionResult.SUCCESS;
                        }
                    }
                    return CauldronModEvents.tryHardcodedRecipe(itemStack, blockState, cauldronBlockEntity, level, pos, player, interactionHand, direction);
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public static ItemInteractionResult tryHardcodedRecipe(ItemStack itemStack, BlockState blockState, CauldronBlockEntity cauldronBlockEntity, Level level, BlockPos pos, @Nullable Player player, @Nullable InteractionHand interactionHand, @Nullable Direction direction) {
        if (itemStack.is(Items.ARROW) && itemStack.getCount() >= 16 && cauldronBlockEntity.getFillLevel() >= 1) {
            int tippedCount = 16;
            int fillLevel = 1;
            if (itemStack.getCount() >= 32 && cauldronBlockEntity.getFillLevel() >= 2) {
                tippedCount = 32;
                fillLevel = 2;
            }
            if (itemStack.getCount() == 64 && cauldronBlockEntity.getFillLevel() == 3) {
                tippedCount = 64;
                fillLevel = 3;
            }
            itemStack.setCount(itemStack.getCount() - tippedCount);
            ItemStack stack = CauldronContents.createItemStack(Items.TIPPED_ARROW, cauldronBlockEntity.getContents());
            stack.setCount(tippedCount);
            BrewingCauldronBlock.setFillLevel(blockState, level, pos, cauldronBlockEntity.getFillLevel() - fillLevel);
            CauldronModEvents.addItem(player, interactionHand, level, pos, direction, stack);
            return ItemInteractionResult.CONSUME;
        }
        if (itemStack.is(Items.GLASS_BOTTLE) && cauldronBlockEntity.getContents().isPotion() && cauldronBlockEntity.getFillLevel() >= 1) {
            int fillLevel = 1;
            if (itemStack.getCount() == 2 && cauldronBlockEntity.getFillLevel() == 2) {
                fillLevel = 2;
            }
            if (itemStack.getCount() >= 3 && cauldronBlockEntity.getFillLevel() == 3) {
                fillLevel = 3;
            }
            itemStack.setCount(itemStack.getCount() - fillLevel);
            ItemStack stack = ItemStack.EMPTY;
            Item potionItem = Items.POTION;
            if (cauldronBlockEntity.isPotionSplash()) {
                potionItem = Items.SPLASH_POTION;
            } else if (cauldronBlockEntity.isPotionLingering()) {
                potionItem = Items.LINGERING_POTION;
            }
            stack = CauldronContents.createItemStack(potionItem, cauldronBlockEntity.getContents());
            stack.setCount(fillLevel);
            BrewingCauldronBlock.setFillLevel(blockState, level, pos, cauldronBlockEntity.getFillLevel() - fillLevel);
            CauldronModEvents.addItem(player, interactionHand, level, pos, direction, stack);
            return ItemInteractionResult.SUCCESS;
        }
        Pair<ItemInteractionResult, ItemStack> insert = cauldronBlockEntity.insert(itemStack.copyWithCount(1));
        if (insert.getA() != ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION) {
            if (player == null || !player.isCreative()) {
                itemStack.setCount(itemStack.getCount() - 1);
            }
            CauldronModEvents.addItem(player, interactionHand, level, pos, direction, (ItemStack)insert.getB());
        }
        return (ItemInteractionResult)insert.getA();
    }

    public static void addItem(Player player, InteractionHand interactionHand, Level level, BlockPos pos, Direction direction, ItemStack stack) {
        if (player != null) {
            if (interactionHand != null && player.getItemInHand(interactionHand).isEmpty()) {
                player.setItemInHand(interactionHand, stack);
            } else {
                player.addItem(stack);
            }
        } else {
            Block.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)direction, (ItemStack)stack);
        }
    }
}

