/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.cauldrons.recipe;

import cc.cassian.cauldrons.CauldronMod;
import cc.cassian.cauldrons.core.CauldronContents;
import cc.cassian.cauldrons.core.CauldronModRecipes;
import cc.cassian.cauldrons.recipe.BrewingRecipeInput;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class BrewingRecipe
implements Recipe<BrewingRecipeInput> {
    private final Ingredient reagent;
    private final CauldronContents potion;
    private final CauldronContents result;
    private final ParticleOptions particleType;
    private final boolean requiresHeat;

    public BrewingRecipe(Ingredient reagent, CauldronContents potion, CauldronContents result, ParticleOptions particleType, boolean requiresHeat) {
        this.reagent = reagent;
        this.potion = potion;
        this.result = result;
        this.particleType = particleType;
        this.requiresHeat = requiresHeat;
    }

    public boolean matches(BrewingRecipeInput input, Level level) {
        if (!this.requiresHeat || input.isHeated()) {
            return this.reagent.test(input.getItem(0)) && this.potion.test(input.getContents());
        }
        return false;
    }

    public ItemStack assemble(BrewingRecipeInput input, HolderLookup.Provider registries) {
        return this.getResultItem(registries);
    }

    public boolean requiresHeat() {
        return this.requiresHeat;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public NonNullList<Ingredient> getIngredients() {
        ItemStack cauldronContents = ItemStack.EMPTY;
        return NonNullList.of((Object)this.reagent, (Object[])new Ingredient[]{Ingredient.of((ItemStack[])new ItemStack[]{cauldronContents})});
    }

    public Ingredient getReagent() {
        return this.reagent;
    }

    public CauldronContents getPotion() {
        return this.potion;
    }

    public ResourceLocation getContentsId() {
        return this.potion.id();
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        if (this.result.potion().isPresent()) {
            return CauldronContents.createItemStack(Items.POTION, this.result);
        }
        return ((Block)BuiltInRegistries.BLOCK.get(this.result.id())).asItem().getDefaultInstance();
    }

    public CauldronContents getResultPotion(HolderLookup.Provider registries) {
        return this.result;
    }

    public RecipeSerializer<BrewingRecipe> getSerializer() {
        return CauldronModRecipes.BREWING_SERIALIZER.get();
    }

    public RecipeType<BrewingRecipe> getType() {
        return CauldronModRecipes.BREWING.get();
    }

    public ParticleOptions getParticleType() {
        return this.particleType;
    }

    public static class Serializer
    implements RecipeSerializer<BrewingRecipe> {
        public static final MapCodec<BrewingRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC.fieldOf("reagent").forGetter(r -> r.reagent), (App)CauldronContents.CODEC.fieldOf("potion").forGetter(r -> r.potion), (App)CauldronContents.CODEC.fieldOf("result").forGetter(r -> r.result), (App)ParticleTypes.CODEC.optionalFieldOf("particle_type", (Object)ParticleTypes.BUBBLE).forGetter(r -> r.particleType), (App)Codec.BOOL.optionalFieldOf("requires_heat", (Object)((Boolean)CauldronMod.CONFIG.requiresHeat.value())).forGetter(r -> r.requiresHeat)).apply((Applicative)inst, BrewingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, BrewingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        private static BrewingRecipe fromNetwork(RegistryFriendlyByteBuf buf) {
            Ingredient reagent = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
            CauldronContents potion = (CauldronContents)CauldronContents.STREAM_CODEC.decode((Object)buf);
            CauldronContents result = (CauldronContents)CauldronContents.STREAM_CODEC.decode((Object)buf);
            ParticleOptions particleType = (ParticleOptions)ParticleTypes.STREAM_CODEC.decode((Object)buf);
            boolean requiresHeat = buf.readBoolean();
            return new BrewingRecipe(reagent, potion, result, particleType, requiresHeat);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buf, BrewingRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.reagent);
            CauldronContents.STREAM_CODEC.encode((Object)buf, (Object)recipe.potion);
            CauldronContents.STREAM_CODEC.encode((Object)buf, (Object)recipe.result);
            ParticleTypes.STREAM_CODEC.encode((Object)buf, (Object)recipe.particleType);
            buf.writeBoolean(recipe.requiresHeat);
        }

        public MapCodec<BrewingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, BrewingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

