/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.cauldrons.recipe;

import cc.cassian.cauldrons.CauldronMod;
import cc.cassian.cauldrons.core.CauldronContents;
import cc.cassian.cauldrons.core.CauldronModRecipes;
import cc.cassian.cauldrons.recipe.BrewingRecipeInput;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class DippingRecipe
implements Recipe<BrewingRecipeInput> {
    private final Ingredient reagent;
    private final CauldronContents potion;
    private final ItemStack result;
    private final ParticleOptions particleType;
    private final boolean requiresHeat;

    public DippingRecipe(Ingredient reagent, CauldronContents potion, ItemStack result, ParticleOptions particleType, boolean requiresHeat) {
        this.reagent = reagent;
        this.potion = potion;
        this.result = result;
        this.particleType = particleType;
        this.requiresHeat = requiresHeat;
    }

    public boolean matches(BrewingRecipeInput input, Level level) {
        if (!this.requiresHeat || input.isHeated()) {
            return this.reagent.test(input.getItem(0)) && this.potion.test(input.getContents());
        }
        return false;
    }

    public ItemStack assemble(BrewingRecipeInput input, HolderLookup.Provider registries) {
        return this.result.copy();
    }

    public boolean requiresHeat() {
        return this.requiresHeat;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of((Object)this.reagent, (Object[])new Ingredient[0]);
    }

    public Ingredient getReagent() {
        return this.reagent;
    }

    public CauldronContents getPotion() {
        return this.potion;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.result.copy();
    }

    public RecipeSerializer<DippingRecipe> getSerializer() {
        return CauldronModRecipes.DIPPING_SERIALIZER.get();
    }

    public RecipeType<DippingRecipe> getType() {
        return CauldronModRecipes.DIPPING.get();
    }

    public ParticleOptions getParticleType() {
        return this.particleType;
    }

    public static class Serializer
    implements RecipeSerializer<DippingRecipe> {
        public static final MapCodec<DippingRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC.fieldOf("reagent").forGetter(r -> r.reagent), (App)CauldronContents.CODEC.fieldOf("potion").forGetter(r -> r.potion), (App)ItemStack.CODEC.fieldOf("result").forGetter(r -> r.result), (App)ParticleTypes.CODEC.optionalFieldOf("particle_type", (Object)ParticleTypes.BUBBLE).forGetter(r -> r.particleType), (App)Codec.BOOL.optionalFieldOf("requires_heat", (Object)((Boolean)CauldronMod.CONFIG.requiresHeat.value())).forGetter(r -> r.requiresHeat)).apply((Applicative)inst, DippingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, DippingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        private static DippingRecipe fromNetwork(RegistryFriendlyByteBuf buf) {
            Ingredient reagent = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
            CauldronContents potion = (CauldronContents)CauldronContents.STREAM_CODEC.decode((Object)buf);
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
            ParticleOptions particleType = (ParticleOptions)ParticleTypes.STREAM_CODEC.decode((Object)buf);
            boolean requiresHeat = buf.readBoolean();
            return new DippingRecipe(reagent, potion, result, particleType, requiresHeat);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buf, DippingRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.reagent);
            CauldronContents.STREAM_CODEC.encode((Object)buf, (Object)recipe.potion);
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)recipe.result);
            ParticleTypes.STREAM_CODEC.encode((Object)buf, (Object)recipe.particleType);
            buf.writeBoolean(recipe.requiresHeat);
        }

        public MapCodec<DippingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, DippingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

