/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.cauldrons.recipe;

import cc.cassian.cauldrons.core.CauldronContents;
import cc.cassian.cauldrons.core.CauldronModRecipes;
import cc.cassian.cauldrons.recipe.BrewingRecipeInput;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class InsertingRecipe
implements Recipe<BrewingRecipeInput> {
    private final ItemStack reagent;
    private final CauldronContents potion;
    private final ItemStack resultItem;
    private final CauldronContents resultPotion;
    private final boolean addPotionComponents;
    private final int amount;

    public InsertingRecipe(ItemStack reagent, CauldronContents currentPotion, ItemStack resultItem, CauldronContents resultPotion, boolean addPotionComponents, int amount) {
        this.reagent = reagent;
        this.potion = currentPotion;
        this.resultItem = resultItem;
        this.resultPotion = resultPotion;
        this.addPotionComponents = addPotionComponents;
        this.amount = amount;
    }

    public boolean matches(BrewingRecipeInput input, Level level) {
        return ItemStack.isSameItemSameComponents((ItemStack)this.reagent, (ItemStack)input.getItem(0)) && this.potion.test(input.getContents());
    }

    public ItemStack assemble(BrewingRecipeInput input, HolderLookup.Provider registries) {
        return this.resultItem.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of((Object)Ingredient.of((ItemStack[])new ItemStack[]{this.reagent}), (Object[])new Ingredient[0]);
    }

    public ItemStack getReagent() {
        return this.reagent;
    }

    public CauldronContents getPotion() {
        return this.potion;
    }

    public int getAmount() {
        return this.amount;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.resultItem.copy();
    }

    public RecipeSerializer<InsertingRecipe> getSerializer() {
        return CauldronModRecipes.INSERTION_SERIALIZER.get();
    }

    public RecipeType<InsertingRecipe> getType() {
        return CauldronModRecipes.INSERTING.get();
    }

    public CauldronContents getResultPotion() {
        return this.resultPotion;
    }

    public static class Serializer
    implements RecipeSerializer<InsertingRecipe> {
        public static final MapCodec<InsertingRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)ItemStack.CODEC.fieldOf("item").forGetter(r -> r.reagent), (App)CauldronContents.CODEC.fieldOf("contents").forGetter(r -> r.potion), (App)ItemStack.CODEC.fieldOf("result_item").forGetter(r -> r.resultItem), (App)CauldronContents.CODEC.fieldOf("result_contents").forGetter(r -> r.resultPotion), (App)Codec.BOOL.optionalFieldOf("add_potion_components", (Object)false).forGetter(r -> r.addPotionComponents), (App)Codec.INT.optionalFieldOf("amount", (Object)0).forGetter(r -> r.amount)).apply((Applicative)inst, InsertingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, InsertingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        private static InsertingRecipe fromNetwork(RegistryFriendlyByteBuf buf) {
            ItemStack reagent = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
            CauldronContents potion = (CauldronContents)CauldronContents.STREAM_CODEC.decode((Object)buf);
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
            CauldronContents resultPotion = (CauldronContents)CauldronContents.STREAM_CODEC.decode((Object)buf);
            boolean addPotionComponents = buf.readBoolean();
            int amount = buf.readInt();
            return new InsertingRecipe(reagent, potion, result, resultPotion, addPotionComponents, amount);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buf, InsertingRecipe recipe) {
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)recipe.reagent);
            CauldronContents.STREAM_CODEC.encode((Object)buf, (Object)recipe.potion);
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)recipe.resultItem);
            CauldronContents.STREAM_CODEC.encode((Object)buf, (Object)recipe.resultPotion);
            buf.writeBoolean(recipe.addPotionComponents);
            buf.writeInt(recipe.amount);
        }

        public MapCodec<InsertingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, InsertingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

