/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.cauldrons.registry;

import cc.cassian.cauldrons.CauldronMod;
import cc.cassian.cauldrons.blocks.BrewingCauldronBlock;
import cc.cassian.cauldrons.registry.CommonRegistry;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class CauldronModBlocks {
    public static final Supplier<Block> BREWING_CAULDRON = CauldronModBlocks.register("cauldron", BrewingCauldronBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAULDRON).lightLevel(properties -> {
        if (properties.getValue(BrewingCauldronBlock.CONTENTS) == BrewingCauldronBlock.Contents.LAVA) {
            return 15;
        }
        return 0;
    }));

    private static Supplier<Block> register(ResourceKey<Block> resourceKey, Function<BlockBehaviour.Properties, Block> function, BlockBehaviour.Properties properties) {
        return CommonRegistry.registerBlock(resourceKey.location().getPath(), () -> (Block)function.apply(properties));
    }

    private static ResourceKey<Block> registryKey(String string) {
        return ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)CauldronMod.of(string));
    }

    private static Supplier<Block> register(String string, Function<BlockBehaviour.Properties, Block> function, BlockBehaviour.Properties properties) {
        return CauldronModBlocks.register(CauldronModBlocks.registryKey(string), function, properties);
    }

    private static Supplier<Block> register(String string, BlockBehaviour.Properties properties) {
        return CauldronModBlocks.register(string, Block::new, properties);
    }

    public static void touch() {
    }
}

