/*
 * Decompiled with CFR 0.152.
 */
package me.drex.fafpatch.impl.entity;

import eu.pb4.factorytools.api.virtualentity.emuvanilla.EntityModelTransforms;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.elements.DisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.InteractionElement;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import me.drex.fafpatch.impl.FriendsAndFoesPatch;
import me.drex.fafpatch.impl.entity.LeadAttachmentElement;
import me.drex.fafpatch.impl.entity.model.EntityModelHelper;
import me.drex.fafpatch.impl.entity.model.emuvanilla.PolyModelInstance;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.EntityModel;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.Model;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.ModelPart;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3244;
import net.minecraft.class_4048;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

public class SimpleElementHolder<T extends class_1297, X extends EntityModel<T>>
extends ElementHolder {
    public static final class_2960 MAIN_LAYER = FriendsAndFoesPatch.id("main_layer");
    static final Matrix4fStack STACK = new Matrix4fStack(64);
    private final Map<PolyModelInstance<X>, Map<ModelPart, ItemDisplayElement>> elements = new IdentityHashMap<PolyModelInstance<X>, Map<ModelPart, ItemDisplayElement>>();
    protected final T entity;
    public final InteractionElement interaction;
    public final LeadAttachmentElement leadAttachment = new LeadAttachmentElement();
    final Map<class_2960, PolyModelInstance<X>> layerModels = new HashMap<class_2960, PolyModelInstance<X>>();
    final List<ConditionalLayer<?>> conditionalLayers = new ArrayList();
    private boolean hurt = false;
    private boolean noTick = true;

    public SimpleElementHolder(T entity) {
        this.entity = entity;
        VirtualElement.InteractionHandler interaction = VirtualElement.InteractionHandler.redirect(entity);
        this.interaction = new InteractionElement(interaction);
        this.interaction.setSendPositionUpdates(false);
        this.leadAttachment.setOffset(new class_243(0.0, (double)(entity.method_17682() / 2.0f), 0.0));
        this.leadAttachment.setInteractionHandler(interaction);
        this.addElement((VirtualElement)this.leadAttachment);
        this.addPassengerElement((VirtualElement)this.interaction);
    }

    public <L> void addConditionalLayer(Function<T, L> stateSupplier, class_2960 layer, Function<L, PolyModelInstance<X>> modelSupplier) {
        this.conditionalLayers.add(new ConditionalLayer<L>(stateSupplier, layer, modelSupplier));
    }

    public void setMainModel(PolyModelInstance<X> main) {
        this.setLayer(MAIN_LAYER, main);
    }

    public PolyModelInstance<X> getMainModel() {
        return this.layerModels.get(MAIN_LAYER);
    }

    public void setLayer(class_2960 id, PolyModelInstance<X> layer) {
        if (this.layerModels.get(id) == layer) {
            return;
        }
        this.replaceModel(this.layerModels.get(id), layer);
        if (layer != null) {
            this.layerModels.put(id, layer);
        } else {
            this.layerModels.remove(id);
        }
        if (!this.noTick) {
            this.tick();
        }
    }

    private void replaceModel(PolyModelInstance<X> oldModel, PolyModelInstance<X> newModel) {
        IdentityHashMap<Object, Object> oldElements = oldModel == null ? new IdentityHashMap() : new IdentityHashMap<ModelPart, ItemDisplayElement>(this.elements.get(oldModel));
        IdentityHashMap<ModelPart, ItemDisplayElement> newElements = new IdentityHashMap<ModelPart, ItemDisplayElement>();
        this.elements.remove(oldModel);
        if (newModel != null) {
            for (ModelPart part : ((Model)newModel.model()).allParts()) {
                class_1799 stack = newModel.modelParts().apply(part);
                if (stack == null) continue;
                ItemDisplayElement element = (ItemDisplayElement)oldElements.get(part);
                if (element == null) {
                    element = EntityModelHelper.createItemDisplay(stack);
                } else {
                    element.setItem(stack);
                    oldElements.remove(part);
                }
                EntityModelHelper.updateDisplayElement((DisplayElement)element, this.entity);
                newElements.put(part, element);
                this.addElement((VirtualElement)element);
            }
            this.elements.put(newModel, newElements);
        }
        for (ItemDisplayElement old : oldElements.values()) {
            this.removeElement((VirtualElement)old);
        }
    }

    public boolean startWatching(class_3244 player) {
        if (this.noTick) {
            this.onTick();
        }
        return super.startWatching(player);
    }

    protected void onTick() {
        this.noTick = false;
        this.interaction.setSize(this.entity.method_17681(), this.entity.method_17682());
        this.interaction.setCustomName(this.entity.method_5797());
        this.interaction.setCustomNameVisible(this.entity.method_5807());
        this.conditionalLayers.forEach(ConditionalLayer::tick);
        for (PolyModelInstance<X> layerModel : this.layerModels.values()) {
            this.renderModel(layerModel);
        }
        T t = this.entity;
        if (t instanceof class_1309) {
            class_1309 livingEntity = (class_1309)t;
            this.hurt = livingEntity.field_6235 > 0 || livingEntity.field_6213 > 0;
        }
        super.onTick();
    }

    private void renderModel(PolyModelInstance<X> model) {
        STACK.pushMatrix();
        class_4048 dimensions = this.entity.method_18377(this.entity.method_18376());
        STACK.translate(0.0f, -dimensions.comp_2186() / 2.0f, 0.0f);
        T t = this.entity;
        if (t instanceof class_1309) {
            boolean hurt;
            class_1309 livingEntity = (class_1309)t;
            boolean bl = hurt = livingEntity.field_6235 > 0 || livingEntity.field_6213 > 0;
            if (this.hurt != hurt) {
                Function<ModelPart, class_1799> map = hurt ? model.damagedModelParts() : model.modelParts();
                for (Map.Entry<ModelPart, ItemDisplayElement> entry : this.elements.get(model).entrySet()) {
                    entry.getValue().setItem(map.apply(entry.getKey()));
                }
            }
            EntityModelTransforms.livingEntityTransform((class_1309)livingEntity, (Matrix4f)STACK, matrix4f -> matrix4f.scale(this.getEntityScale()));
        }
        ((EntityModel)model.model()).setupAnim(this.entity);
        ((Model)model.model()).renderServerSide(STACK, (part, matrix4f, hidden) -> this.updateElement(model, part, matrix4f, hidden));
        this.renderSpecialLayers(STACK);
        STACK.popMatrix();
    }

    protected void renderSpecialLayers(Matrix4fStack stack) {
    }

    public float getEntityScale() {
        return 1.0f;
    }

    private void updateElement(PolyModelInstance<X> model, ModelPart part, Matrix4f matrix4f, boolean hidden) {
        ItemDisplayElement element = this.elements.get(model).get(part);
        if (element == null) {
            return;
        }
        List virtualElements = this.getElements();
        if (virtualElements.contains(element) && hidden) {
            this.removeElement((VirtualElement)element);
        } else if (!virtualElements.contains(element) && !hidden) {
            this.addElement((VirtualElement)element);
            element.setTeleportDuration(0);
        } else if (!hidden) {
            element.setTeleportDuration(3);
        }
        if (!hidden) {
            element.setTransformation(matrix4f);
            EntityModelHelper.updateDisplayElement((DisplayElement)element, this.entity);
            element.startInterpolationIfDirty();
        }
    }

    private class ConditionalLayer<S> {
        private final Function<T, S> stateSupplier;
        private final class_2960 layer;
        private final Function<S, PolyModelInstance<X>> modelSupplier;
        S previous;

        private ConditionalLayer(Function<T, S> stateSupplier, class_2960 layer, Function<S, PolyModelInstance<X>> modelSupplier) {
            this.stateSupplier = stateSupplier;
            this.layer = layer;
            this.modelSupplier = modelSupplier;
        }

        void tick() {
            S current = this.stateSupplier.apply(SimpleElementHolder.this.entity);
            if (!Objects.equals(current, this.previous)) {
                SimpleElementHolder.this.setLayer(this.layer, this.modelSupplier.apply(current));
            }
            this.previous = current;
        }
    }
}

