/*
 * Decompiled with CFR 0.152.
 */
package me.drex.fafpatch.impl.entity.model.animation;

import com.faboslav.friendsandfoes.common.client.render.entity.animation.animator.ModelPartAnimationType;
import com.faboslav.friendsandfoes.common.client.render.entity.animation.animator.context.ModelPartAnimationContext;
import com.faboslav.friendsandfoes.common.entity.animation.animator.context.AnimationContextTracker;
import me.drex.fafpatch.impl.entity.animation.animator.ModelPartAnimator;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.ModelPart;
import org.joml.Vector3f;

public final class ModelPartModelAnimator {
    public static void animateModelPartXPositionWithProgress(AnimationContextTracker animationContextTracker, ModelPart modelPart, float targetX, float progress) {
        ModelPartModelAnimator.animateModelPartPositionWithProgress(animationContextTracker, modelPart, targetX, modelPart.y, modelPart.z, progress);
    }

    public static void animateModelPartYPositionWithProgress(AnimationContextTracker animationContextTracker, ModelPart modelPart, float targetY, float progress) {
        ModelPartModelAnimator.animateModelPartPositionWithProgress(animationContextTracker, modelPart, modelPart.x, targetY, modelPart.z, progress);
    }

    public static void animateModelPartZPositionWithProgress(AnimationContextTracker animationContextTracker, ModelPart modelPart, float targetZ, float progress) {
        ModelPartModelAnimator.animateModelPartPositionWithProgress(animationContextTracker, modelPart, modelPart.x, modelPart.y, targetZ, progress);
    }

    public static void animateModelPartPositionWithProgress(AnimationContextTracker animationContextTracker, ModelPart modelPart, float targetX, float targetY, float targetZ, float progress) {
        Vector3f targetVector = new Vector3f(targetX, targetY, targetZ);
        ModelPartModelAnimator.animateWithProgress(animationContextTracker, modelPart, ModelPartAnimationType.POSITION, targetVector, progress);
    }

    public static void animateModelPartXRotationBasedOnProgress(AnimationContextTracker animationContextTracker, ModelPart modelPart, float targetX, float progress) {
        ModelPartModelAnimator.animateModelPartRotationBasedOnProgress(animationContextTracker, modelPart, targetX, modelPart.yRot, modelPart.zRot, progress);
    }

    public static void animateModelPartYRotationBasedOnProgress(AnimationContextTracker animationContextTracker, ModelPart modelPart, float targetY, float progress) {
        ModelPartModelAnimator.animateModelPartRotationBasedOnProgress(animationContextTracker, modelPart, modelPart.xRot, targetY, modelPart.zRot, progress);
    }

    public static void animateZRotationBasedOnProgress(AnimationContextTracker animationContextTracker, ModelPart modelPart, float targetZ, float progress) {
        ModelPartModelAnimator.animateModelPartRotationBasedOnProgress(animationContextTracker, modelPart, targetZ, modelPart.yRot, modelPart.zRot, progress);
    }

    public static void animateModelPartRotationBasedOnProgress(AnimationContextTracker animationContextTracker, ModelPart modelPart, float targetX, float targetY, float targetZ, float progress) {
        Vector3f targetVector = new Vector3f(targetX, targetY, targetZ);
        ModelPartModelAnimator.animateWithProgress(animationContextTracker, modelPart, ModelPartAnimationType.ROTATION, targetVector, progress);
    }

    private static void animateWithProgress(AnimationContextTracker animationContextTracker, ModelPart modelPart, ModelPartAnimationType animationType, Vector3f targetVector, float progress) {
        Vector3f animationCurrentVector;
        ModelPartAnimationContext animationContext;
        String modelPartName = modelPart.toString();
        if (animationContextTracker.contains(modelPartName, animationType)) {
            animationContext = animationContextTracker.get(modelPartName, animationType);
            animationCurrentVector = animationContext.getCurrentVector();
            Vector3f animationTargetVector = animationContext.getTargetVector();
            if (!animationTargetVector.equals((Object)targetVector)) {
                animationContextTracker.remove(modelPartName, animationType);
                animationContext = ModelPartAnimationContext.createWithProgress((float)progress, (Vector3f)targetVector, (Vector3f)animationCurrentVector);
                animationContextTracker.add(modelPartName, animationType, animationContext);
            }
        } else {
            animationCurrentVector = switch (animationType) {
                default -> throw new MatchException(null, null);
                case ModelPartAnimationType.POSITION -> new Vector3f(modelPart.x, modelPart.y, modelPart.z);
                case ModelPartAnimationType.ROTATION -> new Vector3f(modelPart.xRot, modelPart.yRot, modelPart.zRot);
            };
            animationContext = ModelPartAnimationContext.createWithProgress((float)progress, (Vector3f)targetVector, (Vector3f)animationCurrentVector);
            animationContextTracker.add(modelPartName, animationType, animationContext);
        }
        animationContext.setProgress(progress);
        animationContext.recalculateCurrentVector();
        animationCurrentVector = animationContext.getCurrentVector();
        switch (animationType) {
            case POSITION: {
                ModelPartAnimator.setPosition(modelPart, animationCurrentVector);
                break;
            }
            case ROTATION: {
                ModelPartAnimator.setRotation(modelPart, animationCurrentVector);
            }
        }
    }

    public static void animateModelPartXPositionBasedOnTicks(AnimationContextTracker animationContextTracker, ModelPart modelPart, int currentEntityTick, float targetX, int ticks) {
        ModelPartModelAnimator.animateModelPartPositionBasedOnTicks(animationContextTracker, modelPart, currentEntityTick, targetX, modelPart.y, modelPart.z, ticks);
    }

    public static void animateModelPartYPositionBasedOnTicks(AnimationContextTracker animationContextTracker, ModelPart modelPart, int currentEntityTick, float targetY, int ticks) {
        ModelPartModelAnimator.animateModelPartPositionBasedOnTicks(animationContextTracker, modelPart, currentEntityTick, modelPart.x, targetY, modelPart.z, ticks);
    }

    public static void animateZPositionBasedOnTicks(AnimationContextTracker animationContextTracker, ModelPart modelPart, int currentEntityTick, float targetX, int ticks) {
        ModelPartModelAnimator.animateModelPartPositionBasedOnTicks(animationContextTracker, modelPart, currentEntityTick, targetX, modelPart.y, modelPart.z, ticks);
    }

    public static void animateModelPartPositionBasedOnTicks(AnimationContextTracker animationContextTracker, ModelPart modelPart, int currentEntityTick, float targetX, float targetY, float targetZ, int ticks) {
        Vector3f targetVector = new Vector3f(targetX, targetY, targetZ);
        ModelPartModelAnimator.animateModelPartBasedOnTicks(animationContextTracker, modelPart, currentEntityTick, ModelPartAnimationType.POSITION, targetVector, ticks);
    }

    public static void animateModelPartXRotationBasedOnTicks(AnimationContextTracker animationContextTracker, ModelPart modelPart, int currentEntityTick, float targetX, int ticks) {
        ModelPartModelAnimator.animateModelPartRotationBasedOnTicks(animationContextTracker, modelPart, currentEntityTick, targetX, modelPart.yRot, modelPart.zRot, ticks);
    }

    public static void animateModelPartYRotationBasedOnTicks(AnimationContextTracker animationContextTracker, ModelPart modelPart, int currentEntityTick, float targetY, int ticks) {
        ModelPartModelAnimator.animateModelPartRotationBasedOnTicks(animationContextTracker, modelPart, currentEntityTick, modelPart.xRot, targetY, modelPart.zRot, ticks);
    }

    public static void animateModelPartZRotationBasedOnTicks(AnimationContextTracker animationContextTracker, ModelPart modelPart, int currentEntityTick, float targetZ, int ticks) {
        ModelPartModelAnimator.animateModelPartRotationBasedOnTicks(animationContextTracker, modelPart, currentEntityTick, modelPart.yRot, modelPart.zRot, targetZ, ticks);
    }

    public static void animateModelPartRotationBasedOnTicks(AnimationContextTracker animationContextTracker, ModelPart modelPart, int currentEntityTick, float targetX, float targetY, float targetZ, int ticks) {
        Vector3f targetVector = new Vector3f(targetX, targetY, targetZ);
        ModelPartModelAnimator.animateModelPartBasedOnTicks(animationContextTracker, modelPart, currentEntityTick, ModelPartAnimationType.ROTATION, targetVector, ticks);
    }

    private static void animateModelPartBasedOnTicks(AnimationContextTracker animationContextTracker, ModelPart modelPart, int currentEntityTick, ModelPartAnimationType animationType, Vector3f targetVector, int ticks) {
        Vector3f currentVector;
        ModelPartAnimationContext animationContext;
        String modelPartName = modelPart.toString();
        if (animationContextTracker.contains(modelPartName, animationType)) {
            animationContext = animationContextTracker.get(modelPartName, animationType);
            currentVector = animationContext.getCurrentVector();
            if (currentVector.equals((Object)targetVector)) {
                switch (animationType) {
                    case POSITION: {
                        ModelPartAnimator.setPosition(modelPart, targetVector);
                        break;
                    }
                    case ROTATION: {
                        ModelPartAnimator.setRotation(modelPart, targetVector);
                    }
                }
                return;
            }
            Vector3f animationTargetVector = animationContext.getTargetVector();
            if (!animationTargetVector.equals((Object)targetVector)) {
                animationContextTracker.remove(modelPartName, animationType);
                animationContext = ModelPartAnimationContext.createWithTicks((int)currentEntityTick, (int)ticks, (Vector3f)targetVector, (Vector3f)currentVector);
                animationContextTracker.add(modelPartName, animationType, animationContext);
            }
        } else {
            currentVector = switch (animationType) {
                default -> throw new MatchException(null, null);
                case ModelPartAnimationType.POSITION -> new Vector3f(modelPart.x, modelPart.y, modelPart.z);
                case ModelPartAnimationType.ROTATION -> new Vector3f(modelPart.xRot, modelPart.yRot, modelPart.zRot);
            };
            animationContext = ModelPartAnimationContext.createWithTicks((int)currentEntityTick, (int)ticks, (Vector3f)targetVector, (Vector3f)currentVector);
            animationContextTracker.add(modelPartName, animationType, animationContext);
        }
        animationContext.setCurrentTick(currentEntityTick);
        animationContext.recalculateProgress();
        animationContext.recalculateCurrentVector();
        currentVector = animationContext.getCurrentVector();
        switch (animationType) {
            case POSITION: {
                ModelPartAnimator.setPosition(modelPart, currentVector);
                break;
            }
            case ROTATION: {
                ModelPartAnimator.setRotation(modelPart, currentVector);
            }
        }
    }
}

