/*
 * Decompiled with CFR 0.152.
 */
package me.drex.fafpatch.impl.entity.model.emuvanilla.animation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import me.drex.fafpatch.impl.entity.model.emuvanilla.animation.AnimationChannel;
import me.drex.fafpatch.impl.entity.model.emuvanilla.animation.AnimationDefinition;
import me.drex.fafpatch.impl.entity.model.emuvanilla.animation.Keyframe;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.ModelPart;
import net.minecraft.class_3532;
import net.minecraft.class_7094;
import org.joml.Vector3f;

public class KeyframeAnimation {
    private final AnimationDefinition definition;
    private final List<Entry> entries;
    private final Vector3f scratchVector = new Vector3f();

    private KeyframeAnimation(AnimationDefinition animationDefinition, List<Entry> list) {
        this.definition = animationDefinition;
        this.entries = list;
    }

    static KeyframeAnimation bake(ModelPart modelPart, AnimationDefinition animationDefinition) {
        ArrayList<Entry> list = new ArrayList<Entry>();
        Function<String, ModelPart> function = modelPart.createPartLookup();
        for (Map.Entry<String, List<AnimationChannel>> entry : animationDefinition.boneAnimations().entrySet()) {
            String string = entry.getKey();
            List<AnimationChannel> list2 = entry.getValue();
            ModelPart modelPart2 = function.apply(string);
            if (modelPart2 == null) {
                throw new IllegalArgumentException("Cannot animate " + string + ", which does not exist in model");
            }
            for (AnimationChannel animationChannel : list2) {
                list.add(new Entry(modelPart2, animationChannel.target(), animationChannel.keyframes()));
            }
        }
        return new KeyframeAnimation(animationDefinition, List.copyOf(list));
    }

    public void applyStatic() {
        this.apply(0L, 1.0f);
    }

    public void applyWalk(float f, float g, float h, float i) {
        long l = (long)(f * 50.0f * h);
        float j = Math.min(g * i, 1.0f);
        this.apply(l, j);
    }

    public void apply(class_7094 animationState, float f) {
        this.apply(animationState, f, 1.0f);
    }

    public void apply(class_7094 animationState, float f, float g) {
        animationState.method_41323(animationStatex -> this.apply((long)((float)animationStatex.method_61400(f) * g), 1.0f));
    }

    public void apply(long l, float f) {
        float g = this.getElapsedSeconds(l);
        for (Entry entry : this.entries) {
            entry.apply(g, f, this.scratchVector);
        }
    }

    private float getElapsedSeconds(long l) {
        float f = (float)l / 1000.0f;
        return this.definition.looping() ? f % this.definition.lengthInSeconds() : f;
    }

    record Entry(ModelPart part, AnimationChannel.Target target, Keyframe[] keyframes) {
        public void apply(float f, float g, Vector3f vector3f) {
            int i = Math.max(0, class_3532.method_15360((int)0, (int)this.keyframes.length, ix -> f <= this.keyframes[ix].timestamp()) - 1);
            int j = Math.min(this.keyframes.length - 1, i + 1);
            Keyframe keyframe = this.keyframes[i];
            Keyframe keyframe2 = this.keyframes[j];
            float h = f - keyframe.timestamp();
            float k = j != i ? class_3532.method_15363((float)(h / (keyframe2.timestamp() - keyframe.timestamp())), (float)0.0f, (float)1.0f) : 0.0f;
            keyframe2.interpolation().apply(vector3f, k, this.keyframes, i, j, g);
            this.target.apply(this.part, vector3f);
        }
    }
}

