/*
 * Decompiled with CFR 0.152.
 */
package me.drex.fafpatch.impl.entity.model.entity;

import eu.pb4.factorytools.api.virtualentity.emuvanilla.EntityValueExtraction;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.AnimationUtils;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.CubeDeformation;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.CubeListBuilder;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.EntityModel;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.LayerDefinition;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.MeshDefinition;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.ModelPart;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.PartDefinition;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.PartPose;
import net.minecraft.class_1306;
import net.minecraft.class_1543;
import net.minecraft.class_1764;
import net.minecraft.class_1799;
import net.minecraft.class_3532;
import org.joml.Matrix4fStack;

public class IllagerModel<S extends class_1543>
extends EntityModel<S> {
    private final ModelPart head;
    private final ModelPart hat;
    private final ModelPart arms;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;
    private final ModelPart rightArm;
    private final ModelPart leftArm;

    public IllagerModel(ModelPart modelPart) {
        super(modelPart);
        this.head = modelPart.getChild("head");
        this.hat = this.head.getChild("hat");
        this.arms = modelPart.getChild("arms");
        this.leftLeg = modelPart.getChild("left_leg");
        this.rightLeg = modelPart.getChild("right_leg");
        this.leftArm = modelPart.getChild("left_arm");
        this.rightArm = modelPart.getChild("right_arm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition partDefinition2 = partDefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f), PartPose.offset(0.0f, 0.0f, 0.0f));
        partDefinition2.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 12.0f, 8.0f, new CubeDeformation(0.45f)), PartPose.ZERO);
        partDefinition2.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(24, 0).addBox(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f), PartPose.offset(0.0f, -2.0f, 0.0f));
        partDefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 20).addBox(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f).texOffs(0, 38).addBox(-4.0f, 0.0f, -3.0f, 8.0f, 20.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.offset(0.0f, 0.0f, 0.0f));
        PartDefinition partDefinition3 = partDefinition.addOrReplaceChild("arms", CubeListBuilder.create().texOffs(44, 22).addBox(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f).texOffs(40, 38).addBox(-4.0f, 2.0f, -2.0f, 8.0f, 4.0f, 4.0f), PartPose.offsetAndRotation(0.0f, 3.0f, -1.0f, -0.75f, 0.0f, 0.0f));
        partDefinition3.addOrReplaceChild("left_shoulder", CubeListBuilder.create().texOffs(44, 22).mirror().addBox(4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f), PartPose.ZERO);
        partDefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 22).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset(-2.0f, 12.0f, 0.0f));
        partDefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 22).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset(2.0f, 12.0f, 0.0f));
        partDefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 46).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset(-5.0f, 2.0f, 0.0f));
        partDefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(40, 46).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset(5.0f, 2.0f, 0.0f));
        return LayerDefinition.create(meshDefinition, 64, 64);
    }

    @Override
    public void setupAnim(S illagerEntity) {
        super.setupAnim(illagerEntity);
        this.head.yRot = EntityValueExtraction.getRelativeHeadYaw(illagerEntity) * ((float)Math.PI / 180);
        this.head.xRot = illagerEntity.method_36455() * ((float)Math.PI / 180);
        if (illagerEntity.method_5765()) {
            this.rightArm.xRot = -0.62831855f;
            this.rightArm.yRot = 0.0f;
            this.rightArm.zRot = 0.0f;
            this.leftArm.xRot = -0.62831855f;
            this.leftArm.yRot = 0.0f;
            this.leftArm.zRot = 0.0f;
            this.rightLeg.xRot = -1.4137167f;
            this.rightLeg.yRot = 0.31415927f;
            this.rightLeg.zRot = 0.07853982f;
            this.leftLeg.xRot = -1.4137167f;
            this.leftLeg.yRot = -0.31415927f;
            this.leftLeg.zRot = -0.07853982f;
        } else {
            float f = ((class_1543)illagerEntity).field_42108.method_48570(1.0f);
            float g = ((class_1543)illagerEntity).field_42108.method_48572(1.0f);
            this.rightArm.xRot = class_3532.method_15362((float)(g * 0.6662f + (float)Math.PI)) * 2.0f * f * 0.5f;
            this.rightArm.yRot = 0.0f;
            this.rightArm.zRot = 0.0f;
            this.leftArm.xRot = class_3532.method_15362((float)(g * 0.6662f)) * 2.0f * f * 0.5f;
            this.leftArm.yRot = 0.0f;
            this.leftArm.zRot = 0.0f;
            this.rightLeg.xRot = class_3532.method_15362((float)(g * 0.6662f)) * 1.4f * f * 0.5f;
            this.rightLeg.yRot = 0.0f;
            this.rightLeg.zRot = 0.0f;
            this.leftLeg.xRot = class_3532.method_15362((float)(g * 0.6662f + (float)Math.PI)) * 1.4f * f * 0.5f;
            this.leftLeg.yRot = 0.0f;
            this.leftLeg.zRot = 0.0f;
        }
        class_1543.class_1544 illagerArmPose = illagerEntity.method_6990();
        if (illagerArmPose == class_1543.class_1544.field_7211) {
            if (illagerEntity.method_6047().method_7960()) {
                AnimationUtils.animateZombieArms(this.leftArm, this.rightArm, true, ((class_1543)illagerEntity).field_6251, ((class_1543)illagerEntity).field_6012);
            } else {
                AnimationUtils.swingWeaponDown(this.rightArm, this.leftArm, illagerEntity.method_6068(), ((class_1543)illagerEntity).field_6251, ((class_1543)illagerEntity).field_6012);
            }
        } else if (illagerArmPose == class_1543.class_1544.field_7212) {
            this.rightArm.z = 0.0f;
            this.rightArm.x = -5.0f;
            this.leftArm.z = 0.0f;
            this.leftArm.x = 5.0f;
            this.rightArm.xRot = class_3532.method_15362((float)((float)((class_1543)illagerEntity).field_6012 * 0.6662f)) * 0.25f;
            this.leftArm.xRot = class_3532.method_15362((float)((float)((class_1543)illagerEntity).field_6012 * 0.6662f)) * 0.25f;
            this.rightArm.zRot = 2.3561945f;
            this.leftArm.zRot = -2.3561945f;
            this.rightArm.yRot = 0.0f;
            this.leftArm.yRot = 0.0f;
        } else if (illagerArmPose == class_1543.class_1544.field_7208) {
            this.rightArm.yRot = -0.1f + this.head.yRot;
            this.rightArm.xRot = -1.5707964f + this.head.xRot;
            this.leftArm.xRot = -0.9424779f + this.head.xRot;
            this.leftArm.yRot = this.head.yRot - 0.4f;
            this.leftArm.zRot = 1.5707964f;
        } else if (illagerArmPose == class_1543.class_1544.field_7213) {
            AnimationUtils.animateCrossbowHold(this.rightArm, this.leftArm, this.head, true);
        } else if (illagerArmPose == class_1543.class_1544.field_7210) {
            int maxCrossbowChargeDuration = illagerEntity.method_6990() == class_1543.class_1544.field_7210 ? class_1764.method_7775((class_1799)illagerEntity.method_6030(), illagerEntity) : 0;
            AnimationUtils.animateCrossbowCharge(this.rightArm, this.leftArm, maxCrossbowChargeDuration, illagerEntity.method_6048(), true);
        } else if (illagerArmPose == class_1543.class_1544.field_19012) {
            this.rightArm.z = 0.0f;
            this.rightArm.x = -5.0f;
            this.rightArm.xRot = class_3532.method_15362((float)((float)((class_1543)illagerEntity).field_6012 * 0.6662f)) * 0.05f;
            this.rightArm.zRot = 2.670354f;
            this.rightArm.yRot = 0.0f;
            this.leftArm.z = 0.0f;
            this.leftArm.x = 5.0f;
            this.leftArm.xRot = class_3532.method_15362((float)((float)((class_1543)illagerEntity).field_6012 * 0.6662f)) * 0.05f;
            this.leftArm.zRot = -2.3561945f;
            this.leftArm.yRot = 0.0f;
        }
        boolean bl = illagerArmPose == class_1543.class_1544.field_7207;
        this.arms.visible = bl;
        this.leftArm.visible = !bl;
        this.rightArm.visible = !bl;
    }

    public ModelPart getArm(class_1306 humanoidArm) {
        if (humanoidArm == class_1306.field_6182) {
            return this.leftArm;
        }
        return this.rightArm;
    }

    public ModelPart getHat() {
        return this.hat;
    }

    public void translateToHand(class_1306 humanoidArm, Matrix4fStack stack) {
        this.root.applyTransform(stack);
        this.getArm(humanoidArm).applyTransform(stack);
    }
}

