/*
 * Decompiled with CFR 0.152.
 */
package me.drex.fafpatch.impl.entity.animation.animator;

import com.faboslav.friendsandfoes.common.entity.animation.AnimationChannel;
import com.faboslav.friendsandfoes.common.entity.animation.AnimationDefinition;
import com.faboslav.friendsandfoes.common.entity.animation.animator.Keyframe;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.EntityModel;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.ModelPart;
import net.minecraft.class_3532;
import org.joml.Vector3f;

public final class KeyframeAnimator {
    public static void animateKeyframe(EntityModel<?> model, AnimationDefinition animationDefinition, long runningTime, float scale, Vector3f vector3f, float speedModifier) {
        float g = KeyframeAnimator.getElapsedSeconds(animationDefinition, runningTime, speedModifier);
        for (Map.Entry entry : animationDefinition.boneAnimations().entrySet()) {
            Optional<ModelPart> optional = KeyframeAnimator.getAnyDescendantWithName(model, (String)entry.getKey());
            List channels = (List)entry.getValue();
            optional.ifPresent(modelPart -> channels.forEach(animationChannel -> {
                Keyframe[] keyframes = animationChannel.keyframes();
                int i = Math.max(0, class_3532.method_15360((int)0, (int)keyframes.length, ix -> g <= keyframes[ix].timestamp() * speedModifier) - 1);
                int j = Math.min(keyframes.length - 1, i + 1);
                Keyframe keyframe = keyframes[i];
                Keyframe keyframe2 = keyframes[j];
                float h = g - keyframe.timestamp() * speedModifier;
                float k = j != i ? class_3532.method_15363((float)(h / ((keyframe2.timestamp() - keyframe.timestamp()) * speedModifier)), (float)0.0f, (float)1.0f) : 0.0f;
                keyframe2.interpolation().apply(vector3f, k, keyframes, i, j, scale);
                AnimationChannel.Target target = animationChannel.target();
                if (target == AnimationChannel.Target.POSITION) {
                    modelPart.offsetPos(vector3f);
                } else if (target == AnimationChannel.Target.ROTATION) {
                    modelPart.offsetRotation(vector3f);
                } else if (target == AnimationChannel.Target.SCALE) {
                    modelPart.offsetScale(vector3f);
                }
            }));
        }
    }

    private static Optional<ModelPart> getAnyDescendantWithName(EntityModel<?> model, String name) {
        return name.equals("root") ? Optional.of(model.root()) : model.root().getAllParts().stream().filter(modelPart -> modelPart.hasChild(name)).findFirst().map(modelPart -> modelPart.getChild(name));
    }

    private static float getElapsedSeconds(AnimationDefinition animationDefinition, long l, float speedModifier) {
        float f = (float)l / 1000.0f;
        return animationDefinition.looping() ? f % (animationDefinition.lengthInSeconds() * speedModifier) : f;
    }
}

