/*
 * Decompiled with CFR 0.152.
 */
package me.drex.fafpatch.impl.entity.model.emuvanilla.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import me.drex.fafpatch.impl.entity.model.emuvanilla.CubeConsumer;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.PartPose;
import net.minecraft.class_2350;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5819;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class ModelPart {
    public static final float DEFAULT_SCALE = 1.0f;
    public float x;
    public float y;
    public float z;
    public float xRot;
    public float yRot;
    public float zRot;
    public float xScale = 1.0f;
    public float yScale = 1.0f;
    public float zScale = 1.0f;
    public boolean visible = true;
    public boolean skipDraw;
    private final List<Cube> cubes;
    private final Map<String, ModelPart> children;
    private PartPose initialPose = PartPose.ZERO;

    public ModelPart(List<Cube> list, Map<String, ModelPart> map) {
        this.cubes = list;
        this.children = map;
    }

    public PartPose storePose() {
        return PartPose.offsetAndRotation(this.x, this.y, this.z, this.xRot, this.yRot, this.zRot);
    }

    public PartPose getInitialPose() {
        return this.initialPose;
    }

    public void setInitialPose(PartPose partPose) {
        this.initialPose = partPose;
    }

    public void resetPose() {
        this.loadPose(this.initialPose);
    }

    public void loadPose(PartPose partPose) {
        this.x = partPose.x();
        this.y = partPose.y();
        this.z = partPose.z();
        this.xRot = partPose.xRot();
        this.yRot = partPose.yRot();
        this.zRot = partPose.zRot();
        this.xScale = partPose.xScale();
        this.yScale = partPose.yScale();
        this.zScale = partPose.zScale();
    }

    public void copyFrom(ModelPart modelPart) {
        this.xScale = modelPart.xScale;
        this.yScale = modelPart.yScale;
        this.zScale = modelPart.zScale;
        this.xRot = modelPart.xRot;
        this.yRot = modelPart.yRot;
        this.zRot = modelPart.zRot;
        this.x = modelPart.x;
        this.y = modelPart.y;
        this.z = modelPart.z;
    }

    public boolean hasChild(String string) {
        return this.children.containsKey(string);
    }

    public ModelPart getChild(String string) {
        ModelPart modelPart = this.children.get(string);
        if (modelPart == null) {
            throw new NoSuchElementException("Can't find part " + string);
        }
        return modelPart;
    }

    public void setPos(float f, float g, float h) {
        this.x = f;
        this.y = g;
        this.z = h;
    }

    public void setRotation(float f, float g, float h) {
        this.xRot = f;
        this.yRot = g;
        this.zRot = h;
    }

    public void renderServerSide(Matrix4fStack matrices, CubeConsumer vertices) {
        this.renderServerSide(matrices, vertices, this.visible);
    }

    public void renderServerSide(Matrix4fStack matrices, CubeConsumer vertices, boolean visible) {
        if (!this.cubes.isEmpty() || !this.children.isEmpty()) {
            matrices.pushMatrix();
            this.applyTransform(matrices);
            vertices.consume(this, (Matrix4f)matrices, !visible);
            for (ModelPart modelPart : this.children.values()) {
                modelPart.renderServerSide(matrices, vertices, visible && modelPart.visible);
            }
            matrices.popMatrix();
        }
    }

    public void render(class_4587 poseStack, class_4588 vertexConsumer, int i, int j) {
        this.render(poseStack, vertexConsumer, i, j, -1);
    }

    public void render(class_4587 poseStack, class_4588 vertexConsumer, int i, int j, int k) {
        if (!(!this.visible || this.cubes.isEmpty() && this.children.isEmpty())) {
            poseStack.method_22903();
            this.translateAndRotate(poseStack);
            if (!this.skipDraw) {
                this.compile(poseStack.method_23760(), vertexConsumer, i, j, k);
            }
            for (ModelPart modelPart : this.children.values()) {
                modelPart.render(poseStack, vertexConsumer, i, j, k);
            }
            poseStack.method_22909();
        }
    }

    public void rotateBy(Quaternionf quaternionf) {
        Matrix3f matrix3f = new Matrix3f().rotationZYX(this.zRot, this.yRot, this.xRot);
        Matrix3f matrix3f2 = matrix3f.rotate((Quaternionfc)quaternionf);
        Vector3f vector3f = matrix3f2.getEulerAnglesZYX(new Vector3f());
        this.setRotation(vector3f.x, vector3f.y, vector3f.z);
    }

    public void getExtentsForGui(class_4587 poseStack, Set<Vector3f> set) {
        this.visit(poseStack, (pose, string, i, cube) -> {
            for (Polygon polygon : cube.polygons) {
                for (Vertex vertex : polygon.vertices()) {
                    float f = vertex.pos().x() / 16.0f;
                    float g = vertex.pos().y() / 16.0f;
                    float h = vertex.pos().z() / 16.0f;
                    Vector3f vector3f = pose.method_23761().transformPosition(f, g, h, new Vector3f());
                    set.add(vector3f);
                }
            }
        });
    }

    public void visit(class_4587 poseStack, Visitor visitor) {
        this.visit(poseStack, visitor, "");
    }

    private void visit(class_4587 poseStack, Visitor visitor, String string) {
        if (!this.cubes.isEmpty() || !this.children.isEmpty()) {
            poseStack.method_22903();
            this.translateAndRotate(poseStack);
            class_4587.class_4665 pose = poseStack.method_23760();
            for (int i = 0; i < this.cubes.size(); ++i) {
                visitor.visit(pose, string, i, this.cubes.get(i));
            }
            this.children.forEach((string2, modelPart) -> modelPart.visit(poseStack, visitor, string2 + string2));
            poseStack.method_22909();
        }
    }

    public void applyTransform(Matrix4fStack matrices) {
        matrices.translate(this.x / 16.0f, this.y / 16.0f, this.z / 16.0f);
        if (this.xRot != 0.0f || this.yRot != 0.0f || this.zRot != 0.0f) {
            matrices.rotate((Quaternionfc)new Quaternionf().rotationZYX(this.zRot, this.yRot, this.xRot));
        }
        if (this.xScale != 1.0f || this.yScale != 1.0f || this.zScale != 1.0f) {
            matrices.scale(this.xScale, this.yScale, this.zScale);
        }
    }

    public void translateAndRotate(class_4587 poseStack) {
        poseStack.method_46416(this.x / 16.0f, this.y / 16.0f, this.z / 16.0f);
        if (this.xRot != 0.0f || this.yRot != 0.0f || this.zRot != 0.0f) {
            poseStack.method_22907((Quaternionfc)new Quaternionf().rotationZYX(this.zRot, this.yRot, this.xRot));
        }
        if (this.xScale != 1.0f || this.yScale != 1.0f || this.zScale != 1.0f) {
            poseStack.method_22905(this.xScale, this.yScale, this.zScale);
        }
    }

    private void compile(class_4587.class_4665 pose, class_4588 vertexConsumer, int i, int j, int k) {
        for (Cube cube : this.cubes) {
            cube.compile(pose, vertexConsumer, i, j, k);
        }
    }

    public List<Cube> getCubes() {
        return this.cubes;
    }

    public Cube getRandomCube(class_5819 randomSource) {
        return this.cubes.get(randomSource.method_43048(this.cubes.size()));
    }

    public boolean isEmpty() {
        return this.cubes.isEmpty();
    }

    public void offsetPos(Vector3f vector3f) {
        this.x += vector3f.x();
        this.y += vector3f.y();
        this.z += vector3f.z();
    }

    public void offsetRotation(Vector3f vector3f) {
        this.xRot += vector3f.x();
        this.yRot += vector3f.y();
        this.zRot += vector3f.z();
    }

    public void offsetScale(Vector3f vector3f) {
        this.xScale += vector3f.x();
        this.yScale += vector3f.y();
        this.zScale += vector3f.z();
    }

    public List<ModelPart> getAllParts() {
        ArrayList<ModelPart> list = new ArrayList<ModelPart>();
        list.add(this);
        this.addAllChildren((string, modelPart) -> list.add((ModelPart)modelPart));
        return List.copyOf(list);
    }

    public Function<String, ModelPart> createPartLookup() {
        HashMap<String, ModelPart> map = new HashMap<String, ModelPart>();
        map.put("root", this);
        Objects.requireNonNull(map);
        this.addAllChildren(map::putIfAbsent);
        Objects.requireNonNull(map);
        return map::get;
    }

    private void addAllChildren(BiConsumer<String, ModelPart> biConsumer) {
        for (Map.Entry<String, ModelPart> entry : this.children.entrySet()) {
            biConsumer.accept(entry.getKey(), entry.getValue());
        }
        for (ModelPart modelPart : this.children.values()) {
            modelPart.addAllChildren(biConsumer);
        }
    }

    @FunctionalInterface
    public static interface Visitor {
        public void visit(class_4587.class_4665 var1, String var2, int var3, Cube var4);
    }

    public static class Cube {
        public final Polygon[] polygons;
        public final float minX;
        public final float minY;
        public final float minZ;
        public final float maxX;
        public final float maxY;
        public final float maxZ;

        public Cube(int i, int j, float f, float g, float h, float k, float l, float m, float n, float o, float p, boolean bl, float q, float r, Set<class_2350> set) {
            this.minX = f;
            this.minY = g;
            this.minZ = h;
            this.maxX = f + k;
            this.maxY = g + l;
            this.maxZ = h + m;
            this.polygons = new Polygon[set.size()];
            float s = f + k;
            float t = g + l;
            float u = h + m;
            f -= n;
            g -= o;
            h -= p;
            s += n;
            t += o;
            u += p;
            if (bl) {
                float v = s;
                s = f;
                f = v;
            }
            Vertex vertex = new Vertex(f, g, h, 0.0f, 0.0f);
            Vertex vertex2 = new Vertex(s, g, h, 0.0f, 8.0f);
            Vertex vertex3 = new Vertex(s, t, h, 8.0f, 8.0f);
            Vertex vertex4 = new Vertex(f, t, h, 8.0f, 0.0f);
            Vertex vertex5 = new Vertex(f, g, u, 0.0f, 0.0f);
            Vertex vertex6 = new Vertex(s, g, u, 0.0f, 8.0f);
            Vertex vertex7 = new Vertex(s, t, u, 8.0f, 8.0f);
            Vertex vertex8 = new Vertex(f, t, u, 8.0f, 0.0f);
            float w = i;
            float x = (float)i + m;
            float y = (float)i + m + k;
            float z = (float)i + m + k + k;
            float aa = (float)i + m + k + m;
            float ab = (float)i + m + k + m + k;
            float ac = j;
            float ad = (float)j + m;
            float ae = (float)j + m + l;
            int af = 0;
            if (set.contains(class_2350.field_11033)) {
                this.polygons[af++] = new Polygon(new Vertex[]{vertex6, vertex5, vertex, vertex2}, x, ac, y, ad, q, r, bl, class_2350.field_11033);
            }
            if (set.contains(class_2350.field_11036)) {
                this.polygons[af++] = new Polygon(new Vertex[]{vertex3, vertex4, vertex8, vertex7}, y, ad, z, ac, q, r, bl, class_2350.field_11036);
            }
            if (set.contains(class_2350.field_11039)) {
                this.polygons[af++] = new Polygon(new Vertex[]{vertex, vertex5, vertex8, vertex4}, w, ad, x, ae, q, r, bl, class_2350.field_11039);
            }
            if (set.contains(class_2350.field_11043)) {
                this.polygons[af++] = new Polygon(new Vertex[]{vertex2, vertex, vertex4, vertex3}, x, ad, y, ae, q, r, bl, class_2350.field_11043);
            }
            if (set.contains(class_2350.field_11034)) {
                this.polygons[af++] = new Polygon(new Vertex[]{vertex6, vertex2, vertex3, vertex7}, y, ad, aa, ae, q, r, bl, class_2350.field_11034);
            }
            if (set.contains(class_2350.field_11035)) {
                this.polygons[af] = new Polygon(new Vertex[]{vertex5, vertex6, vertex7, vertex8}, aa, ad, ab, ae, q, r, bl, class_2350.field_11035);
            }
        }

        public void compile(class_4587.class_4665 pose, class_4588 vertexConsumer, int i, int j, int k) {
            Matrix4f matrix4f = pose.method_23761();
            Vector3f vector3f = new Vector3f();
            for (Polygon polygon : this.polygons) {
                Vector3f vector3f2 = pose.method_56821((Vector3fc)polygon.normal, vector3f);
                float f = vector3f2.x();
                float g = vector3f2.y();
                float h = vector3f2.z();
                for (Vertex vertex : polygon.vertices) {
                    float l = vertex.pos.x() / 16.0f;
                    float m = vertex.pos.y() / 16.0f;
                    float n = vertex.pos.z() / 16.0f;
                    Vector3f vector3f3 = matrix4f.transformPosition(l, m, n, vector3f);
                    vertexConsumer.method_23919(vector3f3.x(), vector3f3.y(), vector3f3.z(), k, vertex.u, vertex.v, j, i, f, g, h);
                }
            }
        }
    }

    public record Polygon(Vertex[] vertices, Vector3f normal) {
        public Polygon(Vertex[] vertexs, float f, float g, float h, float i, float j, float k, boolean bl, class_2350 direction) {
            this(vertexs, direction.method_23955());
            float l = 0.0f / j;
            float m = 0.0f / k;
            vertexs[0] = vertexs[0].remap(h / j - l, g / k + m);
            vertexs[1] = vertexs[1].remap(f / j + l, g / k + m);
            vertexs[2] = vertexs[2].remap(f / j + l, i / k - m);
            vertexs[3] = vertexs[3].remap(h / j - l, i / k - m);
            if (bl) {
                int n = vertexs.length;
                for (int o = 0; o < n / 2; ++o) {
                    Vertex vertex = vertexs[o];
                    vertexs[o] = vertexs[n - 1 - o];
                    vertexs[n - 1 - o] = vertex;
                }
            }
            if (bl) {
                this.normal.mul(-1.0f, 1.0f, 1.0f);
            }
        }
    }

    public record Vertex(Vector3f pos, float u, float v) {
        public Vertex(float f, float g, float h, float i, float j) {
            this(new Vector3f(f, g, h), i, j);
        }

        public Vertex remap(float f, float g) {
            return new Vertex(this.pos, f, g);
        }
    }
}

