/*
 * Decompiled with CFR 0.152.
 */
package me.drex.fafpatch.impl.entity.model.entity;

import eu.pb4.factorytools.api.virtualentity.emuvanilla.EntityValueExtraction;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.CubeDeformation;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.CubeListBuilder;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.EntityModel;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.MeshDefinition;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.ModelPart;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.PartDefinition;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.PartPose;
import net.minecraft.class_1309;
import net.minecraft.class_3532;

public class QuadrupedModel<T extends class_1309>
extends EntityModel<T> {
    protected final ModelPart head;
    protected final ModelPart body;
    protected final ModelPart rightHindLeg;
    protected final ModelPart leftHindLeg;
    protected final ModelPart rightFrontLeg;
    protected final ModelPart leftFrontLeg;

    protected QuadrupedModel(ModelPart modelPart) {
        super(modelPart);
        this.head = modelPart.getChild("head");
        this.body = modelPart.getChild("body");
        this.rightHindLeg = modelPart.getChild("right_hind_leg");
        this.leftHindLeg = modelPart.getChild("left_hind_leg");
        this.rightFrontLeg = modelPart.getChild("right_front_leg");
        this.leftFrontLeg = modelPart.getChild("left_front_leg");
    }

    public static MeshDefinition createBodyMesh(int i, boolean bl, boolean bl2, CubeDeformation cubeDeformation) {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -8.0f, 8.0f, 8.0f, 8.0f, cubeDeformation), PartPose.offset(0.0f, 18 - i, -6.0f));
        partDefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(28, 8).addBox(-5.0f, -10.0f, -7.0f, 10.0f, 16.0f, 8.0f, cubeDeformation), PartPose.offsetAndRotation(0.0f, 17 - i, 2.0f, 1.5707964f, 0.0f, 0.0f));
        QuadrupedModel.createLegs(partDefinition, bl, bl2, i, cubeDeformation);
        return meshDefinition;
    }

    static void createLegs(PartDefinition partDefinition, boolean bl, boolean bl2, int i, CubeDeformation cubeDeformation) {
        CubeListBuilder cubeListBuilder = CubeListBuilder.create().mirror(bl2).texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, (float)i, 4.0f, cubeDeformation);
        CubeListBuilder cubeListBuilder2 = CubeListBuilder.create().mirror(bl).texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, (float)i, 4.0f, cubeDeformation);
        partDefinition.addOrReplaceChild("right_hind_leg", cubeListBuilder, PartPose.offset(-3.0f, 24 - i, 7.0f));
        partDefinition.addOrReplaceChild("left_hind_leg", cubeListBuilder2, PartPose.offset(3.0f, 24 - i, 7.0f));
        partDefinition.addOrReplaceChild("right_front_leg", cubeListBuilder, PartPose.offset(-3.0f, 24 - i, -5.0f));
        partDefinition.addOrReplaceChild("left_front_leg", cubeListBuilder2, PartPose.offset(3.0f, 24 - i, -5.0f));
    }

    @Override
    public void setupAnim(T livingEntity) {
        super.setupAnim(livingEntity);
        this.head.yRot = EntityValueExtraction.getRelativeHeadYaw(livingEntity) * ((float)Math.PI / 180);
        this.head.xRot = livingEntity.method_36455() * ((float)Math.PI / 180);
        float pos = ((class_1309)livingEntity).field_42108.method_48572(1.0f);
        float speed = ((class_1309)livingEntity).field_42108.method_48570(1.0f);
        this.rightHindLeg.xRot = class_3532.method_15362((float)(pos * 0.6662f)) * 1.4f * speed;
        this.leftHindLeg.xRot = class_3532.method_15362((float)(pos * 0.6662f + (float)Math.PI)) * 1.4f * speed;
        this.rightFrontLeg.xRot = class_3532.method_15362((float)(pos * 0.6662f + (float)Math.PI)) * 1.4f * speed;
        this.leftFrontLeg.xRot = class_3532.method_15362((float)(pos * 0.6662f)) * 1.4f * speed;
    }
}

