/*
 * Decompiled with CFR 0.152.
 */
package me.drex.fafpatch.impl.entity.model.entity;

import com.faboslav.friendsandfoes.common.entity.RascalEntity;
import com.faboslav.friendsandfoes.common.entity.animation.animator.context.AnimationContextTracker;
import com.faboslav.friendsandfoes.common.entity.animation.animator.loader.json.AnimationHolder;
import java.util.ArrayList;
import me.drex.fafpatch.impl.entity.model.animation.KeyframeModelAnimator;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.CubeDeformation;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.CubeListBuilder;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.EntityModel;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.LayerDefinition;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.MeshDefinition;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.ModelPart;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.PartDefinition;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.PartPose;

public final class RascalEntityModel
extends EntityModel<RascalEntity> {
    private static final String MODEL_PART_HEAD = "head";
    private static final String MODEL_PART_BODY = "body";
    private static final String MODEL_PART_BAG = "bag";
    private static final String MODEL_PART_LEFT_ARM = "leftArm";
    private static final String MODEL_PART_RIGHT_ARM = "rightArm";
    private static final String MODEL_PART_LEFT_LEG = "leftLeg";
    private static final String MODEL_PART_RIGHT_LEG = "rightLeg";
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart bag;
    private final ModelPart leftArm;
    private final ModelPart rightArm;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;

    public RascalEntityModel(ModelPart root) {
        super(root);
        this.root = root;
        this.head = this.root.getChild(MODEL_PART_HEAD);
        this.body = this.root.getChild(MODEL_PART_BODY);
        this.bag = this.root.getChild(MODEL_PART_BAG);
        this.leftArm = this.root.getChild(MODEL_PART_LEFT_ARM);
        this.rightArm = this.root.getChild(MODEL_PART_RIGHT_ARM);
        this.leftLeg = this.root.getChild(MODEL_PART_LEFT_LEG);
        this.rightLeg = this.root.getChild(MODEL_PART_RIGHT_LEG);
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition root = modelData.getRoot();
        root.addOrReplaceChild(MODEL_PART_HEAD, CubeListBuilder.create().texOffs(0, 52).addBox(-4.0f, -2.0f, -5.0f, 8.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(28, 36).addBox(-4.0f, -3.0f, -5.0f, 8.0f, 9.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.offset(0.0f, 9.0f, -5.0f));
        root.addOrReplaceChild(MODEL_PART_BODY, CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, 0.0f, -4.0f, 12.0f, 15.0f, 8.0f, new CubeDeformation(-0.01f)).texOffs(0, 23).addBox(-6.0f, 12.0f, -4.0f, 12.0f, 5.0f, 8.0f, new CubeDeformation(-0.5f)).texOffs(44, 0).addBox(3.0f, 0.0f, -4.0f, 2.0f, 15.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.offset(0.0f, 4.0f, 0.0f));
        root.addOrReplaceChild(MODEL_PART_BAG, CubeListBuilder.create().texOffs(0, 36).addBox(-4.0f, -0.5f, -0.5f, 8.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset(3.0f, 7.5f, 4.5f));
        root.addOrReplaceChild(MODEL_PART_LEFT_ARM, CubeListBuilder.create().texOffs(50, 28).mirror().addBox(-3.0f, -2.0f, -2.0f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset(-6.0f, 11.0f, 0.0f));
        root.addOrReplaceChild(MODEL_PART_RIGHT_ARM, CubeListBuilder.create().texOffs(50, 28).addBox(0.0f, -2.0f, -2.0f, 3.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset(6.0f, 11.0f, 0.0f));
        root.addOrReplaceChild(MODEL_PART_LEFT_LEG, CubeListBuilder.create().texOffs(28, 54).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset(-3.0f, 18.0f, 0.0f));
        root.addOrReplaceChild(MODEL_PART_RIGHT_LEG, CubeListBuilder.create().texOffs(28, 54).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset(3.0f, 18.0f, 0.0f));
        return LayerDefinition.create(modelData, 64, 64);
    }

    @Override
    public void setupAnim(RascalEntity rascal) {
        float limbAngle = rascal.field_42108.method_48572(1.0f);
        float limbDistance = rascal.field_42108.method_48570(1.0f);
        int animationProgress = rascal.field_6012;
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.updateAnimations(rascal, limbAngle, limbDistance, animationProgress);
    }

    public void updateAnimations(RascalEntity rascal, float limbAngle, float limbDistance, float animationProgress) {
        AnimationHolder movementAnimation = rascal.getMovementAnimation();
        ArrayList animations = rascal.getTrackedAnimations();
        AnimationContextTracker animationContextTracker = rascal.getAnimationContextTracker();
        int currentTick = rascal.field_6012;
        float animationSpeedModifier = 1.0f;
        KeyframeModelAnimator.updateMovementKeyframeAnimations(this, movementAnimation, limbAngle, limbDistance, 1.5f, 2.5f, animationSpeedModifier);
        KeyframeModelAnimator.updateKeyframeAnimations(this, animationContextTracker, animations, currentTick, animationProgress, animationSpeedModifier);
    }
}

