/*
 * Decompiled with CFR 0.152.
 */
package me.drex.fafpatch.impl.entity.model.entity;

import com.faboslav.friendsandfoes.common.entity.TuffGolemEntity;
import com.faboslav.friendsandfoes.common.entity.animation.animator.context.AnimationContextTracker;
import com.faboslav.friendsandfoes.common.entity.animation.animator.loader.json.AnimationHolder;
import java.util.ArrayList;
import me.drex.fafpatch.impl.entity.model.animation.KeyframeModelAnimator;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.CubeDeformation;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.CubeListBuilder;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.EntityModel;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.LayerDefinition;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.MeshDefinition;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.ModelPart;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.PartDefinition;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.PartPose;

public class TuffGolemEntityModel
extends EntityModel<TuffGolemEntity> {
    private static final String MODEL_PART_BODY = "body";
    private static final String MODEL_PART_NOSE = "nose";
    private static final String MODEL_PART_FRONT_CLOTH = "frontCloth";
    private static final String MODEL_PART_BACK_CLOTH = "backCloth";
    private static final String MODEL_PART_CLOTH_STAND = "clothStand";
    private static final String MODEL_PART_LEFT_ARM = "leftArm";
    private static final String MODEL_PART_RIGHT_ARM = "rightArm";
    private static final String MODEL_PART_LEFT_LEG = "leftLeg";
    private static final String MODEL_PART_RIGHT_LEG = "rightLeg";
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart nose;
    private final ModelPart frontCloth;
    private final ModelPart backCloth;
    private final ModelPart clothStand;
    private final ModelPart leftArm;
    private final ModelPart rightArm;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;

    public TuffGolemEntityModel(ModelPart root) {
        super(root);
        this.root = root;
        this.body = this.root.getChild(MODEL_PART_BODY);
        this.nose = this.body.getChild(MODEL_PART_NOSE);
        this.frontCloth = this.body.getChild(MODEL_PART_FRONT_CLOTH);
        this.backCloth = this.body.getChild(MODEL_PART_BACK_CLOTH);
        this.clothStand = this.body.getChild(MODEL_PART_CLOTH_STAND);
        this.leftArm = this.body.getChild(MODEL_PART_LEFT_ARM);
        this.rightArm = this.body.getChild(MODEL_PART_RIGHT_ARM);
        this.leftLeg = this.root.getChild(MODEL_PART_LEFT_LEG);
        this.rightLeg = this.root.getChild(MODEL_PART_RIGHT_LEG);
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition root = modelData.getRoot();
        root.addOrReplaceChild(MODEL_PART_BODY, CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -12.0f, -4.0f, 8.0f, 13.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset(0.0f, 19.0f, 0.0f));
        PartDefinition body = root.getChild(MODEL_PART_BODY);
        body.addOrReplaceChild(MODEL_PART_NOSE, CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -1.0f, -2.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset(0.0f, -7.0f, -4.0f));
        body.addOrReplaceChild(MODEL_PART_FRONT_CLOTH, CubeListBuilder.create().texOffs(36, 4).addBox(-4.0f, 0.0f, 0.0f, 8.0f, 6.0f, 4.0f, new CubeDeformation(0.02f)), PartPose.offset(0.0f, -4.0f, -4.0f));
        body.addOrReplaceChild(MODEL_PART_BACK_CLOTH, CubeListBuilder.create().texOffs(40, 18).addBox(-4.0f, 0.0f, 0.0f, 8.0f, 6.0f, 4.0f, new CubeDeformation(0.02f)), PartPose.offset(0.0f, -4.0f, 0.0f));
        body.addOrReplaceChild(MODEL_PART_CLOTH_STAND, CubeListBuilder.create().texOffs(0, 35).addBox(-4.0f, 0.0f, -4.0f, 8.0f, 5.0f, 7.0f, new CubeDeformation(0.01f)), PartPose.offset(0.0f, -4.0f, 0.0f));
        body.addOrReplaceChild(MODEL_PART_LEFT_ARM, CubeListBuilder.create().texOffs(0, 21).addBox(-1.0f, -2.0f, -2.0f, 2.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset(-5.0f, -4.0f, 0.0f));
        body.addOrReplaceChild(MODEL_PART_RIGHT_ARM, CubeListBuilder.create().texOffs(0, 21).mirror(true).addBox(0.0f, -2.0f, -2.0f, 2.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset(4.0f, -4.0f, 0.0f));
        root.addOrReplaceChild(MODEL_PART_LEFT_LEG, CubeListBuilder.create().texOffs(12, 21).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(-5.0E-4f)), PartPose.offset(-2.0f, 19.0f, 0.0f));
        root.addOrReplaceChild(MODEL_PART_RIGHT_LEG, CubeListBuilder.create().texOffs(12, 21).mirror(true).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(-5.0E-4f)), PartPose.offset(2.0f, 19.0f, 0.0f));
        return LayerDefinition.create(modelData, 64, 64);
    }

    @Override
    public void setupAnim(TuffGolemEntity tuffGolem) {
        super.setupAnim(tuffGolem);
        float limbAngle = tuffGolem.field_42108.method_48572(1.0f);
        float limbDistance = tuffGolem.field_42108.method_48570(1.0f);
        int animationProgress = tuffGolem.field_6012;
        AnimationHolder movementAnimation = tuffGolem.getMovementAnimation();
        ArrayList animations = tuffGolem.getTrackedAnimations();
        AnimationContextTracker animationContextTracker = tuffGolem.getAnimationContextTracker();
        int currentTick = tuffGolem.field_6012;
        float animationSpeedModifier = 1.0f;
        this.root().getAllParts().forEach(ModelPart::resetPose);
        KeyframeModelAnimator.updateMovementKeyframeAnimations(this, movementAnimation, limbAngle, limbDistance, 4.0f * tuffGolem.getMovementSpeedModifier(), 4.0f * tuffGolem.getMovementSpeedModifier(), animationSpeedModifier);
        KeyframeModelAnimator.updateKeyframeAnimations(this, animationContextTracker, animations, currentTick, animationProgress, animationSpeedModifier);
    }
}

