/*
 * Decompiled with CFR 0.152.
 */
package me.drex.fafpatch.impl.entity.model.entity;

import com.faboslav.friendsandfoes.common.entity.WildfireEntity;
import com.faboslav.friendsandfoes.common.entity.animation.WildfireAnimations;
import com.faboslav.friendsandfoes.common.entity.animation.animator.context.AnimationContextTracker;
import com.faboslav.friendsandfoes.common.entity.animation.animator.loader.json.AnimationHolder;
import eu.pb4.factorytools.api.virtualentity.emuvanilla.EntityValueExtraction;
import java.util.ArrayList;
import java.util.List;
import me.drex.fafpatch.impl.entity.model.animation.KeyframeModelAnimator;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.CubeDeformation;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.CubeListBuilder;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.EntityModel;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.LayerDefinition;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.MeshDefinition;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.ModelPart;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.PartDefinition;
import me.drex.fafpatch.impl.entity.model.emuvanilla.model.PartPose;
import net.minecraft.class_1309;

public final class WildfireEntityModel
extends EntityModel<WildfireEntity> {
    private static final String MODEL_PART_BODY = "body";
    private static final String MODEL_PART_HEAD = "head";
    private static final String MODEL_PART_HELMET = "helmet";
    private static final String MODEL_PART_SHIELDS = "shields";
    private static final String MODEL_PART_FRONT_SHIELD = "frontShield";
    private static final String MODEL_PART_RIGHT_SHIELD = "rightShield";
    private static final String MODEL_PART_BACK_SHIELD = "backShield";
    private static final String MODEL_PART_LEFT_SHIELD = "leftShield";
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart helmet;
    private final ModelPart shields;
    private final ModelPart frontShield;
    private final ModelPart rightShield;
    private final ModelPart backShield;
    private final ModelPart leftShield;
    private final List<ModelPart> shieldsModelParts;

    public WildfireEntityModel(ModelPart root) {
        super(root);
        this.root = root;
        this.body = this.root.getChild(MODEL_PART_BODY);
        this.head = this.body.getChild(MODEL_PART_HEAD);
        this.helmet = this.head.getChild(MODEL_PART_HELMET);
        this.shields = this.root.getChild(MODEL_PART_SHIELDS);
        this.frontShield = this.shields.getChild(MODEL_PART_FRONT_SHIELD);
        this.rightShield = this.shields.getChild(MODEL_PART_RIGHT_SHIELD);
        this.backShield = this.shields.getChild(MODEL_PART_BACK_SHIELD);
        this.leftShield = this.shields.getChild(MODEL_PART_LEFT_SHIELD);
        this.shieldsModelParts = this.shields.getAllParts();
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition root = modelData.getRoot();
        PartDefinition body = root.addOrReplaceChild(MODEL_PART_BODY, CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -21.0f, -2.0f, 4.0f, 21.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset(0.0f, 24.0f, 0.0f));
        PartDefinition head = body.addOrReplaceChild(MODEL_PART_HEAD, CubeListBuilder.create().texOffs(0, 26).addBox(-4.0f, -5.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset(0.0f, -24.0f, 0.0f));
        head.addOrReplaceChild(MODEL_PART_HELMET, CubeListBuilder.create().texOffs(0, 43).addBox(-4.0f, -7.5f, -4.0f, 8.0f, 9.0f, 8.0f, new CubeDeformation(0.2f)), PartPose.offset(0.0f, 1.5f, 0.0f));
        PartDefinition shields = root.addOrReplaceChild(MODEL_PART_SHIELDS, CubeListBuilder.create(), PartPose.offset(0.0f, 24.0f, 0.0f));
        shields.addOrReplaceChild(MODEL_PART_FRONT_SHIELD, CubeListBuilder.create().texOffs(17, 0).addBox(-5.0f, 3.5f, -9.5f, 10.0f, 17.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation(0.0f, -22.0f, 0.0f, -0.2618f, 0.0f, 0.0f));
        shields.addOrReplaceChild(MODEL_PART_RIGHT_SHIELD, CubeListBuilder.create().texOffs(17, 0).addBox(-5.0f, 3.5f, -9.5f, 10.0f, 17.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation(0.0f, -22.0f, 0.0f, -0.2618f, 1.5708f, 0.0f));
        shields.addOrReplaceChild(MODEL_PART_BACK_SHIELD, CubeListBuilder.create().texOffs(17, 0).addBox(-5.0f, 3.5f, -9.5f, 10.0f, 17.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation(0.0f, -22.0f, 0.0f, -0.2618f, 3.1416f, 0.0f));
        shields.addOrReplaceChild(MODEL_PART_LEFT_SHIELD, CubeListBuilder.create().texOffs(17, 0).addBox(-5.0f, 3.5f, -9.5f, 10.0f, 17.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation(0.0f, -22.0f, 0.0f, -0.2618f, -1.5708f, 0.0f));
        return LayerDefinition.create(modelData, 64, 64);
    }

    @Override
    public void setupAnim(WildfireEntity wildfire) {
        float limbAngle = wildfire.field_42108.method_48572(1.0f);
        float limbDistance = wildfire.field_42108.method_48570(1.0f);
        int animationProgress = wildfire.field_6012;
        float headYaw = EntityValueExtraction.getRelativeHeadYaw((class_1309)wildfire) * ((float)Math.PI / 180);
        float headPitch = wildfire.method_36455();
        int activeShieldsCount = wildfire.getActiveShieldsCount();
        for (int i = 0; i < 4; ++i) {
            this.shieldsModelParts.get((int)i).skipDraw = i > activeShieldsCount;
        }
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.updateKeyframeAnimations(wildfire, limbAngle, limbDistance, animationProgress);
        this.head.yRot = headYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
    }

    public void updateKeyframeAnimations(WildfireEntity wildfire, float limbAngle, float limbDistance, float animationProgress) {
        AnimationHolder movementAnimation = wildfire.getMovementAnimation();
        ArrayList animations = wildfire.getTrackedAnimations();
        AnimationContextTracker animationContextTracker = wildfire.getAnimationContextTracker();
        int currentTick = wildfire.field_6012;
        float animationSpeedModifier = wildfire.getAnimationSpeedModifier();
        KeyframeModelAnimator.updateMovementKeyframeAnimations(this, movementAnimation, limbAngle, limbDistance, 1.0f, 1.0f, animationSpeedModifier);
        KeyframeModelAnimator.updateStaticKeyframeAnimation(this, animationContextTracker, WildfireAnimations.SHIELD_ROTATION, currentTick, animationProgress, animationSpeedModifier);
        KeyframeModelAnimator.updateKeyframeAnimations(this, animationContextTracker, animations, currentTick, animationProgress, animationSpeedModifier);
    }
}

