/*
 * Decompiled with CFR 0.152.
 */
package net.a5ho9999.explosive.data.explosions;

import java.util.Arrays;
import java.util.HashMap;

public enum ExplosionType {
    Default("default"),
    Bed("bed"),
    RespawnAnchor("respawn_anchor"),
    Enchantment("enchantment"),
    TNT("tnt"),
    Wither("wither"),
    EndDragonDeath("end_dragon_death"),
    EndCrystal("end_crystal"),
    ShulkerBullet("shulker_bullet"),
    WindChargedEffect("wind_charged_effect"),
    Creeper("creeper"),
    BreezeWindCharge("breeze_wind_charge"),
    Fireball("fireball"),
    WindCharge("wind_charge"),
    WitherSkull("wither_skull"),
    MinecartTNT("tnt_minecart"),
    Mooshroom("mooshroom"),
    WindChargeStatusEffect("wind_charged_status_effect");

    private static final HashMap<String, ExplosionType> ByType;
    private final String type;

    private ExplosionType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public static ExplosionType getType(String type) {
        return ByType.get(type);
    }

    static {
        ByType = new HashMap();
        Arrays.stream(ExplosionType.values()).forEach(explosionType -> ByType.put(explosionType.getType(), (ExplosionType)((Object)explosionType)));
    }
}

