/*
 * Decompiled with CFR 0.152.
 */
package com.redgrapefruit.itemnbt3;

import com.redgrapefruit.itemnbt3.CustomData;
import com.redgrapefruit.itemnbt3.event.DeserializationEvents;
import com.redgrapefruit.itemnbt3.event.LinkingEvents;
import com.redgrapefruit.itemnbt3.event.SerializationEvents;
import com.redgrapefruit.itemnbt3.linking.DataLink;
import com.redgrapefruit.itemnbt3.specification.DataCompound;
import com.redgrapefruit.itemnbt3.specification.Specification;
import com.redgrapefruit.itemnbt3.util.NbtCompoundMixinAccess;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;

public final class DataClient {
    private DataClient() {
        throw new RuntimeException("DataClient is not meant to be instantiated");
    }

    private static <T extends CustomData> void prepare(@NotNull T instance, @NotNull class_1799 stack) {
        Objects.requireNonNull(instance);
        Objects.requireNonNull(stack);
        class_2487 nbt = stack.method_7911(instance.getNbtCategory());
        if (nbt.method_33133()) {
            ((NbtCompoundMixinAccess)nbt).clearNbt();
            ((SerializationEvents.CustomEvent)SerializationEvents.CUSTOM_PRE_SERIALIZE.invoker()).event(stack, nbt);
            instance.writeNbt(nbt);
            ((SerializationEvents.CustomEvent)SerializationEvents.CUSTOM_POST_SERIALIZE.invoker()).event(stack, nbt);
        }
        ((DeserializationEvents.CustomEvent)DeserializationEvents.CUSTOM_PRE_DESERIALIZE.invoker()).event(stack, nbt);
        instance.readNbt(nbt);
        ((DeserializationEvents.CustomEvent)DeserializationEvents.CUSTOM_POST_DESERIALIZE.invoker()).event(stack, nbt);
    }

    public static <T extends CustomData> void use(@NotNull Supplier<T> factory, @NotNull class_1799 stack, @NotNull Consumer<T> action) {
        Objects.requireNonNull(factory);
        Objects.requireNonNull(stack);
        Objects.requireNonNull(action);
        CustomData instance = (CustomData)factory.get();
        DataClient.prepare(instance, stack);
        action.accept(instance);
        class_2487 nbt = stack.method_7911(instance.getNbtCategory());
        ((NbtCompoundMixinAccess)nbt).clearNbt();
        ((SerializationEvents.CustomEvent)SerializationEvents.CUSTOM_PRE_SERIALIZE.invoker()).event(stack, nbt);
        instance.writeNbt(nbt);
        ((SerializationEvents.CustomEvent)SerializationEvents.CUSTOM_POST_SERIALIZE.invoker()).event(stack, nbt);
    }

    public static void use(@NotNull class_1799 stack, @NotNull Specification specification, @NotNull Consumer<DataCompound> action) {
        Objects.requireNonNull(stack);
        Objects.requireNonNull(specification);
        Objects.requireNonNull(action);
        class_2487 subNbt = stack.method_7911(specification.getId());
        DataCompound compound = new DataCompound();
        if (subNbt.method_33133()) {
            ((NbtCompoundMixinAccess)subNbt).clearNbt();
            ((SerializationEvents.DefaultEvent)SerializationEvents.DEFAULT_PRE_SERIALIZE.invoker()).event(stack, specification, subNbt, compound);
            specification.writeNbt(subNbt, compound);
            ((SerializationEvents.DefaultEvent)SerializationEvents.DEFAULT_POST_SERIALIZE.invoker()).event(stack, specification, subNbt, compound);
        }
        ((DeserializationEvents.DefaultEvent)DeserializationEvents.DEFAULT_PRE_DESERIALIZE.invoker()).event(stack, specification, subNbt, compound);
        specification.readNbt(subNbt, compound);
        ((DeserializationEvents.DefaultEvent)DeserializationEvents.DEFAULT_POST_DESERIALIZE.invoker()).event(stack, specification, subNbt, compound);
        action.accept(compound);
        ((NbtCompoundMixinAccess)subNbt).clearNbt();
        ((SerializationEvents.DefaultEvent)SerializationEvents.DEFAULT_PRE_SERIALIZE.invoker()).event(stack, specification, subNbt, compound);
        specification.writeNbt(subNbt, compound);
        ((SerializationEvents.DefaultEvent)SerializationEvents.DEFAULT_POST_SERIALIZE.invoker()).event(stack, specification, subNbt, compound);
    }

    public static <T> void use(@NotNull class_1799 stack, @NotNull Specification specification, @NotNull DataLink link, @NotNull T instance, @NotNull Consumer<T> action) {
        Objects.requireNonNull(stack);
        Objects.requireNonNull(specification);
        Objects.requireNonNull(link);
        Objects.requireNonNull(action);
        class_2487 subNbt = stack.method_7911(specification.getId());
        DataCompound compound = new DataCompound();
        if (subNbt.method_33133()) {
            ((NbtCompoundMixinAccess)subNbt).clearNbt();
            ((SerializationEvents.LinkedEvent)SerializationEvents.LINKED_PRE_SERIALIZE.invoker()).event(stack, specification, subNbt, compound, instance);
            specification.writeNbt(subNbt, compound);
            ((SerializationEvents.LinkedEvent)SerializationEvents.LINKED_POST_SERIALIZE.invoker()).event(stack, specification, subNbt, compound, instance);
        }
        ((DeserializationEvents.LinkedEvent)DeserializationEvents.LINKED_PRE_DESERIALIZE.invoker()).event(stack, specification, subNbt, compound, instance);
        specification.readNbt(subNbt, compound);
        ((DeserializationEvents.LinkedEvent)DeserializationEvents.LINKED_POST_DESERIALIZE.invoker()).event(stack, specification, subNbt, compound, instance);
        ((LinkingEvents.LinkingEvent)LinkingEvents.PRE_FORWARD_LINK.invoker()).event(stack, specification, subNbt, compound, instance);
        link.forwardLink(compound, instance);
        ((LinkingEvents.LinkingEvent)LinkingEvents.POST_FORWARD_LINK.invoker()).event(stack, specification, subNbt, compound, instance);
        action.accept(instance);
        ((LinkingEvents.LinkingEvent)LinkingEvents.PRE_BACKWARD_LINK.invoker()).event(stack, specification, subNbt, compound, instance);
        link.backwardLink(compound, instance);
        ((LinkingEvents.LinkingEvent)LinkingEvents.POST_BACKWARD_LINK.invoker()).event(stack, specification, subNbt, compound, instance);
        ((NbtCompoundMixinAccess)subNbt).clearNbt();
        ((SerializationEvents.LinkedEvent)SerializationEvents.LINKED_PRE_SERIALIZE.invoker()).event(stack, specification, subNbt, compound, instance);
        specification.writeNbt(subNbt, compound);
        ((SerializationEvents.LinkedEvent)SerializationEvents.LINKED_POST_SERIALIZE.invoker()).event(stack, specification, subNbt, compound, instance);
    }
}

