/*
 * Decompiled with CFR 0.152.
 */
package com.redgrapefruit.itemnbt3.linking;

import com.redgrapefruit.itemnbt3.linking.AllowInheritance;
import com.redgrapefruit.itemnbt3.linking.Auto;
import com.redgrapefruit.itemnbt3.linking.Composite;
import com.redgrapefruit.itemnbt3.linking.DataLinkLookup;
import com.redgrapefruit.itemnbt3.linking.Field;
import com.redgrapefruit.itemnbt3.serializer.SerializerRegistry;
import com.redgrapefruit.itemnbt3.specification.DataCompound;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DataLink {
    @NotNull
    private final Map<String, java.lang.reflect.Field> fields = new HashMap<String, java.lang.reflect.Field>();
    @NotNull
    private final Map<String, java.lang.reflect.Field> composites = new HashMap<String, java.lang.reflect.Field>();
    @NotNull
    private static final Logger LOGGER = LogManager.getLogger();

    public void addField(@NotNull String address, @NotNull java.lang.reflect.Field field) {
        Objects.requireNonNull(address);
        Objects.requireNonNull(field);
        this.fields.put(address, field);
    }

    public void addComposite(@NotNull String address, @NotNull java.lang.reflect.Field field) {
        Objects.requireNonNull(address);
        Objects.requireNonNull(field);
        this.composites.put(address, field);
    }

    public void forwardLink(@NotNull DataCompound data, @NotNull Object instance) {
        this.fields.forEach((key, field) -> {
            try {
                field.set(instance, data.get((String)key));
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Could not forward-link field " + field.getName() + ". Illegal access, make it public");
            }
        });
        this.composites.forEach((key, field) -> {
            Class<?> otherClazz = field.getType();
            if (DataLinkLookup.lacks(otherClazz)) {
                LOGGER.error("Trying to lookup non-existing DataLink for field " + field.getName() + " of type " + otherClazz.getSimpleName());
            }
            DataLink otherLink = DataLinkLookup.get(otherClazz);
            DataCompound otherCompound = data.getOrCreateCompound((String)key);
            Object otherInstance = null;
            try {
                otherInstance = field.get(instance);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Could not forward-link composite field " + field.getName() + ". Illegal access, make it public!");
            }
            otherInstance = DataLink.fallbackField(otherInstance, otherClazz);
            Objects.requireNonNull(otherInstance);
            otherLink.forwardLink(otherCompound, otherInstance);
            try {
                field.set(instance, otherInstance);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Could not forward-link composite field " + field.getName() + ". Illegal access, make it public!");
            }
        });
    }

    public void backwardLink(@NotNull DataCompound data, @NotNull Object instance) {
        this.fields.forEach((key, field) -> {
            Object value = null;
            try {
                value = field.get(instance);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Could not backward-link field " + field.getName() + ". Illegal access, make it public");
            }
            Objects.requireNonNull(value);
            data.put((String)key, value);
        });
        this.composites.forEach((key, field) -> {
            Class<?> otherClazz = field.getType();
            if (DataLinkLookup.lacks(otherClazz)) {
                LOGGER.error("Trying to lookup non-existing DataLink for field " + field.getName() + " of type " + otherClazz.getSimpleName());
            }
            DataLink otherLink = DataLinkLookup.get(otherClazz);
            DataCompound otherCompound = data.getOrCreateCompound((String)key);
            Object otherInstance = null;
            try {
                otherInstance = field.get(instance);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Could not forward-link composite field " + field.getName() + ". Illegal access, make it public!");
            }
            otherInstance = DataLink.fallbackField(otherInstance, otherClazz);
            Objects.requireNonNull(otherInstance);
            otherLink.backwardLink(otherCompound, otherInstance);
            try {
                field.set(instance, otherInstance);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Could not forward-link composite field " + field.getName() + ". Illegal access, make it public!");
            }
        });
    }

    @NotNull
    public static DataLink create(@NotNull Class<?> clazz) {
        Objects.requireNonNull(clazz);
        if (clazz.isAnnotationPresent(Auto.class)) {
            return DataLink.createAutomatic(clazz);
        }
        return DataLink.createManual(clazz);
    }

    @NotNull
    private static DataLink createAutomatic(@NotNull Class<?> clazz) {
        java.lang.reflect.Field[] fields;
        DataLink link = new DataLink();
        for (java.lang.reflect.Field field : fields = clazz.isAnnotationPresent(AllowInheritance.class) ? clazz.getFields() : clazz.getDeclaredFields()) {
            if (!Modifier.isPublic(field.getModifiers())) continue;
            if (SerializerRegistry.contains(field.getType())) {
                link.addField(field.getName(), field);
                continue;
            }
            link.addComposite(field.getName(), field);
        }
        DataLinkLookup.register(clazz, link);
        return link;
    }

    @NotNull
    private static DataLink createManual(@NotNull Class<?> clazz) {
        java.lang.reflect.Field[] fields;
        DataLink link = new DataLink();
        for (java.lang.reflect.Field field : fields = clazz.isAnnotationPresent(AllowInheritance.class) ? clazz.getFields() : clazz.getDeclaredFields()) {
            String name;
            Annotation annotation;
            if (!Modifier.isPublic(field.getModifiers())) continue;
            if (field.isAnnotationPresent(Field.class)) {
                annotation = field.getAnnotation(Field.class);
                name = annotation.name();
                if (annotation.name().equals("^NULL")) {
                    name = field.getName();
                }
                link.addField(name, field);
            }
            if (!field.isAnnotationPresent(Composite.class)) continue;
            annotation = field.getAnnotation(Composite.class);
            name = annotation.name();
            if (annotation.name().equals("^NULL")) {
                name = field.getName();
            }
            link.addComposite(name, field);
        }
        DataLinkLookup.register(clazz, link);
        return link;
    }

    @NotNull
    private static Supplier<Object> createFactoryFromFirstConstructor(@NotNull Class<?> clazz) {
        return () -> {
            try {
                return clazz.getDeclaredConstructors()[0].newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException("Reflective generation of a data link failed while creating factory from constructor");
            }
        };
    }

    private static Object fallbackField(@Nullable Object value, @NotNull Class<?> clazz) {
        Supplier<Object> fallback = DataLink.createFactoryFromFirstConstructor(clazz);
        if (value == null) {
            value = fallback.get();
        }
        return value;
    }
}

