/*
 * Decompiled with CFR 0.152.
 */
package com.redgrapefruit.itemnbt3.specification;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class DataCompound {
    @NotNull
    private final Map<String, Object> rootTree = new HashMap<String, Object>();
    @NotNull
    private final Map<String, DataCompound> nestedTree = new HashMap<String, DataCompound>();

    private void putRaw(@NotNull String key, @NotNull Object value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        this.rootTree.put(key, value);
    }

    public <T> void put(@NotNull String key, @NotNull T value) {
        this.putRaw(key, value);
    }

    public void putCompound(@NotNull String key, @NotNull DataCompound compound) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(compound);
        this.nestedTree.put(key, compound);
    }

    @NotNull
    private Object getRaw(@NotNull String key) {
        Objects.requireNonNull(key);
        return this.rootTree.get(key);
    }

    public <T> T get(@NotNull String key) {
        return (T)this.getRaw(key);
    }

    @NotNull
    public DataCompound getCompound(@NotNull String key) {
        Objects.requireNonNull(key);
        return this.nestedTree.get(key);
    }

    @NotNull
    public DataCompound getOrCreateCompound(@NotNull String key) {
        Objects.requireNonNull(key);
        if (this.nestedTree.containsKey(key)) {
            return this.nestedTree.get(key);
        }
        DataCompound subCompound = new DataCompound();
        this.putCompound(key, subCompound);
        return subCompound;
    }

    public byte getByte(@NotNull String key) {
        return (Byte)this.getRaw(key);
    }

    public short getShort(@NotNull String key) {
        return (Short)this.getRaw(key);
    }

    public int getInt(@NotNull String key) {
        return (Integer)this.getRaw(key);
    }

    public long getLong(@NotNull String key) {
        return (Long)this.getRaw(key);
    }

    public UUID getUUID(@NotNull String key) {
        return (UUID)this.getRaw(key);
    }

    public float getFloat(@NotNull String key) {
        return ((Float)this.getRaw(key)).floatValue();
    }

    public double getDouble(@NotNull String key) {
        return (Double)this.getRaw(key);
    }

    public String getString(@NotNull String key) {
        return (String)this.getRaw(key);
    }

    public byte[] getByteArray(@NotNull String key) {
        return (byte[])this.getRaw(key);
    }

    public int[] getIntArray(@NotNull String key) {
        return (int[])this.getRaw(key);
    }

    public long[] getLongArray(@NotNull String key) {
        return (long[])this.getRaw(key);
    }

    public boolean getBool(@NotNull String key) {
        return (Boolean)this.getRaw(key);
    }
}

