/*
 * Decompiled with CFR 0.152.
 */
package com.redgrapefruit.itemnbt3.specification;

import com.redgrapefruit.itemnbt3.linking.AllowInheritance;
import com.redgrapefruit.itemnbt3.linking.Auto;
import com.redgrapefruit.itemnbt3.linking.Composite;
import com.redgrapefruit.itemnbt3.serializer.BuiltinTypeSerializer;
import com.redgrapefruit.itemnbt3.serializer.SerializerRegistry;
import com.redgrapefruit.itemnbt3.serializer.TypeSerializer;
import com.redgrapefruit.itemnbt3.specification.DataCompound;
import com.redgrapefruit.itemnbt3.util.Utilities;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2487;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class Specification {
    @NotNull
    private final Map<String, TypeSerializer<?>> rootTree = new HashMap();
    @NotNull
    private final Map<String, Specification> nestedTree = new HashMap<String, Specification>();
    @NotNull
    private final String id;

    public Specification(@NotNull String id) {
        Objects.requireNonNull(id);
        this.id = id;
    }

    public void add(@NotNull String key, @NotNull TypeSerializer<?> serializer) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(serializer);
        this.rootTree.putIfAbsent(key, serializer);
    }

    public void add(@NotNull String key, @NotNull Specification specification) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(specification);
        this.nestedTree.putIfAbsent(key, specification);
    }

    @ApiStatus.Internal
    public void writeNbt(@NotNull class_2487 nbt, @NotNull DataCompound compound) {
        Objects.requireNonNull(nbt);
        Objects.requireNonNull(compound);
        this.rootTree.forEach((key, serializer) -> serializer.writeNbt((String)key, nbt, compound.get((String)key)));
        this.nestedTree.forEach((key, spec) -> {
            class_2487 subNbt = Utilities.getOrCreateSubNbt(nbt, key);
            spec.writeNbt(subNbt, compound.getOrCreateCompound((String)key));
        });
    }

    @ApiStatus.Internal
    public void readNbt(@NotNull class_2487 nbt, @NotNull DataCompound compound) {
        Objects.requireNonNull(nbt);
        Objects.requireNonNull(compound);
        this.rootTree.forEach((key, serializer) -> {
            Object value = serializer.readNbt((String)key, nbt);
            compound.put((String)key, value);
        });
        this.nestedTree.forEach((key, spec) -> {
            class_2487 subNbt = Utilities.getOrCreateSubNbt(nbt, key);
            spec.readNbt(subNbt, compound.getOrCreateCompound((String)key));
        });
    }

    @ApiStatus.Internal
    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public static Builder builder(@NotNull String id) {
        return new Builder(id);
    }

    @NotNull
    public static Specification create(@NotNull Class<?> clazz) {
        Objects.requireNonNull(clazz);
        if (clazz.isAnnotationPresent(Auto.class)) {
            return Specification.createAutomatic(clazz);
        }
        return Specification.createManual(clazz);
    }

    @NotNull
    private static Specification createAutomatic(@NotNull Class<?> clazz) {
        Field[] fields;
        Specification spec = new Specification(clazz.getSimpleName());
        for (Field field : fields = clazz.isAnnotationPresent(AllowInheritance.class) ? clazz.getFields() : clazz.getDeclaredFields()) {
            if (!Modifier.isPublic(field.getModifiers())) continue;
            if (SerializerRegistry.contains(field.getType())) {
                TypeSerializer<?> serializer = SerializerRegistry.get(field.getType());
                spec.add(field.getName(), serializer);
                continue;
            }
            spec.add(field.getName(), Specification.create(field.getType()));
        }
        return spec;
    }

    @NotNull
    private static Specification createManual(@NotNull Class<?> clazz) {
        Field[] fields;
        Specification spec = new Specification(clazz.getSimpleName());
        for (Field field : fields = clazz.isAnnotationPresent(AllowInheritance.class) ? clazz.getFields() : clazz.getDeclaredFields()) {
            String name;
            Annotation annotation;
            if (!Modifier.isPublic(field.getModifiers())) continue;
            if (field.isAnnotationPresent(com.redgrapefruit.itemnbt3.linking.Field.class)) {
                annotation = field.getAnnotation(com.redgrapefruit.itemnbt3.linking.Field.class);
                name = annotation.name();
                if (annotation.name().equals("^NULL")) {
                    name = field.getName();
                }
                spec.add(name, SerializerRegistry.get(field.getType()));
            }
            if (!field.isAnnotationPresent(Composite.class)) continue;
            annotation = field.getAnnotation(Composite.class);
            name = annotation.name();
            if (annotation.name().equals("^NULL")) {
                name = field.getName();
            }
            spec.add(name, Specification.create(field.getType()));
        }
        return spec;
    }

    public static class Builder {
        @NotNull
        private final Map<String, TypeSerializer<?>> rootTree = new HashMap();
        @NotNull
        private final Map<String, Specification> nestedTree = new HashMap<String, Specification>();
        @NotNull
        private final String id;

        public Builder(@NotNull String id) {
            Objects.requireNonNull(id);
            this.id = id;
        }

        @NotNull
        public Builder add(@NotNull String key, @NotNull TypeSerializer<?> serializer) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(serializer);
            this.rootTree.putIfAbsent(key, serializer);
            return this;
        }

        @NotNull
        public Builder add(@NotNull String key, @NotNull Specification specification) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(specification);
            this.nestedTree.putIfAbsent(key, specification);
            return this;
        }

        @NotNull
        public Builder addByte(@NotNull String key) {
            return this.add(key, BuiltinTypeSerializer.BYTE);
        }

        @NotNull
        public Builder addShort(@NotNull String key) {
            return this.add(key, BuiltinTypeSerializer.SHORT);
        }

        @NotNull
        public Builder addInt(@NotNull String key) {
            return this.add(key, BuiltinTypeSerializer.INT);
        }

        @NotNull
        public Builder addLong(@NotNull String key) {
            return this.add(key, BuiltinTypeSerializer.LONG);
        }

        @NotNull
        public Builder addUUID(@NotNull String key) {
            return this.add(key, BuiltinTypeSerializer.UUID);
        }

        @NotNull
        public Builder addFloat(@NotNull String key) {
            return this.add(key, BuiltinTypeSerializer.FLOAT);
        }

        @NotNull
        public Builder addDouble(@NotNull String key) {
            return this.add(key, BuiltinTypeSerializer.DOUBLE);
        }

        @NotNull
        public Builder addString(@NotNull String key) {
            return this.add(key, BuiltinTypeSerializer.STRING);
        }

        @NotNull
        public Builder addByteArray(@NotNull String key) {
            return this.add(key, BuiltinTypeSerializer.BYTE_ARRAY);
        }

        @NotNull
        public Builder addIntArray(@NotNull String key) {
            return this.add(key, BuiltinTypeSerializer.INT_ARRAY);
        }

        @NotNull
        public Builder addLongArray(@NotNull String key) {
            return this.add(key, BuiltinTypeSerializer.LONG_ARRAY);
        }

        @NotNull
        public Builder addBool(@NotNull String key) {
            return this.add(key, BuiltinTypeSerializer.BOOL);
        }

        @NotNull
        public Specification build() {
            Specification spec = new Specification(this.id);
            this.rootTree.forEach(spec::add);
            this.nestedTree.forEach(spec::add);
            return spec;
        }
    }
}

