/*
 * Decompiled with CFR 0.152.
 */
package com.redgrapefruit.itemnbt3.serializer;

import com.redgrapefruit.itemnbt3.serializer.TypeSerializer;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraft.class_2487;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;

public final class BuiltinTypeSerializer<T>
implements TypeSerializer<T> {
    @NotNull
    private final TriConsumer<class_2487, String, T> writer;
    @NotNull
    private final BiFunction<class_2487, String, T> reader;
    @NotNull
    private final T fallback;
    @NotNull
    public static final BuiltinTypeSerializer<Byte> BYTE = new BuiltinTypeSerializer<Byte>(class_2487::method_10567, class_2487::method_10571, (byte)0);
    @NotNull
    public static final BuiltinTypeSerializer<Short> SHORT = new BuiltinTypeSerializer<Short>(class_2487::method_10575, class_2487::method_10568, (short)0);
    @NotNull
    public static final BuiltinTypeSerializer<Integer> INT = new BuiltinTypeSerializer<Integer>(class_2487::method_10569, class_2487::method_10550, 0);
    @NotNull
    public static final BuiltinTypeSerializer<Long> LONG = new BuiltinTypeSerializer<Long>(class_2487::method_10544, class_2487::method_10537, 0L);
    @NotNull
    public static final BuiltinTypeSerializer<UUID> UUID = new BuiltinTypeSerializer<UUID>(class_2487::method_25927, class_2487::method_25926, java.util.UUID.randomUUID());
    @NotNull
    public static final BuiltinTypeSerializer<Float> FLOAT = new BuiltinTypeSerializer<Float>(class_2487::method_10548, class_2487::method_10583, Float.valueOf(0.0f));
    @NotNull
    public static final BuiltinTypeSerializer<Double> DOUBLE = new BuiltinTypeSerializer<Double>(class_2487::method_10549, class_2487::method_10574, 0.0);
    @NotNull
    public static final BuiltinTypeSerializer<String> STRING = new BuiltinTypeSerializer<String>(class_2487::method_10582, class_2487::method_10558, "");
    @NotNull
    public static final BuiltinTypeSerializer<byte[]> BYTE_ARRAY = new BuiltinTypeSerializer<byte[]>(class_2487::method_10570, class_2487::method_10547, new byte[0]);
    @NotNull
    public static final BuiltinTypeSerializer<int[]> INT_ARRAY = new BuiltinTypeSerializer<int[]>(class_2487::method_10539, class_2487::method_10561, new int[0]);
    @NotNull
    public static final BuiltinTypeSerializer<long[]> LONG_ARRAY = new BuiltinTypeSerializer<long[]>(class_2487::method_10564, class_2487::method_10565, new long[0]);
    @NotNull
    public static final BuiltinTypeSerializer<Boolean> BOOL = new BuiltinTypeSerializer<Boolean>(class_2487::method_10556, class_2487::method_10577, false);

    public BuiltinTypeSerializer(@NotNull TriConsumer<class_2487, String, T> writer, @NotNull BiFunction<class_2487, String, T> reader, @NotNull T fallback) {
        Objects.requireNonNull(writer);
        Objects.requireNonNull(reader);
        Objects.requireNonNull(fallback);
        this.writer = writer;
        this.reader = reader;
        this.fallback = fallback;
    }

    @Override
    public T readNbt(@NotNull String key, @NotNull class_2487 nbt) {
        return this.reader.apply(nbt, key);
    }

    @Override
    public void writeNbt(@NotNull String key, @NotNull class_2487 nbt, @NotNull T value) {
        this.writer.accept((Object)nbt, (Object)key, value == null ? this.fallback : value);
    }
}

