/*
 * Decompiled with CFR 0.152.
 */
package com.redgrapefruit.itemnbt3.serializer;

import com.redgrapefruit.itemnbt3.serializer.BuiltinTypeSerializer;
import com.redgrapefruit.itemnbt3.serializer.TypeSerializer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class SerializerRegistry {
    @NotNull
    private static final Map<Class<?>, TypeSerializer<?>> registry = new HashMap();
    @NotNull
    private static final Logger LOGGER;

    private SerializerRegistry() {
        throw new RuntimeException("SerializerRegistry is not meant to be instantiated.");
    }

    public static <T> void register(@NotNull Class<T> clazz, @NotNull TypeSerializer<T> serializer) {
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(serializer);
        if (registry.containsKey(clazz)) {
            LOGGER.warn("Tried to register duplicate serializer");
            return;
        }
        registry.put(clazz, serializer);
    }

    @ApiStatus.Internal
    public static boolean contains(@NotNull Class<?> clazz) {
        return registry.containsKey(clazz);
    }

    @ApiStatus.Internal
    public static TypeSerializer<?> get(@NotNull Class<?> clazz) {
        return registry.get(clazz);
    }

    static {
        registry.put(Byte.TYPE, BuiltinTypeSerializer.BYTE);
        registry.put(Short.TYPE, BuiltinTypeSerializer.SHORT);
        registry.put(Integer.TYPE, BuiltinTypeSerializer.INT);
        registry.put(Long.TYPE, BuiltinTypeSerializer.LONG);
        registry.put(UUID.class, BuiltinTypeSerializer.UUID);
        registry.put(Float.TYPE, BuiltinTypeSerializer.FLOAT);
        registry.put(Double.TYPE, BuiltinTypeSerializer.DOUBLE);
        registry.put(String.class, BuiltinTypeSerializer.STRING);
        registry.put(byte[].class, BuiltinTypeSerializer.BYTE_ARRAY);
        registry.put(int[].class, BuiltinTypeSerializer.INT_ARRAY);
        registry.put(long[].class, BuiltinTypeSerializer.LONG_ARRAY);
        registry.put(Boolean.TYPE, BuiltinTypeSerializer.BOOL);
        LOGGER = LogManager.getLogger();
    }
}

