/*
 * Decompiled with CFR 0.152.
 */
package com.sethyandrak.obscurio.block;

import com.sethyandrak.obscurio.block.entity.TanukiStatueBlockEntity;
import com.sethyandrak.obscurio.entity.TanukiEntity;
import com.sethyandrak.obscurio.init.BlockEntityInit;
import com.sethyandrak.obscurio.init.EntityTypeInit;
import com.sethyandrak.obscurio.init.ItemInit;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public class TanukiStatueBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);

    public TanukiStatueBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public PushReaction m_5537_(BlockState p_56265_) {
        return PushReaction.BLOCK;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack stack = player.m_21120_(hand);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TanukiStatueBlockEntity) {
            TanukiStatueBlockEntity statueBlockEntity = (TanukiStatueBlockEntity)blockEntity;
            if (stack.m_150930_((Item)ItemInit.MAGIC_LEAF.get())) {
                statueBlockEntity.setEarTwitchAnim(10);
                if (!level.m_5776_()) {
                    NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)statueBlockEntity, (BlockPos)pos);
                    CriteriaTriggers.f_10562_.m_45482_((ServerPlayer)player, pos, stack);
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
            if (stack.m_150930_(Items.f_42402_)) {
                int ticklishCounter = statueBlockEntity.getTicklishCounter();
                if (ticklishCounter > 60) {
                    if (!level.m_5776_()) {
                        this.turnIntoTanuki(state, level, pos, player, statueBlockEntity);
                    }
                    return InteractionResult.m_19078_((boolean)level.m_5776_());
                }
                statueBlockEntity.setTicklishCounter(ticklishCounter + 25);
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        } else {
            throw new IllegalStateException("Our Container provider is missing!");
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    private void turnIntoTanuki(BlockState state, Level level, BlockPos pos, Player player, TanukiStatueBlockEntity statueBlockEntity) {
        if (!level.m_5776_()) {
            level.m_46597_(pos, Blocks.f_50016_.m_49966_());
            TanukiEntity tanuki = (TanukiEntity)((EntityType)EntityTypeInit.TANUKI.get()).m_20592_((ServerLevel)level, null, player, pos, MobSpawnType.STRUCTURE, true, true);
            tanuki.setTicklishCounter(statueBlockEntity.getTicklishCounter());
            statueBlockEntity.transferInventoryInto(tanuki.getInventory());
        }
    }

    public void m_5707_(Level pLevel, BlockPos pBlockPos, BlockState pBlockState, Player pPlayer) {
        BlockEntity blockEntity = pLevel.m_7702_(pBlockPos);
        if (blockEntity instanceof TanukiStatueBlockEntity) {
            ItemStack itemstack = new ItemStack((ItemLike)ItemInit.ODD_STATUE.get());
            blockEntity.m_187476_(itemstack);
            ItemEntity itementity = new ItemEntity(pLevel, (double)pBlockPos.m_123341_() + 0.5, (double)pBlockPos.m_123342_() + 0.5, (double)pBlockPos.m_123343_() + 0.5, itemstack);
            itementity.m_32060_();
            pLevel.m_7967_((Entity)itementity);
        }
        super.m_5707_(pLevel, pBlockPos, pBlockState, pPlayer);
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_());
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return TanukiStatueBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)BlockEntityInit.TANUKI_STATUE_BLOCK_ENTITY.get()), TanukiStatueBlockEntity::tick);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)BlockEntityInit.TANUKI_STATUE_BLOCK_ENTITY.get()).m_155264_(pPos, pState);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }
}

