/*
 * Decompiled with CFR 0.152.
 */
package com.sethyandrak.obscurio.block.entity;

import com.sethyandrak.obscurio.init.BlockEntityInit;
import com.sethyandrak.obscurio.init.ItemInit;
import com.sethyandrak.obscurio.recipe.ObscuritaShrineRecipe;
import com.sethyandrak.obscurio.screen.ObscuritaShrineMenu;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class ObscuritaShrineBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(5){

        protected void onContentsChanged(int slot) {
            ObscuritaShrineBlockEntity.this.m_6596_();
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return ObscuritaShrineBlockEntity.this.progress;
                }
                case 1: {
                    return ObscuritaShrineBlockEntity.this.maxProgress;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    ObscuritaShrineBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    ObscuritaShrineBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 72;

    public ObscuritaShrineBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityInit.OBSCURITA_SHRINE_BLOCK_ENTITY.get(), pWorldPosition, pBlockState);
    }

    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new ObscuritaShrineMenu(pContainerId, pInventory, this, this.data);
    }

    public Component m_5446_() {
        return new TextComponent("Shrine");
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("obscurita_shrine.progress", this.progress);
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.progress = nbt.m_128451_("obscurita_shrine.progress");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, ObscuritaShrineBlockEntity pBlockEntity) {
        if (ObscuritaShrineBlockEntity.hasRecipe(pBlockEntity)) {
            ++pBlockEntity.progress;
            ObscuritaShrineBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            if (pBlockEntity.progress > pBlockEntity.maxProgress) {
                ObscuritaShrineBlockEntity.craftItem(pBlockEntity);
            }
        } else {
            pBlockEntity.resetProgress();
            ObscuritaShrineBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    private static boolean hasRecipe(ObscuritaShrineBlockEntity entity) {
        Level level = entity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, entity.itemHandler.getStackInSlot(i));
        }
        Optional match = level.m_7465_().m_44015_((RecipeType)ObscuritaShrineRecipe.Type.INSTANCE, (Container)inventory, level);
        return match.isPresent() && ObscuritaShrineBlockEntity.canInsertAmountIntoOutputSlot(inventory) && ObscuritaShrineBlockEntity.canInsertItemIntoOutputSlot(inventory, ((ObscuritaShrineRecipe)match.get()).m_8043_());
    }

    private static void craftItem(ObscuritaShrineBlockEntity entity) {
        Level level = entity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, entity.itemHandler.getStackInSlot(i));
        }
        Optional match = level.m_7465_().m_44015_((RecipeType)ObscuritaShrineRecipe.Type.INSTANCE, (Container)inventory, level);
        if (match.isPresent() && !level.m_5776_()) {
            CompoundTag nbtData;
            ItemStack result;
            ItemStack catalyst;
            boolean defaultOutputItem = true;
            if (((ObscuritaShrineRecipe)match.get()).m_8043_().m_41720_().equals(ItemInit.ANYTHING_CAKE.get())) {
                catalyst = entity.itemHandler.getStackInSlot(3);
                result = new ItemStack((ItemLike)((ObscuritaShrineRecipe)match.get()).m_8043_().m_41720_(), entity.itemHandler.getStackInSlot(4).m_41613_() + 1);
                if (!catalyst.m_150930_(Items.f_41852_)) {
                    nbtData = new CompoundTag();
                    if (catalyst.m_150930_((Item)ItemInit.ANYTHING_CAKE.get())) {
                        if (catalyst.m_41782_()) {
                            nbtData = catalyst.m_41783_();
                            result.m_41751_(nbtData);
                        }
                    } else {
                        nbtData.m_128359_("obscurio.disguised_as", "" + catalyst.m_41720_());
                        nbtData.m_128359_("obscurio.disguise_mod", catalyst.m_41720_().getCreatorModId(catalyst));
                        if (catalyst.m_41793_()) {
                            nbtData.m_128379_("obscurio.disguise_is_foil", true);
                        } else {
                            nbtData.m_128379_("obscurio.disguise_is_foil", false);
                        }
                        result.m_41751_(nbtData);
                    }
                }
                entity.itemHandler.setStackInSlot(4, result);
                defaultOutputItem = false;
            }
            if (((ObscuritaShrineRecipe)match.get()).m_8043_().m_41720_().equals(ItemInit.MOFF.get())) {
                catalyst = entity.itemHandler.getStackInSlot(3);
                ItemStack originalMoff = entity.itemHandler.getStackInSlot(1);
                ItemStack result2 = new ItemStack((ItemLike)((ObscuritaShrineRecipe)match.get()).m_8043_().m_41720_());
                CompoundTag nbtData2 = originalMoff.m_41784_();
                nbtData2.m_128379_("obscurio.moff.unlocked", true);
                if (catalyst.m_150930_((Item)ItemInit.UNUSUAL_FEATHER.get())) {
                    nbtData2.m_128379_("obscurio.moff.empowered", true);
                }
                result2.m_41751_(nbtData2);
                entity.itemHandler.setStackInSlot(4, result2);
                defaultOutputItem = false;
            }
            if (((ObscuritaShrineRecipe)match.get()).m_8043_().m_41720_().equals(ItemInit.RECOILER.get())) {
                catalyst = entity.itemHandler.getStackInSlot(3);
                result = new ItemStack((ItemLike)((ObscuritaShrineRecipe)match.get()).m_8043_().m_41720_());
                nbtData = catalyst.m_41784_();
                result.m_41751_(nbtData);
                entity.itemHandler.setStackInSlot(4, result);
                defaultOutputItem = false;
            }
            if (defaultOutputItem) {
                entity.itemHandler.setStackInSlot(4, new ItemStack((ItemLike)((ObscuritaShrineRecipe)match.get()).m_8043_().m_41720_(), entity.itemHandler.getStackInSlot(4).m_41613_() + 1));
            }
            for (int i = 0; i < 3; ++i) {
                if (entity.itemHandler.getStackInSlot(i).m_41720_().m_41470_()) {
                    Item remnant = entity.itemHandler.getStackInSlot(i).m_41720_().m_41469_();
                    entity.itemHandler.extractItem(i, 1, false);
                    if (entity.itemHandler.getStackInSlot(i).m_41720_().equals(Items.f_41852_)) {
                        entity.itemHandler.setStackInSlot(i, new ItemStack((ItemLike)remnant));
                        continue;
                    }
                    entity.m_58904_().m_7967_((Entity)new ItemEntity(entity.m_58904_(), (double)entity.m_58899_().m_123341_() + 0.5, (double)(entity.m_58899_().m_123342_() + 1), (double)entity.m_58899_().m_123343_() + 0.5, new ItemStack((ItemLike)remnant)));
                    continue;
                }
                entity.itemHandler.extractItem(i, 1, false);
            }
            entity.resetProgress();
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private static boolean canInsertItemIntoOutputSlot(SimpleContainer inventory, ItemStack output) {
        return inventory.m_8020_(4).m_41720_() == output.m_41720_() || inventory.m_8020_(4).m_41619_();
    }

    private static boolean canInsertAmountIntoOutputSlot(SimpleContainer inventory) {
        return inventory.m_8020_(4).m_41741_() > inventory.m_8020_(4).m_41613_();
    }
}

