/*
 * Decompiled with CFR 0.152.
 */
package com.sethyandrak.obscurio.block.entity;

import com.sethyandrak.obscurio.init.BlockEntityInit;
import com.sethyandrak.obscurio.screen.TanukiStashMenu;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class TanukiStatueBlockEntity
extends BlockEntity
implements IAnimatable,
MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(27){

        protected void onContentsChanged(int slot) {
            TanukiStatueBlockEntity.this.m_6596_();
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return TanukiStatueBlockEntity.this.ticklishCounter;
                }
                case 1: {
                    return TanukiStatueBlockEntity.this.earTwitchAnim;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    TanukiStatueBlockEntity.this.ticklishCounter = value;
                    break;
                }
                case 1: {
                    TanukiStatueBlockEntity.this.earTwitchAnim = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int ticklishCounter = 0;
    private int earTwitchAnim = 0;

    public TanukiStatueBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityInit.TANUKI_STATUE_BLOCK_ENTITY.get(), pWorldPosition, pBlockState);
    }

    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new TanukiStashMenu(pContainerId, pInventory, this, this.data);
    }

    public Component m_5446_() {
        return new TextComponent("Tanuki secret stash");
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("tanuki_statue.ear", this.earTwitchAnim);
        tag.m_128405_("tanuki_statue.tickle", this.ticklishCounter);
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.earTwitchAnim = nbt.m_128451_("tanuki_statue.ear");
        this.ticklishCounter = nbt.m_128451_("tanuki_statue.tickle");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public int getTicklishCounter() {
        return this.ticklishCounter;
    }

    public void setTicklishCounter(int value) {
        this.ticklishCounter = value;
    }

    public int getEarTwitchAnim() {
        return this.earTwitchAnim;
    }

    public void setEarTwitchAnim(int value) {
        this.earTwitchAnim = value;
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, TanukiStatueBlockEntity pBlockEntity) {
        if (pBlockEntity.ticklishCounter > 0) {
            --pBlockEntity.ticklishCounter;
        }
        if (pBlockEntity.earTwitchAnim > 0) {
            --pBlockEntity.earTwitchAnim;
        }
    }

    public void transferInventoryInto(SimpleContainer newInventory) {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            newInventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
    }

    public void transferInventoryFrom(SimpleContainer oldInventory) {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, oldInventory.m_8020_(i));
        }
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.getTicklishCounter() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("fidget1", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.getEarTwitchAnim() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("ear_twitch", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("none", Boolean.valueOf(false)));
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

