/*
 * Decompiled with CFR 0.152.
 */
package com.sethyandrak.obscurio.effect;

import com.sethyandrak.obscurio.init.EffectInit;
import com.sethyandrak.obscurio.init.SoundInit;
import com.sethyandrak.obscurio.networking.CustomMessages;
import com.sethyandrak.obscurio.networking.packet.DashS2CPacket;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class FluidGenderEffect
extends MobEffect {
    public FluidGenderEffect(MobEffectCategory mobEffectCategory, int color) {
        super(mobEffectCategory, color);
    }

    public void m_19461_(Entity mediumEntity, Entity sourceEntity, LivingEntity victim, int potency, double hitPrecision) {
        victim.m_183503_().m_6263_(null, victim.m_20185_(), victim.m_20186_(), victim.m_20189_(), SoundEvents.f_12644_, SoundSource.AMBIENT, 0.5f, 1.0f);
        int length = 3600;
        if (mediumEntity instanceof ServerPlayer) {
            String tag;
            ItemStack source = ((ServerPlayer)mediumEntity).m_21120_(InteractionHand.MAIN_HAND);
            if (!source.m_150930_(Items.f_42589_)) {
                source = ((ServerPlayer)mediumEntity).m_21120_(InteractionHand.OFF_HAND);
            }
            if (source.m_150930_(Items.f_42589_) && (tag = source.m_41783_().m_128461_("Potion")).equals("obscurio:long_gender_potion")) {
                length = 9600;
            }
        } else if (mediumEntity instanceof ThrownPotion) {
            String tag;
            ItemStack source = ((ThrownPotion)mediumEntity).m_7846_();
            if (source.m_150930_(Items.f_42736_) && (tag = source.m_41783_().m_128461_("Potion")).equals("obscurio:long_gender_potion")) {
                length = 9600;
            }
        } else if (mediumEntity instanceof AreaEffectCloud) {
            List source = ((AreaEffectCloud)mediumEntity).m_146791_().m_43488_();
            for (int i = 0; i < source.size(); ++i) {
                if (!((MobEffectInstance)source.get(i)).m_19544_().equals(EffectInit.FLUIDGENDER.get())) continue;
                length = ((MobEffectInstance)source.get(i)).m_19557_() / 2;
            }
        }
        victim.m_7292_(new MobEffectInstance((MobEffect)EffectInit.FLUIDGENDER.get(), Mth.m_14107_((double)((double)length * hitPrecision)), 0, false, true));
        if (victim instanceof ServerPlayer) {
            ((ServerPlayer)victim).m_6352_((Component)new TextComponent("You feel your body changing").m_130940_(ChatFormatting.BLUE), Util.f_137441_);
        }
        super.m_19461_(mediumEntity, sourceEntity, victim, potency, hitPrecision);
    }

    public void m_6742_(LivingEntity pLivingEntity, int pAmplifier) {
        boolean dashSuccessfull = false;
        if (!pLivingEntity.m_183503_().m_5776_()) {
            pLivingEntity.m_183634_();
            if (pLivingEntity instanceof ServerPlayer && pAmplifier == 0 && !pLivingEntity.m_20096_() && pLivingEntity.m_6144_()) {
                dashSuccessfull = true;
                pLivingEntity.m_7292_(new MobEffectInstance((MobEffect)EffectInit.FLUIDGENDER.get(), 80, 1, false, true));
            }
        }
        if (dashSuccessfull) {
            Level world = pLivingEntity.m_183503_();
            world.m_6263_(null, pLivingEntity.m_20185_(), pLivingEntity.m_20186_(), pLivingEntity.m_20189_(), (SoundEvent)SoundInit.AIR_DASH.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            CustomMessages.sendToPlayer(new DashS2CPacket(), (ServerPlayer)pLivingEntity);
        }
        super.m_6742_(pLivingEntity, pAmplifier);
    }

    public boolean m_6584_(int pDuration, int pAmplifier) {
        return true;
    }

    public boolean m_8093_() {
        return true;
    }
}

