/*
 * Decompiled with CFR 0.152.
 */
package com.sethyandrak.obscurio.entity;

import com.sethyandrak.obscurio.entity.ObscuritaGolemEntity;
import com.sethyandrak.obscurio.init.EffectInit;
import com.sethyandrak.obscurio.init.EntityTypeInit;
import com.sethyandrak.obscurio.init.ItemInit;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class JackalopeEntity
extends PathfinderMob
implements IAnimatable {
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public JackalopeEntity(EntityType<? extends PathfinderMob> p_21683_, Level p_21684_) {
        super(p_21683_, p_21684_);
    }

    public static AttributeSupplier setAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 3.0).m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22282_, 3.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22283_, 2.0).m_22268_(Attributes.f_22279_, 0.3).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new ClimbOnTopOfPowderSnowGoal((Mob)this, this.f_19853_));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, ObscuritaGolemEntity.class, 32.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 48.0f));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(7, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(8, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("walk", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public boolean m_7327_(Entity pEntity) {
        if (pEntity instanceof Player) {
            ((LivingEntity)pEntity).m_7292_(new MobEffectInstance((MobEffect)EffectInit.JACKALOPES_CURSE.get(), 36000, 0, false, false));
            if (this.m_183503_() instanceof ServerLevel) {
                Rabbit replacement = (Rabbit)EntityType.f_20517_.m_20592_((ServerLevel)this.m_183503_(), null, null, this.m_20097_(), MobSpawnType.CONVERSION, true, true);
                replacement.m_29733_(0);
                replacement.m_7292_(new MobEffectInstance((MobEffect)EffectInit.JACKALOPES_CURSE.get(), 36000, 0, false, false));
                if (this.m_8077_()) {
                    replacement.m_6593_(this.m_7755_());
                }
            }
            this.m_146870_();
        }
        return super.m_7327_(pEntity);
    }

    public void m_6667_(DamageSource source) {
        Entity killer;
        if (!this.m_183503_().m_5776_() && this.m_21187_().nextDouble() < 0.7 && (killer = source.m_7640_()) != null && killer instanceof LivingEntity) {
            int x = Mth.m_14107_((double)this.m_20185_());
            int y = Mth.m_14107_((double)this.m_20186_());
            int z = Mth.m_14107_((double)this.m_20189_());
            ServerLevel level = (ServerLevel)this.m_183503_();
            for (int tries = 50; tries > 0; --tries) {
                int x0 = x + Mth.m_14072_((Random)this.m_21187_(), (int)-38, (int)38);
                int y0 = y + Mth.m_14072_((Random)this.m_21187_(), (int)0, (int)5);
                int z0 = z + Mth.m_14072_((Random)this.m_21187_(), (int)-38, (int)38);
                BlockPos blockpos = new BlockPos(x0, y0, z0);
                boolean weAreOnAir = true;
                if (level.m_141937_() < y0 - 10 && level.m_141937_() + level.m_143344_() - 1 > y0) {
                    boolean bl = weAreOnAir = !level.m_8055_(blockpos.m_7495_()).m_60767_().m_76334_();
                    while (weAreOnAir && blockpos.m_123342_() > y0 - 10) {
                        weAreOnAir = !level.m_8055_((blockpos = blockpos.m_7495_()).m_7495_()).m_60767_().m_76334_();
                    }
                }
                JackalopeEntity jackalope = (JackalopeEntity)((EntityType)EntityTypeInit.JACKALOPE.get()).m_20615_((Level)level);
                jackalope.m_6034_(blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_());
                if (!level.m_45786_((Entity)jackalope) || level.m_46855_(jackalope.m_142469_()) || level.m_45914_((double)x0, (double)y0, (double)z0, 16.0) || weAreOnAir) continue;
                jackalope.m_6710_((LivingEntity)killer);
                level.m_7967_((Entity)jackalope);
                tries = 0;
            }
        }
        super.m_6667_(source);
    }

    protected void m_7472_(DamageSource pDamage, int pLooting, boolean pKillByPlayer) {
        int hideAmount = Mth.m_14143_((float)(this.m_21187_().nextFloat() * (float)(2 + pLooting)));
        if (hideAmount > 0) {
            ItemEntity hideDrop = new ItemEntity(this.m_183503_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)ItemInit.WEIRD_HIDE.get(), hideAmount));
            this.m_183503_().m_7967_((Entity)hideDrop);
        }
        ItemEntity meatDrop = this.m_6060_() ? new ItemEntity(this.m_183503_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)Items.f_42698_, Mth.m_14167_((float)(this.m_21187_().nextFloat() * 1.0f + (float)pLooting)))) : new ItemEntity(this.m_183503_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)Items.f_42697_, Mth.m_14167_((float)(this.m_21187_().nextFloat() * 1.0f + (float)pLooting))));
        this.m_183503_().m_7967_((Entity)meatDrop);
        if (pKillByPlayer && (double)this.m_21187_().nextFloat() < 0.1 + 0.03 * (double)pLooting) {
            ItemEntity rareDrop = new ItemEntity(this.m_183503_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)ItemInit.SMALL_ANTLER.get(), 1));
            this.m_183503_().m_7967_((Entity)rareDrop);
        }
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12354_, 1.0f, 1.0f);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12297_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12353_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12352_;
    }

    protected float m_6121_() {
        return 0.2f;
    }
}

