/*
 * Decompiled with CFR 0.152.
 */
package com.sethyandrak.obscurio.entity;

import com.sethyandrak.obscurio.init.ItemInit;
import com.sethyandrak.obscurio.init.SoundInit;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class MothmanEntity
extends PathfinderMob
implements IAnimatable,
FlyingAnimal {
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private static final EntityDataAccessor<BlockPos> HOME = SynchedEntityData.m_135353_(MothmanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Integer> ENERGY = SynchedEntityData.m_135353_(MothmanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public MothmanEntity(EntityType<? extends PathfinderMob> mob, Level level) {
        super(mob, level);
        this.f_21344_ = this.m_6037_(level);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.setEnergy(5);
    }

    public static AttributeSupplier setAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 15.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22283_, 2.0).m_22268_(Attributes.f_22288_, 4.0).m_22268_(Attributes.f_22280_, 3.0).m_22268_(Attributes.f_22279_, 0.3).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new ClimbOnTopOfPowderSnowGoal((Mob)this, this.f_19853_));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 48.0f));
        this.f_21345_.m_25352_(5, (Goal)new MothmanGoHomeDay());
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(7, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(8, (Goal)new NearestAttackableTargetGoal((Mob)this, Phantom.class, true));
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_6142_()) {
            if (this.getHome().equals((Object)new BlockPos(0, 0, 0))) {
                this.setHome(this.m_20097_());
            }
            if (this.m_183503_().m_46461_() && this.m_5448_() == null) {
                if (!this.m_21023_(MobEffects.f_19609_)) {
                    this.setEnergy(this.getEnergy() - 1);
                    this.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 24000, 0, false, false));
                }
            } else if (this.m_21023_(MobEffects.f_19609_)) {
                this.m_21195_(MobEffects.f_19609_);
            }
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_21434_, DifficultyInstance p_21435_, MobSpawnType p_21436_, SpawnGroupData p_21437_, CompoundTag p_21438_) {
        this.setHome(this.m_20097_());
        return super.m_6518_(p_21434_, p_21435_, p_21436_, p_21437_, p_21438_);
    }

    public boolean m_6785_(double distance) {
        return this.getEnergy() == 0;
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        long x = tag.m_128454_("homeX");
        long y = tag.m_128454_("homeY");
        long z = tag.m_128454_("homeZ");
        this.setHome(new BlockPos((double)x, (double)y, (double)z));
        this.setEnergy(tag.m_128451_("energy"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128356_("homeX", (long)this.getHome().m_123341_());
        tag.m_128356_("homeY", (long)this.getHome().m_123342_());
        tag.m_128356_("homeZ", (long)this.getHome().m_123343_());
        tag.m_128405_("energy", this.getEnergy());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HOME, (Object)new BlockPos(0, 0, 0));
        this.f_19804_.m_135372_(ENERGY, (Object)5);
    }

    public void setHome(BlockPos pos) {
        this.f_19804_.m_135381_(HOME, (Object)pos);
    }

    public BlockPos getHome() {
        return (BlockPos)this.f_19804_.m_135370_(HOME);
    }

    public void setEnergy(int energy) {
        int value = Math.min(energy, 5);
        value = Math.max(value, 0);
        this.f_19804_.m_135381_(ENERGY, (Object)value);
    }

    public int getEnergy() {
        return (Integer)this.m_20088_().m_135370_(ENERGY);
    }

    public boolean m_142535_(float p_148750_, float p_148751_, DamageSource p_148752_) {
        return false;
    }

    protected void m_7840_(double p_27419_, boolean p_27420_, BlockState p_27421_, BlockPos p_27422_) {
    }

    public boolean m_142592_() {
        return !this.f_19861_;
    }

    protected PathNavigation m_6037_(Level p_27815_) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, p_27815_){

            public boolean m_6342_(BlockPos p_27947_) {
                return true;
            }
        };
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(true);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    protected void m_7472_(DamageSource pDamage, int pLooting, boolean pKillByPlayer) {
        if (pKillByPlayer && (double)this.m_21187_().nextFloat() < 0.1 + 0.03 * (double)pLooting) {
            ItemEntity rareDrop = new ItemEntity(this.m_183503_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)ItemInit.UNUSUAL_FEATHER.get(), 1));
            this.m_183503_().m_7967_((Entity)rareDrop);
        }
    }

    public void m_5837_(ServerLevel level, LivingEntity victim) {
        super.m_5837_(level, victim);
        if (victim instanceof Phantom) {
            this.setEnergy(5);
            if ((double)this.m_21187_().nextFloat() < 0.4) {
                ItemEntity rareDrop = new ItemEntity(this.m_183503_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)ItemInit.UNUSUAL_FEATHER.get(), 1));
                this.m_183503_().m_7967_((Entity)rareDrop);
            }
        }
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack item = player.m_21120_(hand);
        if (item.m_41614_()) {
            item.m_41764_(item.m_41613_() - 1);
            this.setEnergy(5);
            this.m_183503_().m_5594_(player, this.m_20097_(), SoundEvents.f_11947_, this.m_5720_(), 1.0f, 1.0f);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.m_142592_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("fly", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("walk", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundInit.MOTHMAN_CRY.get();
    }

    public int m_8100_() {
        return 1200;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)SoundInit.MOTHMAN_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundInit.MOTHMAN_HURT.get();
    }

    class MothmanGoHomeDay
    extends Goal {
        boolean reloadNeeded = false;

        public MothmanGoHomeDay() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return MothmanEntity.this.m_183503_().m_46461_();
        }

        public boolean m_8045_() {
            return super.m_8045_() && !this.reloadNeeded;
        }

        public void m_8056_() {
            this.reloadNeeded = false;
            BlockPos home = MothmanEntity.this.getHome();
            MothmanEntity.this.f_21344_.m_26519_((double)home.m_123341_(), (double)home.m_123342_(), (double)home.m_123343_(), 1.0);
        }

        public void m_8041_() {
            MothmanEntity.this.f_21344_.m_26573_();
            this.reloadNeeded = false;
        }

        public void m_8037_() {
            BlockPos home = MothmanEntity.this.getHome();
            if (!MothmanEntity.this.f_21344_.m_26572_()) {
                MothmanEntity.this.f_21344_.m_26529_(10.0f);
                MothmanEntity.this.f_21344_.m_26519_((double)home.m_123341_(), (double)home.m_123342_(), (double)home.m_123343_(), 1.0);
                if (MothmanEntity.this.f_21344_.m_26570_() == null || !MothmanEntity.this.f_21344_.m_26570_().m_77403_()) {
                    MothmanEntity.this.setEnergy(MothmanEntity.this.getEnergy() - 2);
                    MothmanEntity.this.setHome(MothmanEntity.this.m_20097_().m_7494_());
                    this.reloadNeeded = true;
                }
            }
        }
    }
}

