/*
 * Decompiled with CFR 0.152.
 */
package com.sethyandrak.obscurio.entity;

import com.sethyandrak.obscurio.entity.TanukiEntity;
import com.sethyandrak.obscurio.init.EntityTypeInit;
import com.sethyandrak.obscurio.init.ItemInit;
import com.sethyandrak.obscurio.init.SoundInit;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class ObscuritaGolemEntity
extends AbstractGolem
implements IAnimatable {
    public static final Predicate<LivingEntity> CRYPTID_SELECTOR = p_30437_ -> {
        EntityType entitytype = p_30437_.m_6095_();
        return entitytype == EntityTypeInit.JACKALOPE.get() || entitytype == EntityTypeInit.TANUKI.get() || entitytype == EntityTypeInit.MOTHMAN.get();
    };
    private static final EntityDataAccessor<Integer> ATTACK_TICK = SynchedEntityData.m_135353_(ObscuritaGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> RESEARCH_PROGRESS = SynchedEntityData.m_135353_(ObscuritaGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final int MAX_RESEARCH = 100;
    public static final int MIN_RESEARCH = 0;
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public ObscuritaGolemEntity(EntityType<? extends AbstractGolem> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier setAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22283_, 2.0).m_22268_(Attributes.f_22278_, (double)0.2f).m_22268_(Attributes.f_22279_, (double)0.15f).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, true));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(7, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, CRYPTID_SELECTOR));
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setAttackTick(tag.m_128451_("attackTick"));
        this.setResearchProgress(tag.m_128451_("researchProgress"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("attackTick", this.getAttackTick());
        tag.m_128405_("researchProgress", this.getResearchProgress());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACK_TICK, (Object)0);
        this.f_19804_.m_135372_(RESEARCH_PROGRESS, (Object)0);
    }

    public void setAttackTick(int tick) {
        this.f_19804_.m_135381_(ATTACK_TICK, (Object)tick);
    }

    public int getAttackTick() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TICK);
    }

    public void setResearchProgress(int progress) {
        if (progress > 100) {
            this.f_19804_.m_135381_(RESEARCH_PROGRESS, (Object)100);
        } else if (progress < 0) {
            this.f_19804_.m_135381_(RESEARCH_PROGRESS, (Object)0);
        } else {
            this.f_19804_.m_135381_(RESEARCH_PROGRESS, (Object)progress);
        }
    }

    public int getResearchProgress() {
        return (Integer)this.f_19804_.m_135370_(RESEARCH_PROGRESS);
    }

    public void m_8107_() {
        int count;
        if (!this.f_19853_.f_46443_ && this.m_6084_() && this.m_6142_() && (count = this.getAttackTick()) > 0) {
            this.setAttackTick(count - 1);
        }
        super.m_8107_();
    }

    public void m_8032_() {
        this.setResearchProgress(this.getResearchProgress() + 1);
        super.m_8032_();
    }

    public boolean m_7327_(Entity target) {
        this.playAttackAnimation();
        this.setResearchProgress(this.getResearchProgress() + 25);
        if (target instanceof TanukiEntity) {
            ((TanukiEntity)target).setCanDie(true);
        }
        return super.m_7327_(target);
    }

    protected InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        if (pPlayer.m_6144_()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = pPlayer.m_21120_(pHand);
        if (stack.m_41619_()) {
            if (!this.f_19853_.f_46443_) {
                if (this.getResearchProgress() == 100) {
                    ItemStack hint = new ItemStack((ItemLike)ItemInit.HINT.get(), 1);
                    ItemEntity itementity = new ItemEntity(this.f_19853_, this.m_20185_() + this.m_20154_().f_82479_, this.m_20186_() + 1.0, this.m_20189_() + this.m_20154_().f_82481_, hint);
                    itementity.m_32010_(40);
                    itementity.m_32052_(this.m_142081_());
                    this.m_5496_(SoundEvents.f_11669_, 1.0f, 1.0f);
                    this.f_19853_.m_7967_((Entity)itementity);
                    this.setResearchProgress(0);
                } else {
                    this.m_5496_((SoundEvent)SoundInit.DISSAPOINTMENT.get(), 1.0f, 1.0f);
                }
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pKilledByPlayer) {
        ItemEntity lootDrop;
        int lootAmount = Mth.m_14143_((float)(this.m_21187_().nextFloat() * (float)(2 + pLooting))) + 1;
        if (lootAmount > 0) {
            lootDrop = new ItemEntity(this.m_183503_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)ItemInit.OBSCURITA.get(), lootAmount));
            this.m_183503_().m_7967_((Entity)lootDrop);
        }
        if (this.getResearchProgress() == 100) {
            lootDrop = new ItemEntity(this.m_183503_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)ItemInit.HINT.get(), 1));
            this.m_183503_().m_7967_((Entity)lootDrop);
        }
        if (pKilledByPlayer && (double)this.m_21187_().nextFloat() < 0.1 + 0.03 * (double)pLooting) {
            ItemEntity rareDrop = new ItemEntity(this.m_183503_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)ItemInit.HINT.get(), 1));
            this.m_183503_().m_7967_((Entity)rareDrop);
        }
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.getAttackTick() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("attack", Boolean.valueOf(false)));
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("walk", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void playAttackAnimation() {
        this.setAttackTick(13);
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12010_, 1.0f, 1.0f);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundInit.FLASH.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12008_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12059_;
    }

    protected float m_6121_() {
        return 0.2f;
    }

    public int m_8100_() {
        return super.m_8100_();
    }
}

