/*
 * Decompiled with CFR 0.152.
 */
package com.sethyandrak.obscurio.entity;

import com.sethyandrak.obscurio.block.TanukiStatueBlock;
import com.sethyandrak.obscurio.block.entity.TanukiStatueBlockEntity;
import com.sethyandrak.obscurio.entity.ObscuritaGolemEntity;
import com.sethyandrak.obscurio.init.BlockInit;
import com.sethyandrak.obscurio.init.ItemInit;
import com.sethyandrak.obscurio.init.SoundInit;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class TanukiEntity
extends PathfinderMob
implements IAnimatable {
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    static final Predicate<ItemStack> TANUKI_ITEMS = stack -> stack.m_150930_(Items.f_42398_) || stack.m_150930_(Items.f_42329_) || stack.m_150930_(Items.f_41896_) || stack.m_150930_(Items.f_41826_) || stack.m_150930_(Items.f_41832_) || stack.m_150930_(Items.f_42594_) || stack.m_150930_(Items.f_42583_) || stack.m_150930_(Items.f_42500_) || stack.m_150930_(Items.f_42404_) || stack.m_150930_((Item)ItemInit.MAGIC_LEAF.get()) || stack.m_150930_(Items.f_151049_);
    static final Predicate<ItemEntity> ALLOWED_ITEMS = pItemEntity -> !pItemEntity.m_32063_() && pItemEntity.m_6084_() && !TANUKI_ITEMS.test(pItemEntity.m_32055_());
    private int ticksConsideringTrade;
    private int ticklishCounter;
    private int earTwitchAnim;
    private boolean tradeConsume = true;
    private static final EntityDataAccessor<Boolean> LOOKING_FOR_A_FRIEND = SynchedEntityData.m_135353_(TanukiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CAN_DIE = SynchedEntityData.m_135353_(TanukiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final SimpleContainer inventory = new SimpleContainer(27);

    public TanukiEntity(EntityType<? extends PathfinderMob> p_21683_, Level p_21684_) {
        super(p_21683_, p_21684_);
        this.m_21553_(true);
        this.ticksConsideringTrade = 0;
        this.ticklishCounter = 0;
        this.earTwitchAnim = 0;
    }

    public static AttributeSupplier setAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 26.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22283_, 2.0).m_22268_(Attributes.f_22279_, 0.25).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new ClimbOnTopOfPowderSnowGoal((Mob)this, this.f_19853_));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, ObscuritaGolemEntity.class, 32.0f, 1.0, 1.5));
        this.f_21345_.m_25352_(3, (Goal)new TanukiSearchForItemsGoal());
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(6, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_((Item)ItemInit.MAGIC_LEAF.get())) {
            this.earTwitchAnim = 10;
            return InteractionResult.CONSUME;
        }
        if (stack.m_150930_(Items.f_42402_)) {
            this.ticklishCounter = 25;
            this.m_5496_(SoundEvents.f_12623_, 0.6f, 1.0f);
            return InteractionResult.CONSUME;
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public void m_8107_() {
        if (this.ticklishCounter > 0) {
            --this.ticklishCounter;
        }
        if (this.earTwitchAnim > 0) {
            --this.earTwitchAnim;
        }
        if (!this.f_19853_.f_46443_ && this.m_6084_() && this.m_6142_()) {
            ++this.ticksConsideringTrade;
            ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
            if (!itemstack.m_41619_() && this.ticksConsideringTrade > 60) {
                ItemStack leftovers;
                ItemStack itemstack2 = this.trade(itemstack);
                this.spitOutItem(itemstack2);
                if (!this.tradeConsume && !(leftovers = this.inventory.m_19173_(itemstack)).m_41619_()) {
                    Player player;
                    this.spitOutItem(leftovers);
                    if (this.lookingForAFriend() && (player = this.m_183503_().m_45930_((Entity)this, 16.0)) instanceof ServerPlayer && player != null) {
                        this.spitOutItem(new ItemStack((ItemLike)ItemInit.MAGIC_LEAF.get(), 1));
                        this.setLookingForAFriend(false);
                        CriteriaTriggers.f_10580_.m_68256_((ServerPlayer)player, (Entity)this);
                    }
                }
                this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
            }
        }
        super.m_8107_();
    }

    private ItemStack trade(ItemStack input) {
        ItemStack output;
        this.tradeConsume = true;
        if (input.m_150930_(Items.f_42799_)) {
            output = new ItemStack((ItemLike)Items.f_41826_);
        } else if (input.m_150930_(Items.f_42484_)) {
            output = new ItemStack((ItemLike)Items.f_41832_);
        } else if (input.m_150930_(Items.f_42262_)) {
            output = new ItemStack((ItemLike)Items.f_42500_);
        } else if (input.m_150930_(Items.f_150998_)) {
            output = new ItemStack((ItemLike)Items.f_151049_, 2);
        } else if (input.m_41614_()) {
            output = new ItemStack((ItemLike)Items.f_42583_);
        } else {
            this.tradeConsume = false;
            switch (Item.m_41393_((Item)input.m_41720_()) % 3) {
                case 0: {
                    output = new ItemStack((ItemLike)Items.f_42398_, 1);
                    break;
                }
                case 1: {
                    output = new ItemStack((ItemLike)Items.f_42329_, 1);
                    break;
                }
                case 2: {
                    output = new ItemStack((ItemLike)Items.f_41896_, 1);
                    break;
                }
                default: {
                    output = new ItemStack((ItemLike)Items.f_42398_, 1);
                }
            }
        }
        return output;
    }

    private void dropItemStack(ItemStack p_28606_) {
        ItemEntity itementity = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), p_28606_);
        this.f_19853_.m_7967_((Entity)itementity);
    }

    private void spitOutItem(ItemStack p_28602_) {
        if (!p_28602_.m_41619_() && !this.f_19853_.f_46443_) {
            ItemEntity itementity = new ItemEntity(this.f_19853_, this.m_20185_() + this.m_20154_().f_82479_, this.m_20186_() + 1.0, this.m_20189_() + this.m_20154_().f_82481_, p_28602_);
            itementity.m_32010_(40);
            itementity.m_32052_(this.m_142081_());
            this.m_5496_(SoundEvents.f_11952_, 1.0f, 1.0f);
            this.f_19853_.m_7967_((Entity)itementity);
        }
    }

    protected void m_7581_(ItemEntity p_28514_) {
        ItemStack itemstack = p_28514_.m_32055_();
        if (this.m_7252_(itemstack)) {
            int i = itemstack.m_41613_();
            if (i > 1) {
                this.dropItemStack(itemstack.m_41620_(i - 1));
            }
            this.spitOutItem(this.m_6844_(EquipmentSlot.MAINHAND));
            this.m_21053_(p_28514_);
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack.m_41620_(1));
            this.f_21347_[EquipmentSlot.MAINHAND.m_20749_()] = 2.0f;
            this.m_7938_((Entity)p_28514_, itemstack.m_41613_());
            p_28514_.m_146870_();
            this.ticksConsideringTrade = 0;
        }
    }

    public boolean m_7252_(ItemStack p_28578_) {
        Item item = p_28578_.m_41720_();
        ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
        return itemstack.m_41619_() && !TANUKI_ITEMS.test(item.m_7968_());
    }

    public boolean m_7066_(ItemStack p_28552_) {
        EquipmentSlot equipmentslot = Mob.m_147233_((ItemStack)p_28552_);
        if (!this.m_6844_(equipmentslot).m_41619_()) {
            return false;
        }
        return equipmentslot == EquipmentSlot.MAINHAND && super.m_7066_(p_28552_);
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public boolean fullInventory() {
        boolean fullInv = true;
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            if (!this.inventory.m_8020_(i).m_41619_()) continue;
            fullInv = false;
        }
        return fullInv;
    }

    public void m_6043_() {
        if (!this.m_21532_() && !this.m_8023_()) {
            Player entity = this.f_19853_.m_45930_((Entity)this, -1.0);
            if (entity != null) {
                int i;
                int j;
                double d0 = entity.m_20280_((Entity)this);
                if (d0 > (double)(j = (i = this.m_6095_().m_20674_().m_21611_()) * i) && this.m_6785_(d0)) {
                    this.turnIntoStatue();
                }
                int k = this.m_6095_().m_20674_().m_21612_();
                int l = k * k;
                if (this.f_20891_ > 600 && this.f_19796_.nextInt(800) == 0 && d0 > (double)l && this.m_6785_(d0)) {
                    this.turnIntoStatue();
                } else if (d0 < (double)l) {
                    this.f_20891_ = 0;
                }
            }
        } else {
            this.f_20891_ = 0;
        }
    }

    public boolean m_6785_(double distToPlayer) {
        return true;
    }

    public void m_6667_(DamageSource source) {
        if (this.canDie()) {
            super.m_6667_(source);
        } else {
            this.turnIntoStatue();
        }
    }

    private void turnIntoStatue() {
        BlockPos pos;
        Level world = this.m_183503_();
        if (world.m_8055_((pos = this.m_20097_().m_7494_()).m_7495_()).m_60795_()) {
            pos = pos.m_7495_();
        }
        BlockState state = (BlockState)((Block)BlockInit.ODD_STATUE.get()).m_49966_().m_61124_((Property)TanukiStatueBlock.FACING, (Comparable)this.m_6350_());
        world.m_46597_(pos, state);
        BlockEntity blockEntity = this.f_19853_.m_7702_(pos);
        if (blockEntity instanceof TanukiStatueBlockEntity) {
            ((TanukiStatueBlockEntity)blockEntity).transferInventoryFrom(this.inventory);
        } else {
            System.out.println("Block entity at " + pos + " is missing");
        }
        this.m_146870_();
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setCanDie(tag.m_128471_("canDie"));
        this.setLookingForAFriend(tag.m_128471_("lookingForAFriend"));
        this.inventory.m_7797_(tag.m_128437_("Inventory", 10));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("canDie", this.canDie());
        tag.m_128379_("lookingForAFriend", this.lookingForAFriend());
        tag.m_128365_("Inventory", (Tag)this.inventory.m_7927_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CAN_DIE, (Object)false);
        this.f_19804_.m_135372_(LOOKING_FOR_A_FRIEND, (Object)true);
    }

    public int getTicksConsideringTrade() {
        return this.ticksConsideringTrade;
    }

    public int getTicklishCounter() {
        return this.ticklishCounter;
    }

    public void setTicklishCounter(int value) {
        this.ticklishCounter = value;
    }

    public int getEarTwitchAnim() {
        return this.earTwitchAnim;
    }

    public boolean canDie() {
        return (Boolean)this.f_19804_.m_135370_(CAN_DIE);
    }

    public void setCanDie(boolean canDie) {
        this.f_19804_.m_135381_(CAN_DIE, (Object)canDie);
    }

    public boolean lookingForAFriend() {
        return (Boolean)this.f_19804_.m_135370_(LOOKING_FOR_A_FRIEND);
    }

    public void setLookingForAFriend(boolean looking) {
        this.f_19804_.m_135381_(LOOKING_FOR_A_FRIEND, (Object)looking);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.getTicklishCounter() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("fidget1", Boolean.valueOf(true)));
            event.getController().setAnimationSpeed(1.5);
            return PlayState.CONTINUE;
        }
        if (this.getEarTwitchAnim() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("ear_twitch", Boolean.valueOf(true)));
            event.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("Walk", Boolean.valueOf(true)));
            event.getController().setAnimationSpeed(1.8);
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("Idle", Boolean.valueOf(true)));
        event.getController().setAnimationSpeed(1.0);
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "idle_walk_controller", 1.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12354_, 1.0f, 1.0f);
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_11948_;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12177_;
    }

    public int m_8100_() {
        return 150;
    }

    protected SoundEvent m_5592_() {
        if (this.canDie()) {
            return SoundEvents.f_11732_;
        }
        return (SoundEvent)SoundInit.DISAPEAR.get();
    }

    protected float m_6121_() {
        return 0.8f;
    }

    class TanukiSearchForItemsGoal
    extends Goal {
        public TanukiSearchForItemsGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (!TanukiEntity.this.m_6844_(EquipmentSlot.MAINHAND).m_41619_()) {
                return false;
            }
            if (TanukiEntity.this.m_5448_() == null && TanukiEntity.this.m_142581_() == null) {
                if (TanukiEntity.this.fullInventory()) {
                    return false;
                }
                if (TanukiEntity.this.m_21187_().nextInt(TanukiSearchForItemsGoal.m_186073_((int)10)) != 0) {
                    return false;
                }
                List list = TanukiEntity.this.f_19853_.m_6443_(ItemEntity.class, TanukiEntity.this.m_142469_().m_82377_(8.0, 8.0, 8.0), ALLOWED_ITEMS);
                return !list.isEmpty() && TanukiEntity.this.m_6844_(EquipmentSlot.MAINHAND).m_41619_();
            }
            return false;
        }

        public void m_8037_() {
            List list = TanukiEntity.this.f_19853_.m_6443_(ItemEntity.class, TanukiEntity.this.m_142469_().m_82377_(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            ItemStack itemstack = TanukiEntity.this.m_6844_(EquipmentSlot.MAINHAND);
            if (itemstack.m_41619_() && !list.isEmpty()) {
                TanukiEntity.this.m_21573_().m_5624_((Entity)list.get(0), (double)1.2f);
            }
        }

        public void m_8056_() {
            List list = TanukiEntity.this.f_19853_.m_6443_(ItemEntity.class, TanukiEntity.this.m_142469_().m_82377_(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            if (!list.isEmpty()) {
                TanukiEntity.this.m_21573_().m_5624_((Entity)list.get(0), (double)1.2f);
            }
        }
    }
}

