/*
 * Decompiled with CFR 0.152.
 */
package com.sethyandrak.obscurio.init;

import com.google.common.base.Supplier;
import com.sethyandrak.obscurio.Obscurio;
import com.sethyandrak.obscurio.block.InmovableBlock;
import com.sethyandrak.obscurio.block.ObscurioOreBlock;
import com.sethyandrak.obscurio.block.ObscurioShrineBlock;
import com.sethyandrak.obscurio.block.ObscurioTotemBlock;
import com.sethyandrak.obscurio.block.TanukiStatueBlock;
import com.sethyandrak.obscurio.init.ItemInit;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class BlockInit {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"obscurio");
    public static final DeferredRegister<Item> ITEMS = ItemInit.ITEMS;
    public static final RegistryObject<Block> OBSCURITA_BLOCK = BlockInit.register("obscurita_block", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76422_).m_60913_(2.0f, 4.0f).m_60918_(SoundType.f_56743_)), object -> () -> new BlockItem((Block)object.get(), new Item.Properties().m_41491_(Obscurio.OBSCURIO_TAB)));
    public static final RegistryObject<Block> OBSCURITA_STAIRS = BlockInit.register("obscurita_stairs", () -> new StairBlock(() -> ((Block)OBSCURITA_BLOCK.get()).m_49966_(), BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76422_).m_60913_(2.0f, 4.0f).m_60918_(SoundType.f_56743_)), object -> () -> new BlockItem((Block)object.get(), new Item.Properties().m_41491_(Obscurio.OBSCURIO_TAB)));
    public static final RegistryObject<SlabBlock> OBSCURITA_SLAB = BlockInit.register("obscurita_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76422_).m_60913_(2.0f, 4.0f).m_60918_(SoundType.f_56743_)), object -> () -> new BlockItem((Block)object.get(), new Item.Properties().m_41491_(Obscurio.OBSCURIO_TAB)));
    public static final RegistryObject<Block> OBSCURITA_TOTEM = BlockInit.register("obscurita_totem", () -> new ObscurioTotemBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76382_).m_60913_(2.0f, 4.0f).m_60918_(SoundType.f_56743_).m_60991_((state, getter, pos) -> true)), object -> () -> new BlockItem((Block)object.get(), new Item.Properties().m_41491_(Obscurio.OBSCURIO_TAB)));
    public static final RegistryObject<Block> OBSCURITA_TOTEM_DORMANT = BlockInit.register("obscurita_totem_dormant", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76382_).m_60913_(2.0f, 4.0f).m_60918_(SoundType.f_56743_).m_60991_((state, getter, pos) -> true)), object -> () -> new BlockItem((Block)object.get(), new Item.Properties().m_41491_(Obscurio.OBSCURIO_TAB)));
    public static final RegistryObject<Block> TRANSING_TOTEM = BlockInit.register("transing_totem", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76382_).m_60913_(2.0f, 4.0f).m_60918_(SoundType.f_56743_).m_60991_((state, getter, pos) -> true)), object -> () -> new BlockItem((Block)object.get(), new Item.Properties().m_41491_(Obscurio.OBSCURIO_TAB)));
    public static final RegistryObject<Block> OBSCURITA_ORE = BlockInit.register("obscurita_ore", () -> new ObscurioOreBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76409_).m_60913_(2.0f, 4.0f).m_60918_(SoundType.f_56742_).m_60999_()), object -> () -> new BlockItem((Block)object.get(), new Item.Properties().m_41491_(Obscurio.OBSCURIO_TAB)));
    public static final RegistryObject<Block> OBSCURITA_ORE_DEEPSLATE = BlockInit.register("obscurita_ore_deepslate", () -> new ObscurioOreBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76409_).m_60913_(2.0f, 4.0f).m_60918_(SoundType.f_56742_).m_60999_()), object -> () -> new BlockItem((Block)object.get(), new Item.Properties().m_41491_(Obscurio.OBSCURIO_TAB)));
    public static final RegistryObject<Block> FAKE_BEDROCK = BlockInit.register("fake_bedrock", () -> new InmovableBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76282_, (MaterialColor)MaterialColor.f_76365_).m_60978_(50.0f).m_60918_(SoundType.f_56742_).m_60999_()), object -> () -> new BlockItem((Block)object.get(), new Item.Properties().m_41486_()));
    public static final RegistryObject<Block> OBSCURITA_SHRINE = BlockInit.register("obscurita_shrine", () -> new ObscurioShrineBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76422_).m_60913_(2.0f, 4.0f).m_60918_(SoundType.f_56743_)), object -> () -> new BlockItem((Block)object.get(), new Item.Properties().m_41491_(Obscurio.OBSCURIO_TAB)));
    public static final RegistryObject<Block> OBSCURITA_GLASS = BlockInit.register("obscurita_glass", () -> new GlassBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60978_(0.3f).m_60918_(SoundType.f_56744_).m_60955_().m_60922_(BlockInit::never).m_60924_(BlockInit::never).m_60960_(BlockInit::never).m_60971_(BlockInit::never)), object -> () -> new BlockItem((Block)object.get(), new Item.Properties().m_41491_(Obscurio.OBSCURIO_TAB)));
    public static final RegistryObject<Block> ODD_STATUE = BlockInit.registerBlock("odd_statue", () -> new TanukiStatueBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60955_().m_60913_(2.5f, 6.0f)));

    private static Boolean never(BlockState p_50779_, BlockGetter p_50780_, BlockPos p_50781_, EntityType<?> p_50782_) {
        return false;
    }

    private static boolean never(BlockState p_50806_, BlockGetter p_50807_, BlockPos p_50808_) {
        return false;
    }

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<? extends T> block) {
        return BLOCKS.register(name, block);
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<? extends T> block, Function<RegistryObject<T>, Supplier<? extends Item>> item) {
        RegistryObject<? extends T> obj = BlockInit.registerBlock(name, block);
        ITEMS.register(name, (java.util.function.Supplier)item.apply(obj));
        return obj;
    }
}

