/*
 * Decompiled with CFR 0.152.
 */
package com.sethyandrak.obscurio.item;

import com.sethyandrak.obscurio.block.ObscurioTotemBlock;
import com.sethyandrak.obscurio.entity.JackalopeEntity;
import com.sethyandrak.obscurio.entity.MothmanEntity;
import com.sethyandrak.obscurio.entity.ObscuritaGolemEntity;
import com.sethyandrak.obscurio.entity.TanukiEntity;
import com.sethyandrak.obscurio.init.BlockInit;
import com.sethyandrak.obscurio.init.ItemInit;
import com.sethyandrak.obscurio.init.SoundInit;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class HintItem
extends Item {
    private final int HINT_COOLDOWN_TICKS = 600;

    public HintItem(Item.Properties properties) {
        super(properties);
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BLOCK;
    }

    private String generateHint(Level level, Player player, InteractionHand hand, @Nullable BlockState block, @Nullable LivingEntity living) {
        ItemStack item;
        if (living != null) {
            if (living instanceof ObscuritaGolemEntity) {
                return "Explores, fights the unknown, generates hints.";
            }
            if (living instanceof TanukiEntity) {
                return "Friendly prankster. Has a secret stash.";
            }
            if (living instanceof JackalopeEntity) {
                return "Dangerous. Not alone. Unusual leather.";
            }
            if (living instanceof MothmanEntity) {
                return "Harmles if unprovoked. Let him do and grab a feather.";
            }
        }
        if (block != null) {
            if (block.m_60713_((Block)BlockInit.OBSCURITA_ORE.get()) || block.m_60713_((Block)BlockInit.OBSCURITA_ORE_DEEPSLATE.get())) {
                return "Iron tool required. Not that one.";
            }
            if (block.m_60713_((Block)BlockInit.OBSCURITA_TOTEM.get())) {
                switch ((Integer)block.m_61143_((Property)ObscurioTotemBlock.TOTEM_HEIGHT)) {
                    case 0: {
                        return "Lonely totems go dormant, usually";
                    }
                    case 1: {
                        return "Protects against creepers somewhat";
                    }
                    case 2: {
                        return "The 3 noise hints the 7 key";
                    }
                    case 3: {
                        return "Softens the unbreakable";
                    }
                    case 4: {
                        return "Leads below";
                    }
                    case 5: {
                        return "Removes curses";
                    }
                    case 6: {
                        return "Source of creation. Unlock more, then unlock more...";
                    }
                    case 7: {
                        return "Likes clear skies";
                    }
                    case 8: {
                        return "Likes rain";
                    }
                    case 9: {
                        return "Likes storm";
                    }
                    case 10: {
                        return "Likes flowers";
                    }
                    case 11: {
                        return "Not implemented";
                    }
                    case 12: {
                        return "Not implemented";
                    }
                    case 13: {
                        return "Grows";
                    }
                    case 14: {
                        return "Shrinks";
                    }
                }
            }
            if (block.m_60713_((Block)BlockInit.OBSCURITA_TOTEM_DORMANT.get())) {
                return "Deactivated. Safe for decor. Merge two to wake back up.";
            }
            if (block.m_60713_((Block)BlockInit.OBSCURITA_SHRINE.get())) {
                switch (player.m_21187_().nextInt(9)) {
                    case 1: {
                        return "one, two, three, banana";
                    }
                    case 2: {
                        return "My tortilla recipe: gold?, potato, egg.";
                    }
                    case 3: {
                        return "Honey dissolves gold?";
                    }
                    case 4: {
                        return "Make rotten flesh into leather with this one simple trick: obscurita";
                    }
                    case 5: {
                        return "More feathers for moff!";
                    }
                    case 6: {
                        return "Alternative recipe for ninja, using normal leather? More expensive...";
                    }
                    case 7: {
                        return "Copy recoiler settings easily here!";
                    }
                    case 8: {
                        return "Coat the cake in obscurita. Use a catalyst. (WIP: limited choice)";
                    }
                }
                return "Central slot (catalyst) not spent. Results shaped similarish to catalyst, sometimes.";
            }
            if (block.m_60713_((Block)BlockInit.TRANSING_TOTEM.get())) {
                return "Drops potion ingredient.";
            }
            if (block.m_60713_((Block)BlockInit.FAKE_BEDROCK.get())) {
                return "Obsidian disguised as bedrock.";
            }
            if (block.m_60713_((Block)BlockInit.ODD_STATUE.get())) {
                return "Don't be fooled... Leaf... Feather...";
            }
        }
        if ((item = hand.equals((Object)InteractionHand.MAIN_HAND) ? player.m_21120_(InteractionHand.OFF_HAND) : player.m_21120_(InteractionHand.MAIN_HAND)).m_150930_((Item)ItemInit.OBSCURITA.get())) {
            return "Base building block for obscurio. Made of potasium.";
        }
        if (item.m_150930_((Item)ItemInit.MOFF.get())) {
            return "Hidden potencial... Shrine... Feathers...";
        }
        if (item.m_150930_((Item)ItemInit.RECOILER.get())) {
            return "Requires pearl.";
        }
        if (item.m_150930_((Item)ItemInit.GENDER_STONE.get())) {
            return "Brewing ingredient.";
        }
        if (item.m_150930_((Item)ItemInit.ANYTHING_CAKE.get())) {
            return "Looks can be deceiving. Take it to a shrine?";
        }
        if (item.m_150930_((Item)ItemInit.LIQUID_GOLD_REMNANT.get())) {
            return "Spent for a second, just grow it back on a crafting grid";
        }
        if (item.m_150930_((Item)ItemInit.LIQUID_GOLD.get())) {
            return "Endless gold, if you are not in a hurry";
        }
        if (item.m_150930_((Item)ItemInit.DRAGON_OMELET.get())) {
            return "Made with real dragon egg. Good as a golden apple";
        }
        if (item.m_150930_((Item)ItemInit.OBSCURITA_DETECTOR.get())) {
            return "Very WIP. Might even remove later. Keept around for debug purposes.";
        }
        if (item.m_150930_((Item)ItemInit.SMALL_ANTLER.get())) {
            return "Raredrop trophy. Can still curse.";
        }
        if (item.m_150930_((Item)ItemInit.MAGIC_LEAF.get())) {
            return "Sign of friendship. Key to secrets.";
        }
        if (item.m_150930_((Item)ItemInit.WEIRD_HIDE.get())) {
            return "Different from normal rabbit leather. Check crafting book.";
        }
        if (item.m_150930_((Item)ItemInit.NINJA_LEATHER.get())) {
            return "Usefull for armor";
        }
        if (item.m_150930_((Item)ItemInit.NINJA_BOOTS.get()) || item.m_150930_((Item)ItemInit.NINJA_PANTS.get()) || item.m_150930_((Item)ItemInit.NINJA_TUNIC.get()) || item.m_150930_((Item)ItemInit.NINJA_MASK.get())) {
            return "For sneaking aroung while protected.";
        }
        if (item.m_150930_((Item)ItemInit.ODD_STATUE.get())) {
            return "You can feel it moving...";
        }
        if (item.m_150930_((Item)ItemInit.HINT.get())) {
            return "Use hints on blocks and mobs from Obscurio for more info. Use it on items by holding the item on the other hand.";
        }
        if (item.m_150930_((Item)ItemInit.UNUSUAL_FEATHER.get())) {
            return "Related to moff. A powerfull catalyst. ";
        }
        switch (player.m_21187_().nextInt(16)) {
            case 1: {
                return "Bone meal helps all plants grow.";
            }
            case 2: {
                return "Ticklish... statue... taiga...";
            }
            case 3: {
                return "Trans people can air dash and take no fall damage.";
            }
            case 4: {
                return "Control what hint you get by clicking on a thing, or using both hands";
            }
            case 5: {
                return "Be carefull, armor stands can kill you.";
            }
            case 6: {
                return "Chorus... Drink...";
            }
            case 7: {
                return "Pokerus increases XP obtained, but finding it is very rare";
            }
            case 8: {
                return "Runin Dusori Misuasir";
            }
            case 9: {
                return "Dont make totems too tall, lest you be smiten for your hubris";
            }
            case 10: {
                return "Try pressing the arrows?";
            }
            case 11: {
                return "Hunts... nightmares...";
            }
            case 12: {
                return "Dont fall 12 or 13 blocks in a boat. Or 49, or 51.";
            }
            case 13: {
                return "Two bad effects may cancell each other";
            }
            case 14: {
                return "Some starts: '<V>A>V>' 'V>A>A<' '<A>V>A' ";
            }
            case 15: {
                return "Some endings: '>V>A>V<' 'A<V<V>' 'A>V>A<' ";
            }
        }
        return "Conceived during... lightning strike...";
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack stack = pPlayer.m_21120_(pHand);
        String hintText = this.generateHint(pLevel, pPlayer, pHand, null, null);
        if (pPlayer instanceof ServerPlayer) {
            ((ServerPlayer)pPlayer).m_6352_((Component)new TextComponent(hintText).m_130940_(ChatFormatting.AQUA), Util.f_137441_);
            CriteriaTriggers.f_145090_.m_163865_((ServerPlayer)pPlayer, stack);
        }
        pLevel.m_6263_(pPlayer, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), (SoundEvent)SoundInit.HINT_TUNE.get(), SoundSource.PLAYERS, 1.2f, 1.0f);
        pPlayer.m_36335_().m_41524_((Item)this, 600);
        stack.m_41774_(1);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        Player player = pContext.m_43723_();
        ItemStack stack = player.m_21120_(pContext.m_43724_());
        Level level = pContext.m_43725_();
        BlockState state = level.m_8055_(pContext.m_8083_());
        String hintText = this.generateHint(level, player, pContext.m_43724_(), state, null);
        if (player instanceof ServerPlayer) {
            ((ServerPlayer)player).m_6352_((Component)new TextComponent(hintText).m_130940_(ChatFormatting.AQUA), Util.f_137441_);
            CriteriaTriggers.f_145090_.m_163865_((ServerPlayer)player, stack);
        }
        level.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundInit.HINT_TUNE.get(), SoundSource.PLAYERS, 1.2f, 1.0f);
        player.m_36335_().m_41524_((Item)this, 600);
        stack.m_41774_(1);
        return InteractionResult.CONSUME;
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity livingEntity, InteractionHand hand) {
        Level level = player.m_183503_();
        String hintText = this.generateHint(level, player, hand, null, livingEntity);
        if (player instanceof ServerPlayer) {
            ((ServerPlayer)player).m_6352_((Component)new TextComponent(hintText).m_130940_(ChatFormatting.AQUA), Util.f_137441_);
            CriteriaTriggers.f_145090_.m_163865_((ServerPlayer)player, stack);
        }
        level.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundInit.HINT_TUNE.get(), SoundSource.PLAYERS, 1.2f, 1.0f);
        player.m_36335_().m_41524_((Item)this, 600);
        stack.m_41774_(1);
        return InteractionResult.CONSUME;
    }
}

