/*
 * Decompiled with CFR 0.152.
 */
package com.sethyandrak.obscurio.item;

import com.sethyandrak.obscurio.init.SoundInit;
import com.sethyandrak.obscurio.item.client.RecoilerRenderer;
import com.sethyandrak.obscurio.utilities.InventoryUtil;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.IItemRenderProperties;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class RecoilerAnimatedItem
extends Item
implements IAnimatable {
    public AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private static final String TAG_PRIMED = "obscurio.recoiler.primed";
    private static final String TAG_DIMENSION = "obscurio.recoiler.dimension";
    private static final String TAG = "obscurio.recoiler";

    public RecoilerAnimatedItem(Item.Properties properties) {
        super(properties);
    }

    public int m_8105_(ItemStack pStack) {
        return RecoilerAnimatedItem.isPrimed(pStack) ? 256 : 32;
    }

    public UseAnim m_6164_(ItemStack stack) {
        if (RecoilerAnimatedItem.isPrimed(stack)) {
            return UseAnim.BOW;
        }
        return UseAnim.SPEAR;
    }

    public boolean m_41463_(ItemStack pStack) {
        return !RecoilerAnimatedItem.isPrimed(pStack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        player.m_6672_(hand);
        if (!RecoilerAnimatedItem.isPrimed(itemStack)) {
            level.m_5594_(null, player.m_20097_(), SoundEvents.f_11843_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int ticksLeft) {
        if (RecoilerAnimatedItem.isPrimed(stack)) {
            if (!level.m_5776_() && entity.m_20184_().m_82553_() > 0.0785) {
                entity.m_5810_();
                level.m_5594_(null, entity.m_20097_(), (SoundEvent)SoundInit.DISSAPOINTMENT.get(), entity.m_5720_(), 1.0f, 1.0f);
                if (entity instanceof Player) {
                    ((Player)entity).m_36335_().m_41524_((Item)this, 15);
                }
            }
            if (entity instanceof Player && ticksLeft % 10 == 0) {
                level.m_5594_((Player)entity, entity.m_20097_(), (SoundEvent)SoundInit.AIR_BUILDUP_PARTIAL.get(), entity.m_5720_(), 0.8f * (256.0f - (float)ticksLeft / 256.0f), 1.0f);
                if (ticksLeft < 41) {
                    level.m_5594_((Player)entity, entity.m_20097_(), (SoundEvent)SoundInit.AIR_BUILDUP_FINISH.get(), entity.m_5720_(), 0.4f, 1.0f);
                }
            }
        }
        super.m_5929_(level, entity, stack, ticksLeft);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        if (RecoilerAnimatedItem.isPrimed(stack) && stack.m_41782_()) {
            if (stack.m_41783_().m_128461_(TAG_DIMENSION).equals(level.m_6042_().m_63969_().toString())) {
                double targetX = stack.m_41783_().m_128459_("obscurio.recoiler.X");
                double targetY = stack.m_41783_().m_128459_("obscurio.recoiler.Y");
                double targetZ = stack.m_41783_().m_128459_("obscurio.recoiler.Z");
                level.m_5594_(null, entity.m_20097_(), (SoundEvent)SoundInit.DISAPEAR.get(), SoundSource.PLAYERS, 0.8f, 1.0f);
                entity.m_6021_(targetX, targetY, targetZ);
                stack.m_41774_(1);
            } else {
                level.m_5594_(null, entity.m_20097_(), (SoundEvent)SoundInit.DISSAPOINTMENT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        return stack;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int ticksLeft) {
        if (!level.m_5776_() && ticksLeft <= 0) {
            if (RecoilerAnimatedItem.isPrimed(stack)) {
                if (stack.m_41782_()) {
                    if (stack.m_41783_().m_128461_(TAG_DIMENSION).equals(level.m_6042_().m_63969_().toString())) {
                        double targetX = stack.m_41783_().m_128459_("obscurio.recoiler.X");
                        double targetY = stack.m_41783_().m_128459_("obscurio.recoiler.Y");
                        double targetZ = stack.m_41783_().m_128459_("obscurio.recoiler.Z");
                        level.m_5594_(null, entity.m_20097_(), (SoundEvent)SoundInit.DISAPEAR.get(), SoundSource.PLAYERS, 0.8f, 1.0f);
                        entity.m_6021_(targetX, targetY, targetZ);
                        stack.m_41774_(1);
                    } else {
                        level.m_5594_(null, entity.m_20097_(), (SoundEvent)SoundInit.DISSAPOINTMENT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                }
            } else {
                if (entity instanceof Player && !InventoryUtil.hasPlayerStackInInventory((Player)entity, Items.f_42584_)) {
                    level.m_5594_(null, entity.m_20097_(), (SoundEvent)SoundInit.DISSAPOINTMENT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    super.m_5551_(stack, level, entity, ticksLeft);
                    return;
                }
                CompoundTag nbtData = stack.m_41784_();
                nbtData.m_128359_(TAG_DIMENSION, level.m_6042_().m_63969_().toString());
                nbtData.m_128347_("obscurio.recoiler.X", entity.m_20185_());
                nbtData.m_128347_("obscurio.recoiler.Y", entity.m_20186_());
                nbtData.m_128347_("obscurio.recoiler.Z", entity.m_20189_());
                stack.m_41751_(nbtData);
                level.m_5594_(null, entity.m_20097_(), SoundEvents.f_11841_, SoundSource.PLAYERS, 1.0f, 1.0f);
                RecoilerAnimatedItem.setPrimed(stack, true);
            }
        }
        super.m_5551_(stack, level, entity, ticksLeft);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        return InteractionResult.PASS;
    }

    public static boolean isPrimed(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        return compoundtag != null && compoundtag.m_128471_(TAG_PRIMED);
    }

    public static void setPrimed(ItemStack stack, boolean primed) {
        CompoundTag compoundTag = stack.m_41784_();
        compoundTag.m_128379_(TAG_PRIMED, primed);
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IItemRenderProperties(){
            private final BlockEntityWithoutLevelRenderer renderer = new RecoilerRenderer();

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "idle_controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "primed_controller", 0.0f, this::predicate2));
        data.addAnimationController(new AnimationController((IAnimatable)this, "startup_controller", 0.0f, this::predicate3));
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("coil_spin", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState predicate2(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("body_spin", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState predicate3(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("coil_compress", Boolean.valueOf(false)).addAnimation("coil_uncompress", Boolean.valueOf(false)));
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

