/*
 * Decompiled with CFR 0.152.
 */
package com.sethyandrak.obscurio.item.armor;

import com.sethyandrak.obscurio.init.EffectInit;
import com.sethyandrak.obscurio.item.armor.ModArmorMaterials;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.item.GeoArmorItem;

public class NinjaArmorItem
extends GeoArmorItem
implements IAnimatable {
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public NinjaArmorItem(ArmorMaterial materialIn, EquipmentSlot slot, Item.Properties builder) {
        super(materialIn, slot, builder);
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        if (!world.m_5776_() && this.m_40402_().equals((Object)EquipmentSlot.HEAD) && this.hasFullSuitOfArmorOn(player)) {
            this.evaluateArmorEffects(player);
        }
    }

    private void evaluateArmorEffects(Player player) {
        MobEffectInstance statusEffect = new MobEffectInstance((MobEffect)EffectInit.NINJA.get(), 200, 0);
        ModArmorMaterials armorMaterial = ModArmorMaterials.NINJA_LEATHER;
        if (this.hasCorrectArmorOn(armorMaterial, player)) {
            this.addStatusEffectForMaterial(player, armorMaterial, statusEffect);
        }
    }

    private void addStatusEffectForMaterial(Player player, ArmorMaterial mapArmorMaterial, MobEffectInstance statusEffect) {
        boolean hasPlayerEffect = player.m_21023_(statusEffect.m_19544_());
        int duration = 0;
        if (hasPlayerEffect) {
            duration = player.m_21124_(statusEffect.m_19544_()).m_19557_();
        }
        if (this.hasCorrectArmorOn(mapArmorMaterial, player) && duration < 6) {
            if (hasPlayerEffect) {
                player.m_21195_(statusEffect.m_19544_());
            }
            player.m_7292_(new MobEffectInstance(statusEffect.m_19544_(), statusEffect.m_19557_(), statusEffect.m_19564_(), false, false));
        }
    }

    private boolean hasFullSuitOfArmorOn(Player player) {
        ItemStack boots = player.m_150109_().m_36052_(0);
        ItemStack leggings = player.m_150109_().m_36052_(1);
        ItemStack breastplate = player.m_150109_().m_36052_(2);
        ItemStack helmet = player.m_150109_().m_36052_(3);
        return !helmet.m_41619_() && !breastplate.m_41619_() && !leggings.m_41619_() && !boots.m_41619_();
    }

    private boolean hasCorrectArmorOn(ArmorMaterial material, Player player) {
        ArmorItem boots = (ArmorItem)player.m_150109_().m_36052_(0).m_41720_();
        ArmorItem leggings = (ArmorItem)player.m_150109_().m_36052_(1).m_41720_();
        ArmorItem breastplate = (ArmorItem)player.m_150109_().m_36052_(2).m_41720_();
        ArmorItem helmet = (ArmorItem)player.m_150109_().m_36052_(3).m_41720_();
        return helmet.m_40401_() == material && breastplate.m_40401_() == material && leggings.m_40401_() == material && boots.m_40401_() == material;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 20.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }
}

