/*
 * Decompiled with CFR 0.152.
 */
package com.sethyandrak.obscurio.keybindings;

import com.sethyandrak.obscurio.networking.CustomMessages;
import com.sethyandrak.obscurio.networking.packet.FailedSpellC2SPacket;
import com.sethyandrak.obscurio.networking.packet.HealingSpellC2SPacket;
import com.sethyandrak.obscurio.networking.packet.IceAmmoSpellC2SPacket;
import com.sethyandrak.obscurio.networking.packet.NormalAmmoSpellC2SPacket;
import com.sethyandrak.obscurio.networking.packet.PoisonAmmoSpellC2SPacket;
import com.sethyandrak.obscurio.networking.packet.SeekingSpellC2SPacket;
import net.minecraft.nbt.CompoundTag;

public class PlayerSequence {
    private long currentSequence = 1L;
    private int ticksToIdle = 0;

    public void tick() {
        if (this.ticksToIdle > 0) {
            if (this.ticksToIdle == 1) {
                this.resetSequence();
                CustomMessages.sendToServer(new FailedSpellC2SPacket());
            } else {
                --this.ticksToIdle;
            }
        }
    }

    public void resetSequence() {
        this.currentSequence = 1L;
        this.ticksToIdle = 0;
    }

    public long getSequence() {
        return this.currentSequence;
    }

    public void setTicksToIdle(int ticks) {
        this.ticksToIdle = ticks;
    }

    public int getTicksToIdle() {
        return this.ticksToIdle;
    }

    public void addToSequence(short addition) {
        if (addition < 0 || addition > 3) {
            System.out.println("Cant add " + addition + " to sequence, out of bounds. Range should be from 0-3");
        }
        this.currentSequence = this.currentSequence * 4L + (long)addition;
        this.testCurrentSequence();
    }

    public void testCurrentSequence() {
        if (this.currentSequence == 23948L) {
            CustomMessages.sendToServer(new HealingSpellC2SPacket());
            this.resetSequence();
        }
        if (this.currentSequence == 4663L) {
            CustomMessages.sendToServer(new SeekingSpellC2SPacket());
            this.resetSequence();
        }
        if (this.currentSequence == 108229490L) {
            CustomMessages.sendToServer(new IceAmmoSpellC2SPacket());
            this.resetSequence();
        }
        if (this.currentSequence == 24322663L) {
            CustomMessages.sendToServer(new NormalAmmoSpellC2SPacket());
            this.resetSequence();
        }
        if (this.currentSequence == 0x6373736L) {
            CustomMessages.sendToServer(new PoisonAmmoSpellC2SPacket());
            this.resetSequence();
        }
    }

    public void copyFrom(PlayerSequence source) {
        this.currentSequence = source.getSequence();
        this.ticksToIdle = source.getTicksToIdle();
    }

    public void saveNBTData(CompoundTag tag) {
        tag.m_128405_("obscurio.sequence.ticksToIdle", this.ticksToIdle);
        tag.m_128356_("obscurio.currentSequence", this.currentSequence);
    }

    public void loadNBTData(CompoundTag tag) {
        this.ticksToIdle = tag.m_128451_("obscurio.sequence.ticksToIdle");
        this.currentSequence = tag.m_128454_("obscurio.currentSequence");
    }
}

