/*
 * Decompiled with CFR 0.152.
 */
package com.sethyandrak.obscurio.keybindings;

import com.sethyandrak.obscurio.keybindings.PlayerSequence;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class PlayerSequenceProvider
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static Capability<PlayerSequence> PLAYER_SEQUENCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerSequence>(){});
    private PlayerSequence playerSequence = null;
    private final LazyOptional<PlayerSequence> lazyPlayerSequence = LazyOptional.of(this::getOrCreatePlayerSequence);

    @Nonnull
    private PlayerSequence getOrCreatePlayerSequence() {
        if (this.playerSequence == null) {
            this.playerSequence = new PlayerSequence();
        }
        return this.playerSequence;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        if (cap == PLAYER_SEQUENCE) {
            return this.lazyPlayerSequence.cast();
        }
        return LazyOptional.empty();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return this.getCapability(cap);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        this.getOrCreatePlayerSequence().saveNBTData(nbt);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.getOrCreatePlayerSequence().loadNBTData(nbt);
    }
}

