/*
 * Decompiled with CFR 0.152.
 */
package com.sethyandrak.obscurio.networking;

import com.sethyandrak.obscurio.networking.packet.DashS2CPacket;
import com.sethyandrak.obscurio.networking.packet.ExampleC2SPacket;
import com.sethyandrak.obscurio.networking.packet.FailedSpellC2SPacket;
import com.sethyandrak.obscurio.networking.packet.HealingSpellC2SPacket;
import com.sethyandrak.obscurio.networking.packet.IceAmmoSpellC2SPacket;
import com.sethyandrak.obscurio.networking.packet.MoffParticleS2CPacket;
import com.sethyandrak.obscurio.networking.packet.NormalAmmoSpellC2SPacket;
import com.sethyandrak.obscurio.networking.packet.PoisonAmmoSpellC2SPacket;
import com.sethyandrak.obscurio.networking.packet.SeekingSpellC2SPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class CustomMessages {
    private static SimpleChannel INSTANCE;
    private static int packetId;

    private static int id() {
        return packetId++;
    }

    public static void register() {
        SimpleChannel net;
        INSTANCE = net = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("obscurio", "messages")).networkProtocolVersion(() -> "1.0").clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).simpleChannel();
        net.messageBuilder(ExampleC2SPacket.class, CustomMessages.id(), NetworkDirection.PLAY_TO_SERVER).decoder(ExampleC2SPacket::new).encoder(ExampleC2SPacket::toBytes).consumer(ExampleC2SPacket::handle).add();
        net.messageBuilder(DashS2CPacket.class, CustomMessages.id(), NetworkDirection.PLAY_TO_CLIENT).decoder(DashS2CPacket::new).encoder(DashS2CPacket::toBytes).consumer(DashS2CPacket::handle).add();
        net.messageBuilder(MoffParticleS2CPacket.class, CustomMessages.id(), NetworkDirection.PLAY_TO_CLIENT).decoder(MoffParticleS2CPacket::new).encoder(MoffParticleS2CPacket::toBytes).consumer(MoffParticleS2CPacket::handle).add();
        net.messageBuilder(HealingSpellC2SPacket.class, CustomMessages.id(), NetworkDirection.PLAY_TO_SERVER).decoder(HealingSpellC2SPacket::new).encoder(HealingSpellC2SPacket::toBytes).consumer(HealingSpellC2SPacket::handle).add();
        net.messageBuilder(SeekingSpellC2SPacket.class, CustomMessages.id(), NetworkDirection.PLAY_TO_SERVER).decoder(SeekingSpellC2SPacket::new).encoder(SeekingSpellC2SPacket::toBytes).consumer(SeekingSpellC2SPacket::handle).add();
        net.messageBuilder(IceAmmoSpellC2SPacket.class, CustomMessages.id(), NetworkDirection.PLAY_TO_SERVER).decoder(IceAmmoSpellC2SPacket::new).encoder(IceAmmoSpellC2SPacket::toBytes).consumer(IceAmmoSpellC2SPacket::handle).add();
        net.messageBuilder(NormalAmmoSpellC2SPacket.class, CustomMessages.id(), NetworkDirection.PLAY_TO_SERVER).decoder(NormalAmmoSpellC2SPacket::new).encoder(NormalAmmoSpellC2SPacket::toBytes).consumer(NormalAmmoSpellC2SPacket::handle).add();
        net.messageBuilder(PoisonAmmoSpellC2SPacket.class, CustomMessages.id(), NetworkDirection.PLAY_TO_SERVER).decoder(PoisonAmmoSpellC2SPacket::new).encoder(PoisonAmmoSpellC2SPacket::toBytes).consumer(PoisonAmmoSpellC2SPacket::handle).add();
        net.messageBuilder(FailedSpellC2SPacket.class, CustomMessages.id(), NetworkDirection.PLAY_TO_SERVER).decoder(FailedSpellC2SPacket::new).encoder(FailedSpellC2SPacket::toBytes).consumer(FailedSpellC2SPacket::handle).add();
    }

    public static <MSG> void sendToServer(MSG message) {
        INSTANCE.sendToServer(message);
    }

    public static <MSG> void sendToPlayer(MSG message, ServerPlayer player) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    static {
        packetId = 0;
    }
}

