/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.api.datagen;

import com.klikli_dev.modonomicon.api.datagen.BookContextHelper;
import com.klikli_dev.modonomicon.api.datagen.ConditionHelper;
import com.klikli_dev.modonomicon.api.datagen.ModonomiconLanguageProvider;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookAndConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookOrConditionModel;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.text.MessageFormat;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_124;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public abstract class ModonomiconProviderBase {
    protected final String modId;
    protected final ModonomiconLanguageProvider lang;
    protected final Map<String, ModonomiconLanguageProvider> langs;
    protected final Map<String, BiConsumer<String, String>> langsAsBiConsumers;
    protected final BookContextHelper context;
    protected final ConditionHelper conditionHelper;
    private final Map<String, String> macros = new Object2ObjectOpenHashMap();
    private class_7225.class_7874 registries;

    protected ModonomiconProviderBase(String modId, BiConsumer<String, String> lang, Map<String, BiConsumer<String, String>> langs, BookContextHelper context, ConditionHelper conditionHelper) {
        this.modId = modId;
        this.lang = ModonomiconProviderBase.toLanguageProvider(lang);
        this.langs = ModonomiconProviderBase.toLanguageProvider(langs);
        this.langsAsBiConsumers = langs;
        this.context = context;
        this.conditionHelper = conditionHelper;
    }

    public static Map<String, ModonomiconLanguageProvider> toLanguageProvider(Map<String, BiConsumer<String, String>> translations) {
        Object2ObjectOpenHashMap result = new Object2ObjectOpenHashMap();
        translations.forEach((locale, consumer) -> result.put(locale, (Object)ModonomiconProviderBase.toLanguageProvider(consumer)));
        return result;
    }

    public static ModonomiconLanguageProvider toLanguageProvider(final BiConsumer<String, String> consumer) {
        return new ModonomiconLanguageProvider(){

            @Override
            public void accept(String s, String s2) {
                consumer.accept(s, s2);
            }
        };
    }

    protected String modId() {
        return this.modId;
    }

    protected class_7225.class_7874 registries() {
        return this.registries;
    }

    protected void registries(class_7225.class_7874 registries) {
        this.registries = registries;
    }

    protected ModonomiconLanguageProvider lang() {
        return this.lang;
    }

    protected ModonomiconLanguageProvider lang(String locale) {
        return this.langs.get(locale);
    }

    protected Map<String, ModonomiconLanguageProvider> langs() {
        return this.langs;
    }

    protected Map<String, BiConsumer<String, String>> langsAsMapOfBiConsumers() {
        return this.langsAsBiConsumers;
    }

    protected ConditionHelper condition() {
        return this.conditionHelper;
    }

    protected BookContextHelper context() {
        return this.context;
    }

    protected String path(String ... parts) {
        return String.join((CharSequence)"/", parts);
    }

    protected class_2960 modLoc(String ... idParts) {
        return class_2960.method_60655((String)this.modId, (String)this.path(idParts));
    }

    protected class_2960 modLoc(String name) {
        return class_2960.method_60655((String)this.modId, (String)name);
    }

    protected void registerMacro(String macro, String value) {
        this.macros.put(macro, value);
    }

    protected Map<String, String> macros() {
        return this.macros;
    }

    protected String macro(String input) {
        for (Map.Entry<String, String> entry : this.macros().entrySet()) {
            input = input.replace(entry.getKey(), entry.getValue());
        }
        return input;
    }

    protected String format(String pattern, Object ... arguments) {
        return MessageFormat.format(pattern, arguments);
    }

    protected String entryLink(String text, String category, String entry) {
        return this.format("[{0}](entry://{1}/{2})", text, category, entry);
    }

    protected String categoryLink(String text, String category) {
        return this.format("[{0}](category://{1})", text, category);
    }

    protected String itemLink(class_1935 item) {
        return this.itemLink("", item);
    }

    protected String itemLink(String text, class_1935 item) {
        class_2960 rl = class_7923.field_41178.method_10221((Object)item.method_8389());
        return this.format("[{0}](item://{1})", text, rl);
    }

    protected String commandLink(String text, String commandId) {
        return this.format("[{0}](command://{1})", text, commandId);
    }

    protected String entryLinkDummy(String text, String category, String entry) {
        return this.format("[{0}]()", text, category, entry);
    }

    protected String categoryLinkDummy(String text, String category) {
        return this.format("[{0}]()", text, category);
    }

    protected String color(String text, class_124 color) {
        return this.color(text, color.method_532());
    }

    protected String color(String text, int rgb) {
        return this.color(text, String.format("%06X", rgb));
    }

    protected String color(String text, String color) {
        return this.format("[#]({0}){1}[#]()", color, text);
    }

    public BookAndConditionModel and(BookConditionModel<?> ... children) {
        return this.condition().and(children);
    }

    public BookOrConditionModel or(BookConditionModel<?> ... children) {
        return this.condition().or(children);
    }

    protected void add(String key, String value) {
        this.lang().add(key, this.macro(value));
    }

    protected void add(ModonomiconLanguageProvider translation, String key, String value) {
        translation.add(key, this.macro(value));
    }

    protected void add(String key, String pattern, Object ... args) {
        this.add(key, this.format(pattern, args));
    }

    protected void add(ModonomiconLanguageProvider translation, String key, String pattern, Object ... args) {
        this.add(translation, key, this.format(pattern, args));
    }
}

