/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.api.datagen.book;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.datagen.book.BookCategoryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookCommandModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryParentModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookPageModel;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1935;
import net.minecraft.class_241;
import net.minecraft.class_2960;
import net.minecraft.class_7225;

public class BookEntryModel {
    protected class_2960 id;
    protected BookCategoryModel category;
    protected List<BookEntryParentModel> parents = new ArrayList<BookEntryParentModel>();
    protected String name;
    protected String description = "";
    protected BookIconModel icon;
    protected int x;
    protected int y;
    protected int entryBackgroundUIndex = 0;
    protected int entryBackgroundVIndex = 0;
    protected boolean hideWhileLocked;
    protected boolean showWhenAnyParentUnlocked;
    protected List<BookPageModel<?>> pages = new ArrayList();
    protected BookConditionModel<?> condition;
    protected class_2960 categoryToOpen;
    protected class_2960 commandToRunOnFirstRead;
    protected class_2960 entryToOpen;
    protected int sortNumber = -1;

    protected BookEntryModel(class_2960 id, String name) {
        this.id = id;
        this.name = name;
    }

    public static BookEntryModel create(class_2960 id, String name) {
        return new BookEntryModel(id, name);
    }

    public JsonObject toJson(class_7225.class_7874 provider) {
        JsonObject json = new JsonObject();
        if (this.category.getId().method_12836().equals(this.getId().method_12836())) {
            json.addProperty("category", this.category.id.method_12832());
        } else {
            json.addProperty("category", this.category.getId().toString());
        }
        json.addProperty("name", this.name);
        json.addProperty("description", this.description);
        json.add("icon", (JsonElement)this.icon.toJson(provider));
        json.addProperty("x", (Number)this.x);
        json.addProperty("y", (Number)this.y);
        json.addProperty("background_u_index", (Number)this.entryBackgroundUIndex);
        json.addProperty("background_v_index", (Number)this.entryBackgroundVIndex);
        json.addProperty("hide_while_locked", Boolean.valueOf(this.hideWhileLocked));
        json.addProperty("show_when_any_parent_unlocked", Boolean.valueOf(this.showWhenAnyParentUnlocked));
        if (!this.parents.isEmpty()) {
            JsonArray parentsArray = new JsonArray();
            for (BookEntryParentModel bookEntryParentModel : this.parents) {
                parentsArray.add((JsonElement)bookEntryParentModel.toJson(this.getId(), provider));
            }
            json.add("parents", (JsonElement)parentsArray);
        }
        if (!this.pages.isEmpty()) {
            JsonArray pagesArray = new JsonArray();
            for (BookPageModel bookPageModel : this.pages) {
                pagesArray.add((JsonElement)bookPageModel.toJson(this.getId(), provider));
            }
            json.add("pages", (JsonElement)pagesArray);
        }
        if (this.condition != null) {
            json.add("condition", (JsonElement)this.condition.toJson(this.getId(), provider));
        }
        if (this.categoryToOpen != null) {
            if (this.categoryToOpen.method_12836().equals(this.getId().method_12836())) {
                json.addProperty("category_to_open", this.categoryToOpen.method_12832());
            } else {
                json.addProperty("category_to_open", this.categoryToOpen.toString());
            }
        }
        if (this.commandToRunOnFirstRead != null) {
            if (this.commandToRunOnFirstRead.method_12836().equals(this.getId().method_12836())) {
                json.addProperty("command_to_run_on_first_read", this.commandToRunOnFirstRead.method_12832());
            } else {
                json.addProperty("command_to_run_on_first_read", this.commandToRunOnFirstRead.toString());
            }
        }
        if (this.entryToOpen != null) {
            if (this.entryToOpen.method_12836().equals(this.getId().method_12836())) {
                json.addProperty("entry_to_open", this.entryToOpen.method_12832());
            } else {
                json.addProperty("entry_to_open", this.entryToOpen.toString());
            }
        }
        json.addProperty("sort_number", (Number)this.sortNumber);
        return json;
    }

    public int getEntryBackgroundUIndex() {
        return this.entryBackgroundUIndex;
    }

    public int getEntryBackgroundVIndex() {
        return this.entryBackgroundVIndex;
    }

    public BookConditionModel<?> getCondition() {
        return this.condition;
    }

    public class_2960 getCategoryToOpen() {
        return this.categoryToOpen;
    }

    public class_2960 getCommandToRunOnFirstRead() {
        return this.commandToRunOnFirstRead;
    }

    public class_2960 getEntryToOpen() {
        return this.entryToOpen;
    }

    public class_2960 getId() {
        return this.id;
    }

    public BookCategoryModel getCategory() {
        return this.category;
    }

    public List<BookEntryParentModel> getParents() {
        return this.parents;
    }

    public void addParent(BookEntryParentModel parent) {
        this.parents.add(parent);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public BookIconModel getIcon() {
        return this.icon;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean hideWhileLocked() {
        return this.hideWhileLocked;
    }

    public boolean showWhenAnyParentUnlocked() {
        return this.showWhenAnyParentUnlocked;
    }

    public int getSortNumber() {
        return this.sortNumber;
    }

    public List<BookPageModel<?>> getPages() {
        return this.pages;
    }

    public BookEntryModel withId(class_2960 id) {
        this.id = id;
        return this;
    }

    public BookEntryModel withCategory(BookCategoryModel category) {
        this.category = category;
        return this;
    }

    public BookEntryModel withParents(List<BookEntryParentModel> parents) {
        this.parents = parents;
        return this;
    }

    public BookEntryModel withParents(BookEntryParentModel ... parents) {
        this.parents.addAll(List.of(parents));
        return this;
    }

    public BookEntryModel withParent(BookEntryParentModel parent) {
        this.parents.add(parent);
        return this;
    }

    public BookEntryModel withParent(BookEntryModel parent) {
        this.parents.add(BookEntryParentModel.create(parent.id));
        return this;
    }

    public BookEntryModel withName(String name) {
        this.name = name;
        return this;
    }

    public BookEntryModel withDescription(String description) {
        this.description = description;
        return this;
    }

    public BookEntryModel withIcon(BookIconModel icon) {
        this.icon = icon;
        return this;
    }

    public BookEntryModel withIcon(class_2960 texture) {
        this.icon = BookIconModel.create(texture);
        return this;
    }

    public BookEntryModel withIcon(class_2960 texture, int width, int height) {
        this.icon = BookIconModel.create(texture, width, height);
        return this;
    }

    public BookEntryModel withIcon(class_1935 item) {
        this.icon = BookIconModel.create(item);
        return this;
    }

    public BookEntryModel withLocation(class_241 location) {
        return this.withX((int)location.field_1343).withY((int)location.field_1342);
    }

    public BookEntryModel withLocation(int x, int y) {
        return this.withX(x).withY(y);
    }

    public BookEntryModel withX(int x) {
        this.x = x;
        return this;
    }

    public BookEntryModel withY(int y) {
        this.y = y;
        return this;
    }

    public BookEntryModel withEntryBackground(int u, int v) {
        this.entryBackgroundUIndex = u;
        this.entryBackgroundVIndex = v;
        return this;
    }

    public BookEntryModel withEntryBackground(Pair<Integer, Integer> uv) {
        this.entryBackgroundUIndex = (Integer)uv.getFirst();
        this.entryBackgroundVIndex = (Integer)uv.getSecond();
        return this;
    }

    public BookEntryModel hideWhileLocked(boolean hideWhileLocked) {
        this.hideWhileLocked = hideWhileLocked;
        return this;
    }

    public BookEntryModel showWhenAnyParentUnlocked(boolean showWhenAnyParentUnlocked) {
        this.showWhenAnyParentUnlocked = showWhenAnyParentUnlocked;
        return this;
    }

    public BookEntryModel withSortNumber(int sortNumber) {
        this.sortNumber = sortNumber;
        return this;
    }

    public BookEntryModel withPages(List<BookPageModel<?>> pages) {
        this.pages = pages;
        return this;
    }

    public BookEntryModel withPages(BookPageModel<?> ... pages) {
        this.pages.addAll(List.of(pages));
        return this;
    }

    public BookEntryModel withPage(BookPageModel<?> page) {
        this.pages.add(page);
        return this;
    }

    public BookEntryModel withCondition(BookConditionModel<?> condition) {
        this.condition = condition;
        return this;
    }

    public BookEntryModel withCategoryToOpen(class_2960 categoryToOpen) {
        this.categoryToOpen = categoryToOpen;
        return this;
    }

    public BookEntryModel withCommandToRunOnFirstRead(BookCommandModel bookCommandModel) {
        return this.withCommandToRunOnFirstRead(bookCommandModel.getId());
    }

    public BookEntryModel withCommandToRunOnFirstRead(class_2960 bookCommandModel) {
        this.commandToRunOnFirstRead = bookCommandModel;
        return this;
    }

    public BookEntryModel withEntryToOpen(class_2960 entryToOpen) {
        this.entryToOpen = entryToOpen;
        return this;
    }
}

