/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCategoryBackgroundParallaxLayer;
import com.klikli_dev.modonomicon.book.BookDisplayMode;
import com.klikli_dev.modonomicon.book.BookIcon;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.RenderedBookTextHolder;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookNoneCondition;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.util.BookGsonHelper;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7225;
import net.minecraft.class_9129;

public class BookCategory {
    protected class_2960 id;
    protected Book book;
    protected String name;
    protected BookIcon icon;
    protected BookTextHolder description;
    protected BookDisplayMode displayMode;
    protected int sortNumber;
    protected class_2960 background;
    protected int backgroundWidth;
    protected int backgroundHeight;
    protected int maxScrollX;
    protected int maxScrollY;
    protected float backgroundTextureZoomMultiplier;
    protected List<BookCategoryBackgroundParallaxLayer> backgroundParallaxLayers;
    protected class_2960 entryTextures;
    protected Map<class_2960, BookEntry> entries;
    protected BookCondition condition;
    protected boolean showCategoryButton;
    protected class_2960 entryToOpen;
    protected boolean openEntryToOpenOnlyOnce;

    public BookCategory(class_2960 id, String name, BookTextHolder description, int sortNumber, BookCondition condition, boolean showCategoryButton, BookIcon icon, BookDisplayMode displayMode, class_2960 background, int backgroundWidth, int backgroundHeight, int maxScrollX, int maxScrollY, float backgroundTextureZoomMultiplier, List<BookCategoryBackgroundParallaxLayer> backgroundParallaxLayers, class_2960 entryTextures, class_2960 entryToOpen, boolean openEntryOnlyOnce) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.sortNumber = sortNumber;
        this.condition = condition;
        this.showCategoryButton = showCategoryButton;
        this.icon = icon;
        this.displayMode = displayMode;
        this.background = background;
        this.backgroundWidth = backgroundWidth;
        this.backgroundHeight = backgroundHeight;
        this.maxScrollX = maxScrollX;
        this.maxScrollY = maxScrollY;
        this.backgroundTextureZoomMultiplier = backgroundTextureZoomMultiplier;
        this.backgroundParallaxLayers = backgroundParallaxLayers;
        this.entryTextures = entryTextures;
        this.entries = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
        this.entryToOpen = entryToOpen;
        this.openEntryToOpenOnlyOnce = openEntryOnlyOnce;
    }

    public static BookCategory fromJson(class_2960 id, JsonObject json, class_7225.class_7874 provider) {
        String name = class_3518.method_15265((JsonObject)json, (String)"name");
        BookTextHolder description = BookGsonHelper.getAsBookTextHolder(json, "description", BookTextHolder.EMPTY, provider);
        int sortNumber = class_3518.method_15282((JsonObject)json, (String)"sort_number", (int)-1);
        BookIcon icon = BookIcon.fromJson(json.get("icon"), provider);
        BookDisplayMode displayMode = BookDisplayMode.byName(class_3518.method_15253((JsonObject)json, (String)"display_mode", (String)BookDisplayMode.NODE.method_15434()));
        class_2960 background = class_2960.method_60654((String)class_3518.method_15253((JsonObject)json, (String)"background", (String)ModonomiconConstants.Data.Category.DEFAULT_BACKGROUND));
        int backgroundWidth = class_3518.method_15282((JsonObject)json, (String)"background_width", (int)512);
        int backgroundHeight = class_3518.method_15282((JsonObject)json, (String)"background_height", (int)512);
        int defaultMaxScrollX = class_3518.method_15282((JsonObject)json, (String)"max_scroll_x", (int)512);
        int defaultMaxScrollY = class_3518.method_15282((JsonObject)json, (String)"max_scroll_y", (int)512);
        float backgroundTextureZoomMultiplier = class_3518.method_15277((JsonObject)json, (String)"background_texture_zoom_multiplier", (float)1.0f);
        class_2960 entryTextures = class_2960.method_60654((String)class_3518.method_15253((JsonObject)json, (String)"entry_textures", (String)ModonomiconConstants.Data.Category.DEFAULT_ENTRY_TEXTURES));
        boolean showCategoryButton = class_3518.method_15258((JsonObject)json, (String)"show_category_button", (boolean)true);
        BookCondition condition = new BookNoneCondition();
        if (json.has("condition")) {
            condition = BookCondition.fromJson(id, json.getAsJsonObject("condition"), provider);
        }
        List<BookCategoryBackgroundParallaxLayer> backgroundParallaxLayers = List.of();
        if (json.has("background_parallax_layers")) {
            backgroundParallaxLayers = BookCategoryBackgroundParallaxLayer.fromJson(json.getAsJsonArray("background_parallax_layers"));
        }
        class_2960 entryToOpen = null;
        if (json.has("entry_to_open")) {
            String entryToOpenPath = class_3518.method_15265((JsonObject)json, (String)"entry_to_open");
            entryToOpen = entryToOpenPath.contains(":") ? class_2960.method_60654((String)entryToOpenPath) : class_2960.method_60655((String)id.method_12836(), (String)entryToOpenPath);
        }
        boolean openEntryOnlyOnce = class_3518.method_15258((JsonObject)json, (String)"open_entry_to_open_only_once", (boolean)true);
        return new BookCategory(id, name, description, sortNumber, condition, showCategoryButton, icon, displayMode, background, backgroundWidth, backgroundHeight, defaultMaxScrollX, defaultMaxScrollY, backgroundTextureZoomMultiplier, backgroundParallaxLayers, entryTextures, entryToOpen, openEntryOnlyOnce);
    }

    public static BookCategory fromNetwork(class_2960 id, class_9129 buffer) {
        String name = buffer.method_19772();
        BookTextHolder description = BookTextHolder.fromNetwork(buffer);
        int sortNumber = buffer.readInt();
        BookIcon icon = BookIcon.fromNetwork(buffer);
        BookDisplayMode displayMode = BookDisplayMode.byId(buffer.readByte());
        class_2960 background = buffer.method_10810();
        int backgroundWidth = buffer.method_10816();
        int backgroundHeight = buffer.method_10816();
        int defaultMaxScrollX = buffer.method_10816();
        int defaultMaxScrollY = buffer.method_10816();
        float backgroundTextureZoomMultiplier = buffer.readFloat();
        List backgroundParallaxLayers = buffer.method_34066(BookCategoryBackgroundParallaxLayer::fromNetwork);
        class_2960 entryTextures = buffer.method_10810();
        BookCondition condition = BookCondition.fromNetwork(buffer);
        boolean showCategoryButton = buffer.readBoolean();
        class_2960 entryToOpen = (class_2960)buffer.method_43827(class_2540::method_10810);
        boolean openEntryOnlyOnce = buffer.readBoolean();
        return new BookCategory(id, name, description, sortNumber, condition, showCategoryButton, icon, displayMode, background, backgroundWidth, backgroundHeight, defaultMaxScrollX, defaultMaxScrollY, backgroundTextureZoomMultiplier, backgroundParallaxLayers, entryTextures, entryToOpen, openEntryOnlyOnce);
    }

    public void toNetwork(class_9129 buffer) {
        buffer.method_10814(this.name);
        this.description.toNetwork(buffer);
        buffer.method_53002(this.sortNumber);
        this.icon.toNetwork(buffer);
        buffer.method_52997(this.displayMode.ordinal());
        buffer.method_10812(this.background);
        buffer.method_10804(this.backgroundWidth);
        buffer.method_10804(this.backgroundHeight);
        buffer.method_10804(this.maxScrollX);
        buffer.method_10804(this.maxScrollY);
        buffer.method_52941(this.backgroundTextureZoomMultiplier);
        buffer.method_34062(this.backgroundParallaxLayers, (buf, layer) -> layer.toNetwork((class_2540)buf));
        buffer.method_10812(this.entryTextures);
        BookCondition.toNetwork(this.condition, buffer);
        buffer.method_52964(this.showCategoryButton);
        buffer.method_43826((Object)this.entryToOpen, class_2540::method_10812);
        buffer.method_52964(this.openEntryToOpenOnlyOnce);
    }

    public void build(class_1937 level, Book book) {
        BookEntry entry;
        this.book = book;
        for (BookEntry entry2 : this.entries.values()) {
            BookErrorManager.get().getContextHelper().entryId = entry2.getId();
            entry2.build(level, this);
            BookErrorManager.get().getContextHelper().entryId = null;
        }
        if (this.entryToOpen != null && (entry = this.entries.get(this.entryToOpen)) == null) {
            BookErrorManager.get().error(MessageFormat.format("EntryToOpen \"{0}\" in Category \"{1}\" does not exist.", this.entryToOpen, this.getId()));
        }
    }

    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        if (!this.description.hasComponent()) {
            this.description = new RenderedBookTextHolder(this.description, textRenderer.render(this.description.getString()));
        }
        for (BookEntry entry : this.entries.values()) {
            BookErrorManager.get().getContextHelper().entryId = entry.getId();
            try {
                entry.prerenderMarkdown(textRenderer);
            }
            catch (Exception e) {
                BookErrorManager.get().error("Failed to render markdown in book '" + String.valueOf(this.book.getId()) + "' for entry '" + String.valueOf(entry.getId()) + "'", e);
            }
            BookErrorManager.get().getContextHelper().entryId = null;
        }
    }

    public class_2960 getId() {
        return this.id;
    }

    public Book getBook() {
        return this.book;
    }

    public String getName() {
        return this.name;
    }

    public BookTextHolder getDescription() {
        return this.description;
    }

    public int getSortNumber() {
        return this.sortNumber;
    }

    public BookIcon getIcon() {
        return this.icon;
    }

    public BookDisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public class_2960 getBackground() {
        return this.background;
    }

    public int getBackgroundWidth() {
        return this.backgroundWidth;
    }

    public int getBackgroundHeight() {
        return this.backgroundHeight;
    }

    public int getMaxScrollX() {
        return this.maxScrollX;
    }

    public int getMaxScrollY() {
        return this.maxScrollY;
    }

    public float getBackgroundTextureZoomMultiplier() {
        return this.backgroundTextureZoomMultiplier;
    }

    public List<BookCategoryBackgroundParallaxLayer> getBackgroundParallaxLayers() {
        return this.backgroundParallaxLayers;
    }

    public class_2960 getEntryTextures() {
        return this.entryTextures;
    }

    public Map<class_2960, BookEntry> getEntries() {
        return this.entries;
    }

    public void addEntry(BookEntry entry) {
        this.entries.putIfAbsent(entry.getId(), entry);
    }

    public BookEntry getEntry(class_2960 id) {
        return this.entries.get(id);
    }

    public BookCondition getCondition() {
        return this.condition;
    }

    public boolean openEntryToOpenOnlyOnce() {
        return this.openEntryToOpenOnlyOnce;
    }

    public class_2960 getEntryToOpen() {
        return this.entryToOpen;
    }

    public boolean showCategoryButton() {
        return this.showCategoryButton;
    }
}

