/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3518;
import org.jetbrains.annotations.Nullable;

public class BookCommand {
    protected class_2960 id;
    protected Book book;
    protected String command;
    protected int permissionLevel;
    protected int maxUses;
    @Nullable
    protected String failureMessage;
    @Nullable
    protected String successMessage;
    protected Set<class_2960> allowedEntries;

    public BookCommand(class_2960 id, String command, int permissionLevel, int maxUses, @Nullable String failureMessage, @Nullable String successMessage, @Nullable Set<class_2960> allowedEntries) {
        this.id = id;
        this.command = command;
        this.permissionLevel = permissionLevel;
        this.maxUses = maxUses;
        this.failureMessage = failureMessage;
        this.successMessage = successMessage;
        this.allowedEntries = allowedEntries == null ? Collections.emptySet() : allowedEntries;
    }

    public BookCommand(class_2960 id, String command, int permissionLevel, int maxUses, @Nullable String failureMessage, @Nullable String successMessage) {
        this(id, command, permissionLevel, maxUses, failureMessage, successMessage, null);
    }

    public static BookCommand fromJson(class_2960 id, JsonObject json) {
        String command = class_3518.method_15265((JsonObject)json, (String)"command");
        int permissionLevel = class_3518.method_15282((JsonObject)json, (String)"permission_level", (int)0);
        int maxUses = class_3518.method_15282((JsonObject)json, (String)"max_uses", (int)1);
        String failureMessage = class_3518.method_15253((JsonObject)json, (String)"failure_message", null);
        String successMessage = class_3518.method_15253((JsonObject)json, (String)"success_message", null);
        HashSet<class_2960> allowedEntries = new HashSet<class_2960>();
        if (json.has("allowed_entries")) {
            for (JsonElement e : class_3518.method_15261((JsonObject)json, (String)"allowed_entries")) {
                allowedEntries.add(class_2960.method_60654((String)e.getAsString()));
            }
        }
        return new BookCommand(id, command, permissionLevel, maxUses, failureMessage, successMessage, allowedEntries);
    }

    public static BookCommand fromNetwork(class_2960 id, class_2540 buffer) {
        String command = buffer.method_19772();
        byte permissionLevel = buffer.readByte();
        int maxUses = buffer.method_10816();
        String failureMessage = (String)buffer.method_43827(class_2540::method_19772);
        String successMessage = (String)buffer.method_43827(class_2540::method_19772);
        int allowedEntriesSize = buffer.method_10816();
        HashSet<class_2960> allowedEntries = new HashSet<class_2960>();
        for (int i = 0; i < allowedEntriesSize; ++i) {
            allowedEntries.add(buffer.method_10810());
        }
        return new BookCommand(id, command, permissionLevel, maxUses, failureMessage, successMessage, allowedEntries);
    }

    public void build(Book book) {
        this.book = book;
    }

    public void toNetwork(class_2540 buffer) {
        buffer.method_10814(this.command);
        buffer.method_52997(this.permissionLevel);
        buffer.method_10804(this.maxUses);
        buffer.method_43826((Object)this.failureMessage, class_2540::method_10814);
        buffer.method_43826((Object)this.successMessage, class_2540::method_10814);
        buffer.method_10804(this.allowedEntries.size());
        for (class_2960 entry : this.allowedEntries) {
            buffer.method_10812(entry);
        }
    }

    public class_2960 getId() {
        return this.id;
    }

    public Book getBook() {
        return this.book;
    }

    public String getCommand() {
        return this.command;
    }

    public int getPermissionLevel() {
        return this.permissionLevel;
    }

    public int getMaxUses() {
        return this.maxUses;
    }

    @Nullable
    public String getFailureMessage() {
        return this.failureMessage;
    }

    @Nullable
    public String getSuccessMessage() {
        return this.successMessage;
    }

    public Set<class_2960> getAllowedEntries() {
        return this.allowedEntries;
    }

    public void execute(class_3222 player) {
        if (!BookUnlockStateManager.get().canRunFor((class_1657)player, this)) {
            String failureMessage = this.failureMessage == null ? "modonomicon.command.failure" : this.failureMessage;
            player.method_64398((class_2561)class_2561.method_43471((String)failureMessage).method_27692(class_124.field_1061));
            return;
        }
        class_2168 commandSourceStack = new class_2168(player.method_64401(), player.method_73189(), player.method_5802(), player.method_51469(), this.permissionLevel, player.method_5477().getString(), player.method_5476(), player.method_51469().method_8503(), (class_1297)player).method_9231((success, result) -> {
            if (success) {
                BookUnlockStateManager.get().setRunFor((class_1657)player, this);
                if (this.successMessage != null) {
                    player.method_64398((class_2561)class_2561.method_43471((String)this.successMessage).method_27692(class_124.field_1060));
                }
            } else {
                Modonomicon.LOG.error("Command [" + this.id.toString() + "] was executed, but failed.");
            }
        });
        try {
            player.method_51469().method_8503().method_3734().method_44252(commandSourceStack, this.command);
        }
        catch (Exception e) {
            Modonomicon.LOG.error("Running command [" + this.id.toString() + "] failed: ", (Throwable)e);
        }
        BookUnlockStateManager.get().syncFor(player);
    }

    public boolean isEntryAllowed(class_2960 entry) {
        return this.allowedEntries.contains(entry);
    }
}

