/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book;

import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class BookFrameOverlay {
    public static final Codec<BookFrameOverlay> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)class_2960.field_25139.fieldOf("texture").forGetter(overlay -> overlay.texture), (App)Codec.SHORT.fieldOf("texture_width").forGetter(overlay -> (short)overlay.textureWidth), (App)Codec.SHORT.fieldOf("texture_height").forGetter(overlay -> (short)overlay.textureHeight), (App)Codec.SHORT.fieldOf("frame_width").forGetter(overlay -> (short)overlay.frameWidth), (App)Codec.SHORT.fieldOf("frame_height").forGetter(overlay -> (short)overlay.frameHeight), (App)Codec.SHORT.fieldOf("frame_x_offset").forGetter(overlay -> (short)overlay.frameXOffset), (App)Codec.SHORT.fieldOf("frame_y_offset").forGetter(overlay -> (short)overlay.frameYOffset)).apply((Applicative)builder, BookFrameOverlay::new));
    private final int textureHeight;
    private final int textureWidth;
    private final int frameWidth;
    private final int frameHeight;
    private final int frameXOffset;
    private final int frameYOffset;
    private final class_2960 texture;

    public BookFrameOverlay(class_2960 texture, int textureWidth, int textureHeight, int frameWidth, int frameHeight, int frameXOffset, int frameYOffset) {
        this.texture = texture;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.frameWidth = frameWidth;
        this.frameHeight = frameHeight;
        this.frameXOffset = frameXOffset;
        this.frameYOffset = frameYOffset;
    }

    public static BookFrameOverlay fromJson(JsonObject json) {
        return (BookFrameOverlay)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow();
    }

    public static BookFrameOverlay fromNetwork(class_2540 buffer) {
        return (BookFrameOverlay)buffer.method_49394(CODEC);
    }

    public void toNetwork(class_2540 buffer) {
        buffer.method_49395(CODEC, (Object)this);
    }

    public int getFrameU() {
        return this.textureWidth / 2 - this.frameWidth / 2;
    }

    public int getFrameV() {
        return this.textureHeight / 2 - this.frameHeight / 2;
    }

    public int getFrameX(int startX) {
        return startX - this.frameWidth / 2 + this.frameXOffset;
    }

    public int getFrameY(int startY) {
        return startY - this.frameHeight / 2 + this.frameYOffset;
    }

    public class_2960 getTexture() {
        return this.texture;
    }

    public int getTextureHeight() {
        return this.textureHeight;
    }

    public int getTextureWidth() {
        return this.textureWidth;
    }

    public int getFrameWidth() {
        return this.frameWidth;
    }

    public int getFrameHeight() {
        return this.frameHeight;
    }

    public int getFrameXOffset() {
        return this.frameXOffset;
    }

    public int getFrameYOffset() {
        return this.frameYOffset;
    }
}

