/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.data.BookDataManager;
import net.minecraft.class_2960;
import org.apache.commons.lang3.StringUtils;

public class BookLink {
    public static final String PROTOCOL_BOOK = "book://";
    public static final String PROTOCOL_CATEGORY = "category://";
    public static final String PROTOCOL_ENTRY = "entry://";
    public class_2960 bookId;
    public class_2960 categoryId;
    public class_2960 entryId;
    public Integer pageNumber;
    public String pageAnchor;

    private BookLink() {
    }

    private static BookLink fromBook(Book fromBook, String linkText) {
        linkText = linkText.substring(PROTOCOL_BOOK.length());
        BookLink bookLink = new BookLink();
        String[] parts = linkText.split("/", 2);
        bookLink.bookId = class_2960.method_12829((String)parts[0]);
        Book book = BookDataManager.get().getBook(bookLink.bookId);
        if (book == null) {
            throw new IllegalArgumentException("Invalid book link, book not found: " + linkText);
        }
        return bookLink;
    }

    private static BookLink fromCategory(Book fromBook, String linkText) {
        linkText = linkText.substring(PROTOCOL_CATEGORY.length());
        BookLink bookLink = new BookLink();
        if (linkText.contains(":")) {
            String[] parts = linkText.split("/", 2);
            bookLink.bookId = class_2960.method_12829((String)parts[0]);
            Book book = BookDataManager.get().getBook(bookLink.bookId);
            if (book == null) {
                throw new IllegalArgumentException("Invalid category link, book not found: " + linkText);
            }
            if (parts.length == 1) {
                throw new IllegalArgumentException("Invalid category link, does not contain any category id: " + linkText);
            }
            parts = parts[1].split("/", 2);
            bookLink.categoryId = class_2960.method_60655((String)bookLink.bookId.method_12836(), (String)parts[0]);
            BookCategory category = book.getCategory(bookLink.categoryId);
            if (category == null) {
                throw new IllegalArgumentException("Invalid category link, category not found in book: " + linkText);
            }
            return bookLink;
        }
        bookLink.bookId = fromBook.getId();
        if (linkText.isEmpty()) {
            throw new IllegalArgumentException("Invalid category link, does not contain any category id, because it is empty: " + linkText);
        }
        String[] parts = linkText.split("/", 2);
        bookLink.categoryId = class_2960.method_60655((String)bookLink.bookId.method_12836(), (String)parts[0]);
        BookCategory category = fromBook.getCategory(bookLink.categoryId);
        if (category == null) {
            throw new IllegalArgumentException("Invalid category link, category not found in book: " + linkText);
        }
        return bookLink;
    }

    private static BookLink fromEntry(Book fromBook, String linkText) {
        String entryId;
        int lastAtIndex;
        linkText = linkText.substring(PROTOCOL_ENTRY.length());
        BookLink bookLink = new BookLink();
        Book book = null;
        String[] parts = null;
        if (linkText.contains(":")) {
            parts = linkText.split("/", 2);
            bookLink.bookId = class_2960.method_12829((String)parts[0]);
            book = BookDataManager.get().getBook(bookLink.bookId);
            if (book == null) {
                throw new IllegalArgumentException("Invalid entry link, book not found: " + linkText);
            }
            if (parts.length == 1) {
                throw new IllegalArgumentException("Invalid entry link, does not contain any entry id: " + linkText);
            }
        } else {
            bookLink.bookId = fromBook.getId();
            book = fromBook;
            parts = new String[]{"", linkText};
        }
        if ((lastAtIndex = (entryId = parts[1]).lastIndexOf("@")) >= 0) {
            String postAt = entryId.substring(lastAtIndex + 1);
            String path = StringUtils.removeEnd((String)entryId.substring(0, lastAtIndex), (String)"/");
            bookLink.entryId = class_2960.method_60655((String)book.getId().method_12836(), (String)path);
            BookEntry entry = book.getEntry(bookLink.entryId);
            if (entry == null) {
                throw new IllegalArgumentException("Invalid entry link, entry not found in book: " + linkText);
            }
            bookLink.pageAnchor = postAt;
            if (entry.getPageNumberForAnchor(bookLink.pageAnchor) == -1) {
                throw new IllegalArgumentException("Invalid entry link, anchor not found in entry: " + linkText);
            }
            return bookLink;
        }
        int lastHashIndex = entryId.lastIndexOf("#");
        if (lastHashIndex >= 0) {
            String postHash = entryId.substring(lastHashIndex + 1);
            String path = StringUtils.removeEnd((String)entryId.substring(0, lastHashIndex), (String)"/");
            bookLink.entryId = class_2960.method_60655((String)book.getId().method_12836(), (String)path);
            if (book.getEntry(bookLink.entryId) == null) {
                throw new IllegalArgumentException("Invalid entry link, entry not found in book: " + linkText);
            }
            try {
                bookLink.pageNumber = Integer.parseInt(postHash);
                if (bookLink.pageNumber < 0 || bookLink.pageNumber >= book.getEntry(bookLink.entryId).getPages().size()) {
                    throw new IllegalArgumentException("Invalid entry link, page number not found in entry: " + linkText);
                }
            }
            catch (NumberFormatException e) {
                BookErrorManager.get().error("Invalid page number in entry link: " + linkText, e);
            }
            return bookLink;
        }
        bookLink.entryId = class_2960.method_60655((String)book.getId().method_12836(), (String)entryId);
        if (book.getEntry(bookLink.entryId) == null) {
            throw new IllegalArgumentException("Invalid entry link, entry not found in book: " + linkText);
        }
        return bookLink;
    }

    public static BookLink from(Book fromBook, String linkText) {
        if (linkText.toLowerCase().startsWith(PROTOCOL_BOOK)) {
            return BookLink.fromBook(fromBook, linkText);
        }
        if (linkText.toLowerCase().startsWith(PROTOCOL_CATEGORY)) {
            return BookLink.fromCategory(fromBook, linkText);
        }
        if (linkText.toLowerCase().startsWith(PROTOCOL_ENTRY)) {
            return BookLink.fromEntry(fromBook, linkText);
        }
        throw new IllegalArgumentException("Invalid book link, does not start with \"book://\", \"category://\" or \"entry://\": " + linkText);
    }

    public static boolean isBookLink(String linkText) {
        return linkText.toLowerCase().startsWith(PROTOCOL_BOOK) || linkText.toLowerCase().startsWith(PROTOCOL_CATEGORY) || linkText.toLowerCase().startsWith(PROTOCOL_ENTRY);
    }
}

