/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.conditions;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionContext;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionEntryContext;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_8824;
import net.minecraft.class_9129;

public class BookCategoryHasVisibleEntriesCondition
extends BookCondition {
    protected class_2960 categoryId;

    public BookCategoryHasVisibleEntriesCondition(class_2561 tooltip, class_2960 categoryId) {
        super(tooltip);
        this.categoryId = categoryId;
    }

    public static BookCategoryHasVisibleEntriesCondition fromJson(class_2960 conditionParentId, JsonObject json, class_7225.class_7874 provider) {
        String categoryPath = class_3518.method_15265((JsonObject)json, (String)"category_id");
        class_2960 categoryId = categoryPath.contains(":") ? class_2960.method_60654((String)categoryPath) : class_2960.method_60655((String)conditionParentId.method_12836(), (String)categoryPath);
        class_5250 tooltip = class_2561.method_43469((String)"tooltip.modonomicon.condition.has_visible_entries", (Object[])new Object[]{categoryId.method_42094()});
        return new BookCategoryHasVisibleEntriesCondition((class_2561)tooltip, categoryId);
    }

    @Override
    public void toNetwork(class_9129 buffer) {
        buffer.method_52964(this.tooltip != null);
        if (this.tooltip != null) {
            class_8824.field_48540.encode((Object)buffer, (Object)this.tooltip);
        }
        buffer.method_10812(this.categoryId);
    }

    public static BookCategoryHasVisibleEntriesCondition fromNetwork(class_9129 buffer) {
        class_2561 tooltip = buffer.readBoolean() ? (class_2561)class_8824.field_48540.decode((Object)buffer) : null;
        class_2960 entryId = buffer.method_10810();
        return new BookCategoryHasVisibleEntriesCondition(tooltip, entryId);
    }

    @Override
    public class_2960 getType() {
        return ModonomiconConstants.Data.Condition.CATEGORY_HAS_VISIBLE_ENTRIES;
    }

    @Override
    public boolean test(BookConditionContext context, class_1657 player) {
        BookCategory category = context.book.getCategory(this.categoryId);
        if (category == null) {
            throw new IllegalArgumentException("Category with id " + String.valueOf(this.categoryId) + " not found in book " + String.valueOf(context.getBook().getId()) + "for BookCategoryHasVisibleEntriesCondition. This happened while trying to unlock " + String.valueOf(context));
        }
        if (category.getEntries().isEmpty()) {
            return false;
        }
        for (BookEntry entry : category.getEntries().values()) {
            if (!entry.getEntryDisplayState(player).isVisible()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<class_2561> getTooltip(class_1657 player, BookConditionContext context) {
        if (this.tooltip == null && context instanceof BookConditionEntryContext) {
            BookConditionEntryContext entryContext = (BookConditionEntryContext)context;
            this.tooltip = class_2561.method_43469((String)"tooltip.modonomicon.condition.has_visible_entries", (Object[])new Object[]{class_2561.method_43471((String)entryContext.getBook().getEntry(this.categoryId).getName())});
        }
        return super.getTooltip(player, context);
    }
}

