/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.entries;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookAddress;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.data.BookPageJsonLoader;
import com.klikli_dev.modonomicon.data.LoaderRegistry;
import com.klikli_dev.modonomicon.data.NetworkLoader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7225;
import net.minecraft.class_9129;

public class BookContentEntry
extends BookEntry {
    protected List<BookPage> pages;

    public BookContentEntry(class_2960 id, BookEntry.BookEntryData data, class_2960 commandToRunOnFirstReadId, List<BookPage> pages) {
        super(id, data, commandToRunOnFirstReadId);
        this.pages = pages;
    }

    public static BookContentEntry fromJson(class_2960 id, JsonObject json, boolean autoAddReadConditions, class_7225.class_7874 provider) {
        BookEntry.BookEntryData data = BookEntry.BookEntryData.fromJson(id, json, autoAddReadConditions, provider);
        class_2960 commandToRunOnFirstReadId = null;
        if (json.has("command_to_run_on_first_read")) {
            String commandToRunOnFirstReadIdPath = class_3518.method_15265((JsonObject)json, (String)"command_to_run_on_first_read");
            commandToRunOnFirstReadId = commandToRunOnFirstReadIdPath.contains(":") ? class_2960.method_60654((String)commandToRunOnFirstReadIdPath) : class_2960.method_60655((String)id.method_12836(), (String)commandToRunOnFirstReadIdPath);
        }
        ArrayList<BookPage> pages = new ArrayList<BookPage>();
        if (json.has("pages")) {
            JsonArray jsonPages = class_3518.method_15261((JsonObject)json, (String)"pages");
            for (JsonElement pageElem : jsonPages) {
                BookErrorManager.get().setContext("Page Index: {}", pages.size());
                JsonObject pageJson = class_3518.method_15295((JsonElement)pageElem, (String)"page");
                class_2960 type = class_2960.method_60654((String)class_3518.method_15265((JsonObject)pageJson, (String)"type"));
                BookPageJsonLoader<? extends BookPage> loader = LoaderRegistry.getPageJsonLoader(type);
                BookPage page = loader.fromJson(id, pageJson, provider);
                pages.add(page);
            }
        }
        return new BookContentEntry(id, data, commandToRunOnFirstReadId, pages);
    }

    public static BookContentEntry fromNetwork(class_9129 buffer) {
        class_2960 id = buffer.method_10810();
        BookEntry.BookEntryData data = BookEntry.BookEntryData.fromNetwork(buffer);
        class_2960 commandToRunOnFirstReadId = (class_2960)buffer.method_43827(class_2540::method_10810);
        ArrayList<BookPage> pages = new ArrayList<BookPage>();
        int pageCount = buffer.method_10816();
        for (int i = 0; i < pageCount; ++i) {
            class_2960 type = buffer.method_10810();
            NetworkLoader<? extends BookPage> loader = LoaderRegistry.getPageNetworkLoader(type);
            BookPage page = loader.fromNetwork(buffer);
            pages.add(page);
        }
        return new BookContentEntry(id, data, commandToRunOnFirstReadId, pages);
    }

    @Override
    public class_2960 getType() {
        return ModonomiconConstants.Data.EntryType.CONTENT;
    }

    @Override
    public void toNetwork(class_9129 buffer) {
        buffer.method_10812(this.id);
        this.data.toNetwork(buffer);
        buffer.method_43826((Object)this.commandToRunOnFirstReadId, class_2540::method_10812);
        buffer.method_10804(this.pages.size());
        for (BookPage page : this.pages) {
            buffer.method_10812(page.getType());
            page.toNetwork(buffer);
        }
    }

    @Override
    public void build(class_1937 level, BookCategory category) {
        super.build(level, category);
        int pageNum = 0;
        for (BookPage page : this.pages) {
            BookErrorManager.get().getContextHelper().pageNumber = pageNum;
            page.build(level, this, pageNum);
            BookErrorManager.get().getContextHelper().pageNumber = -1;
            ++pageNum;
        }
    }

    @Override
    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        for (BookPage page : this.pages) {
            BookErrorManager.get().getContextHelper().pageNumber = page.getPageNumber();
            page.prerenderMarkdown(textRenderer);
            BookErrorManager.get().getContextHelper().pageNumber = -1;
        }
    }

    @Override
    public List<BookPage> getPages() {
        return this.pages;
    }

    @Override
    public List<BookPage> getUnlockedPagesFor(class_1657 player) {
        BookUnlockStateManager unlockManager = BookUnlockStateManager.get();
        return unlockManager.getUnlockedPagesFor(player, this);
    }

    @Override
    public int getPageNumberForAnchor(String anchor) {
        List<BookPage> pages = this.getPages();
        for (int i = 0; i < pages.size(); ++i) {
            BookPage page = pages.get(i);
            if (!anchor.equals(page.getAnchor())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean matchesQuery(String query, class_1937 level) {
        if (super.matchesQuery(query, level)) {
            return true;
        }
        for (BookPage page : this.getPages()) {
            if (!page.matchesQuery(query, level)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void openEntry(BookAddress address) {
        BookGuiManager.get().openContentEntry(this, address);
    }
}

