/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.error;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.entries.BookContentEntry;
import com.klikli_dev.modonomicon.book.error.BookErrorContextHelper;
import com.klikli_dev.modonomicon.book.error.BookErrorHolder;
import com.klikli_dev.modonomicon.book.error.BookErrorInfo;
import com.klikli_dev.modonomicon.book.page.BookPage;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.class_2960;
import org.slf4j.helpers.MessageFormatter;

public class BookErrorManager {
    private static final BookErrorManager instance = new BookErrorManager();
    private final Map<class_2960, BookErrorHolder> booksErrors = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
    private final BookErrorContextHelper contextHelper = new BookErrorContextHelper();
    private class_2960 currentBookId;
    private String currentContext;

    private BookErrorManager() {
    }

    public static BookErrorManager get() {
        return instance;
    }

    public void reset() {
        this.contextHelper.reset();
        this.booksErrors.clear();
        this.currentBookId = null;
        this.currentContext = null;
    }

    public BookErrorContextHelper getContextHelper() {
        return this.contextHelper;
    }

    public BookErrorHolder getErrors(class_2960 bookId) {
        return this.booksErrors.get(bookId);
    }

    public boolean hasErrors(class_2960 book) {
        BookErrorHolder holder = this.booksErrors.get(book);
        return holder != null && !holder.getErrors().isEmpty();
    }

    public void error(String message) {
        this.error(new BookErrorInfo(message, null, this.currentContext));
    }

    public void error(String message, Exception exception) {
        this.error(new BookErrorInfo(message, exception, this.currentContext));
    }

    public void error(BookErrorInfo error) {
        this.error(this.currentBookId, error);
    }

    public void error(class_2960 book, String message) {
        this.error(book, new BookErrorInfo(message, null, this.currentContext));
    }

    public void error(class_2960 book, String message, Exception exception) {
        this.error(book, new BookErrorInfo(message, exception, this.currentContext));
    }

    public void error(class_2960 book, BookErrorInfo error) {
        if (book == null) {
            Modonomicon.LOG.error("BookErrorManager.error() called with null book id with error: {}", (Object)error);
            return;
        }
        BookErrorHolder holder = this.booksErrors.get(book);
        if (holder == null) {
            holder = new BookErrorHolder();
            this.booksErrors.put(book, holder);
        }
        holder.addError(error);
        Modonomicon.LOG.warn("BookErrorManager.error() called for book: {} with error: {}", (Object)book, (Object)error);
    }

    public class_2960 getCurrentBookId() {
        return this.currentBookId;
    }

    public void setCurrentBookId(class_2960 id) {
        this.currentBookId = id;
    }

    public void setTo(BookPage page) {
        this.setTo(page.getParentEntry());
        BookErrorManager.get().getContextHelper().pageNumber = page.getPageNumber();
    }

    public void setTo(BookContentEntry entry) {
        BookErrorManager.get().setCurrentBookId(entry.getBook().getId());
        BookErrorManager.get().getContextHelper().reset();
        BookErrorManager.get().getContextHelper().categoryId = entry.getCategoryId();
        BookErrorManager.get().getContextHelper().entryId = entry.getId();
    }

    public void setContext(String context, Object ... args) {
        this.currentContext = context != null ? MessageFormatter.arrayFormat((String)context, (Object[])args).getMessage() : null;
    }

    public String getContext() {
        if (this.currentContext != null) {
            return this.currentContext;
        }
        return this.contextHelper.toString();
    }
}

