/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.page;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.RenderedBookTextHolder;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookNoneCondition;
import com.klikli_dev.modonomicon.book.entries.BookContentEntry;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.data.MultiblockDataManager;
import com.klikli_dev.modonomicon.util.BookGsonHelper;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7225;
import net.minecraft.class_9129;

public class BookMultiblockPage
extends BookPage {
    protected BookTextHolder multiblockName;
    protected BookTextHolder text;
    protected boolean showVisualizeButton;
    protected class_2960 multiblockId;
    protected Multiblock multiblock;

    public BookMultiblockPage(BookTextHolder multiblockName, BookTextHolder text, class_2960 multiblockId, boolean showVisualizeButton, String anchor, BookCondition condition) {
        super(anchor, condition);
        this.multiblockName = multiblockName;
        this.text = text;
        this.multiblockId = multiblockId;
        this.showVisualizeButton = showVisualizeButton;
    }

    public static BookMultiblockPage fromJson(class_2960 entryId, JsonObject json, class_7225.class_7874 provider) {
        BookTextHolder multiblockName = BookGsonHelper.getAsBookTextHolder(json, "multiblock_name", BookTextHolder.EMPTY, provider);
        String multiblockPath = class_3518.method_15265((JsonObject)json, (String)"multiblock_id");
        class_2960 multiblockId = multiblockPath.contains(":") ? class_2960.method_60654((String)multiblockPath) : class_2960.method_60655((String)entryId.method_12836(), (String)multiblockPath);
        BookTextHolder text = BookGsonHelper.getAsBookTextHolder(json, "text", BookTextHolder.EMPTY, provider);
        boolean showVisualizeButton = class_3518.method_15258((JsonObject)json, (String)"show_visualize_button", (boolean)true);
        String anchor = class_3518.method_15253((JsonObject)json, (String)"anchor", (String)"");
        BookNoneCondition condition = json.has("condition") ? BookCondition.fromJson(entryId, json.getAsJsonObject("condition"), provider) : new BookNoneCondition();
        return new BookMultiblockPage(multiblockName, text, multiblockId, showVisualizeButton, anchor, condition);
    }

    public static BookMultiblockPage fromNetwork(class_9129 buffer) {
        BookTextHolder multiblockName = BookTextHolder.fromNetwork(buffer);
        class_2960 multiblockId = buffer.method_10810();
        BookTextHolder text = BookTextHolder.fromNetwork(buffer);
        boolean showVisualizeButton = buffer.readBoolean();
        String anchor = buffer.method_19772();
        BookCondition condition = BookCondition.fromNetwork(buffer);
        return new BookMultiblockPage(multiblockName, text, multiblockId, showVisualizeButton, anchor, condition);
    }

    public boolean showVisualizeButton() {
        return this.showVisualizeButton;
    }

    public Multiblock getMultiblock() {
        return this.multiblock;
    }

    public BookTextHolder getMultiblockName() {
        return this.multiblockName;
    }

    public BookTextHolder getText() {
        return this.text;
    }

    @Override
    public class_2960 getType() {
        return ModonomiconConstants.Data.Page.MULTIBLOCK;
    }

    @Override
    public void build(class_1937 level, BookContentEntry parentEntry, int pageNum) {
        super.build(level, parentEntry, pageNum);
        this.multiblock = MultiblockDataManager.get().getMultiblock(this.multiblockId);
        if (this.multiblock == null) {
            throw new IllegalArgumentException("Invalid multiblock id " + String.valueOf(this.multiblockId));
        }
    }

    @Override
    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        super.prerenderMarkdown(textRenderer);
        if (!this.multiblockName.hasComponent()) {
            this.multiblockName = new BookTextHolder((class_2561)class_2561.method_43471((String)this.multiblockName.getKey()).method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_36139(this.getParentEntry().getCategory().getBook().getDefaultTitleColor())));
        }
        if (!this.text.hasComponent()) {
            this.text = new RenderedBookTextHolder(this.text, textRenderer.render(this.text.getString()));
        }
    }

    @Override
    public void toNetwork(class_9129 buffer) {
        this.multiblockName.toNetwork(buffer);
        buffer.method_10812(this.multiblockId);
        this.text.toNetwork(buffer);
        buffer.method_52964(this.showVisualizeButton);
        super.toNetwork(buffer);
    }

    @Override
    public boolean matchesQuery(String query, class_1937 level) {
        return this.multiblockName.getString().toLowerCase().contains(query) || this.text.getString().toLowerCase().contains(query);
    }
}

